/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.service.CtypeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CtypeServiceImpl
extends BaseDaoServiceImpl
implements CtypeService {
    private static final Log log = LogFactory.getLog(CtypeServiceImpl.class);

    public Long insert(Ctype ctype) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + ctype));
        if (ctype == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        ctype.setCreateAt(Long.valueOf(currentTimeMillis));
        ctype.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)ctype);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + ctype));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Ctype> insertList(List<Ctype> ctypeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (ctypeList == null ? "null" : Integer.valueOf(ctypeList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(ctypeList)) {
            return new ArrayList<Ctype>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Ctype ctype : ctypeList) {
            ctype.setCreateAt(Long.valueOf(currentTimeMillis));
            ctype.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(ctypeList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + ctypeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Ctype.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Ctype ctype) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (ctype == null ? "null" : ctype.getId())));
        boolean result = false;
        if (ctype == null) {
            return true;
        }
        ctype.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)ctype);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + ctype));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + ctype));
        }
        return result;
    }

    public boolean updateList(List<Ctype> ctypeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (ctypeList == null ? "null" : Integer.valueOf(ctypeList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(ctypeList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Ctype ctype : ctypeList) {
            ctype.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(ctypeList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + ctypeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + ctypeList.size()));
        return result;
    }

    public Ctype getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Ctype ctype = null;
        if (id == null) {
            return ctype;
        }
        try {
            ctype = (Ctype)this.dao.get(Ctype.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return ctype;
    }

    public List<Ctype> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List ctype = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Ctype>();
        }
        try {
            ctype = this.dao.getList(Ctype.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (ctype == null ? "null" : Integer.valueOf(ctype.size()))));
        return ctype;
    }

    public List<Long> getCtypeIdsByStatusOrderByCreateAt(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCtypeIdsByStatusOrderByCreateAt", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCtypeIdsByStatusOrderByCreateAt(Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCtypeIdsByStatusOrderByCreateAt", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCtypeIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCtypeIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCtypeIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCtypeIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCtypeIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

