/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.service.MessageService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageServiceImpl
extends BaseDaoServiceImpl
implements MessageService {
    private static final Log log = LogFactory.getLog(MessageServiceImpl.class);

    public Long insert(Message message) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + message));
        if (message == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        message.setCreateAt(Long.valueOf(currentTimeMillis));
        message.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)message);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + message));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Message> insertList(List<Message> messageList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (messageList == null ? "null" : Integer.valueOf(messageList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(messageList)) {
            return new ArrayList<Message>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Message message : messageList) {
            message.setCreateAt(Long.valueOf(currentTimeMillis));
            message.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(messageList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + messageList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Message.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Message message) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (message == null ? "null" : message.getId())));
        boolean result = false;
        if (message == null) {
            return true;
        }
        message.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)message);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + message));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + message));
        }
        return result;
    }

    public boolean updateList(List<Message> messageList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (messageList == null ? "null" : Integer.valueOf(messageList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(messageList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Message message : messageList) {
            message.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(messageList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + messageList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + messageList.size()));
        return result;
    }

    public Message getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Message message = null;
        if (id == null) {
            return message;
        }
        try {
            message = (Message)this.dao.get(Message.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return message;
    }

    public List<Message> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List message = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Message>();
        }
        try {
            message = this.dao.getList(Message.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (message == null ? "null" : Integer.valueOf(message.size()))));
        return message;
    }

    public List<Long> getMessageIdsBySendIdAndStatus(Long sendId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by sendId,status,start,limit  : " + sendId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMessageIdsBySendIdAndStatus", new Object[]{sendId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by sendId,status,start,limit)  : " + sendId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getMessageIdsByReceiveIdAndUnreadAndStatus(Long receiveId, Integer unread, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by receiveId,unread,status,start,limit  : " + receiveId + " , " + unread + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMessageIdsByReceiveIdAndUnreadAndStatus", new Object[]{receiveId, unread, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by receiveId,unread,status,start,limit)  : " + receiveId + " , " + unread + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getMessageIdsByReceiveIdAndUnreadAndStatusAndType(Long receiveId, Integer unread, Integer status, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by receiveId,unread,status,type,start,limit  : " + receiveId + " , " + unread + " , " + status + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMessageIdsByReceiveIdAndUnreadAndStatusAndType", new Object[]{receiveId, unread, status, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by receiveId,unread,status,type,start,limit)  : " + receiveId + " , " + unread + " , " + status + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getMessageIdsByReceiveIdAndStatus(Long receiveId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by receiveId,status,start,limit  : " + receiveId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMessageIdsByReceiveIdAndStatus", new Object[]{receiveId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by receiveId,status,start,limit)  : " + receiveId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getMessageIdsByReceiveIdAndStatusAndType(Long receiveId, Integer status, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by receiveId,status,type,start,limit  : " + receiveId + " , " + status + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMessageIdsByReceiveIdAndStatusAndType", new Object[]{receiveId, status, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by receiveId,status,type,start,limit)  : " + receiveId + " , " + status + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countMessageIdsBySendIdAndStatus(Long sendId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by sendId,status  : " + sendId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getMessageIdsBySendIdAndStatus", new Object[]{sendId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by sendId,status)  : " + sendId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countMessageIdsByReceiveIdAndStatus(Long receiveId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by receiveId,status  : " + receiveId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getMessageIdsByReceiveIdAndStatus", new Object[]{receiveId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by receiveId,status)  : " + receiveId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getMessageIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMessageIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countMessageIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getMessageIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getMessageIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getMessageIdsBySendIdAndStatusAndType(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by sendId  ================== " + uid));
        List idList = null;
        try {
            idList = this.dao.getIdList("getMessageIdsBySendIdAndStatusAndType", new Object[]{uid, uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)" ids by getMessageIdsBySendIdAndStatusAndType ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return idList;
    }

    public List<Long> getMessageIdsByReceiveIdAndStatusAndTypePrivate(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by receiveId  ================== " + uid));
        List idList = null;
        try {
            idList = this.dao.getIdList("getMessageIdsByReceiveIdAndStatusAndTypePrivate", new Object[]{uid, uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)" ids by getMessageIdsByReceiveIdAndStatusAndTypePrivate ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return idList;
    }

    public List<Long> getMessageIdsByReceiveIdAndSendId(Long uid, Long pid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by receiveId  ================== " + uid + "sendId" + pid));
        List idList = null;
        try {
            idList = this.dao.getIdList("getMessageIdsByReceiveIdAndSendId", new Object[]{uid, pid, uid, pid, pid, uid, pid, uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)" getMessageIdsByReceiveIdAndSendId is error ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return idList;
    }

    public List<Long> getMessagesTodayUnixList(Long uid, Long minTodayUnix, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by receiveId  ================== " + uid + "sendId" + minTodayUnix));
        List idList = null;
        limit = 500;
        try {
            idList = this.dao.getIdList("getMessagesTodayUnixList", new Object[]{uid, minTodayUnix}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)" getMessagesTodayUnixList is error ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return idList;
    }

    public Integer countMessagesBySendIdAndReceiveId(Long sendId, Long sreceiveId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by sendId,status  : " + sendId + " , " + sreceiveId));
        }
        Integer count = null;
        try {
            count = this.dao.count("countMessagesBySendIdAndReceiveId", new Object[]{sendId, sreceiveId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by sendId,status)  : " + sendId + " , " + sreceiveId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }
}

