package com.ptteng.common.skill.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Skill  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SkillController {
    private static final Log log = LogFactory.getLog(SkillController.class);

    @Autowired
    private UserService userService;

    @Autowired
    private ArticleService articleService;

    @Autowired
    private SkillService skillService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private DocumentService documentService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private TaskSkillRelationService taskSkillRelationService;

    @Autowired
    private UserClassRelationService userClassRelationService;

    @Autowired
    private ArticleTaskRelationService articleTaskRelationService;

    @Autowired
    private UserDocumentRelationService userDocumentRelationService;

    /**
     * @param
     * @return
     */
    //35、技能详情
    @RequestMapping(value = "/a/skill/detail/{sid}", method = RequestMethod.GET)
    public String getSkillDetail(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model, @PathVariable Long sid) throws Exception {

    	// 校验
		if (sid == null) {
			log.info("the sid is null");
			model.addAttribute("code", -14009);
			return "/common/success";
		}
		Skill skill = skillService.getObjectById(sid);
		if (skill == null) {
			log.info("the Skill is null");
			model.addAttribute("code", -14000);
			return "/common/success";
		}
        log.info("get skill, sid is  " + sid);

        
        try {
        	List<Long> childrenIds = new ArrayList<Long> ();	//返回子技能列表
            childrenIds =  skillService.getIdsByParentId(skill.getId(), 0, Integer.MAX_VALUE);
            log.info("childrenIds size =  " + childrenIds.size());
            if(childrenIds.size() > 0){
               List<Skill> children =  skillService.getObjectsByIds(childrenIds);
               model.addAttribute("children", children);
            }
            Skill parentSkill=this.skillService.getObjectById(skill.getParentId());

            model.addAttribute("code", 0);
            model.addAttribute("skill", skill);
            model.addAttribute("parent", parentSkill);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill error, sid is  " + sid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/skill/json/skillDetailJson";
    }

    // 9、技能信息读取
    @RequestMapping(value = "/a/skill/detail", method = RequestMethod.GET)
    public String getMultiUserJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Long[] sid)
            throws Exception {

        log.info(" ===================================================== ");
        List<Long> idList = new ArrayList();
        List<Skill> skillList = new ArrayList();

        if (sid == null) {
            log.info("not get any data ");
            model.addAttribute("code", -1000);
            return "/common/success";
        } else {
            idList = Arrays.asList(sid);
            log.info(idList + " want get detail info ");
            skillList = skillService.getObjectsByIds(idList);
            log.info("get skill data is " + skillList.size());
        }

        try {
            model.addAttribute("code", 0);
            model.addAttribute("total", skillList.size());

            model.addAttribute("skills", skillList);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get skill error,id is  " + idList);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/skill/json/skillListJson";
    }


    /**
     * 根据职业ID查询技能列表
     * @param request
     * @param response
     * @param model
     * @param occupationId
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    // 根据职业ID查询技能列表
    @RequestMapping(value = "/a/skill/list/{occupationId}", method = RequestMethod.GET)
    public String getSkillList(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model,
                               @PathVariable Long occupationId, Integer page, Integer size)
            throws Exception {
        log.info("get skill document : occupationId= " + occupationId+" page = "+page+" size = "+size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;




        try {

            List<Long> skillIds =   skillService.getIdsByOccupationId(occupationId, 0, Integer.MAX_VALUE);
            log.info(" skillIds size = "+skillIds.size());
            if(skillIds.size()>0){
                List<Skill> skills = skillService.getObjectsByIds(skillIds);
                model.addAttribute("skills",skills);
            }

            Integer total = skillService.countIdsByOccupationId(occupationId);
            boolean next = false;
            if(total>end){
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill document error,occupationId= " + occupationId);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/skill/json/skillListJson";
    }

    //36、登陆技能文档
    @RequestMapping(value = "/a/u/skill/document/{sid}", method = RequestMethod.GET)
    public String getSkillDocumentLogin(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long sid, Integer page, Integer size)
            throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

//        log.info("get skill document : sid= " + sid);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

//        log.info("get  user data is " + user);

        try {
            List<Long> documentIds = documentService.getDocumentIdBySidAndType(sid, 1, start, size);
//            log.info("get document data is " + documentIds);

            if(documentIds==null){
                log.info("document is null");
                model.addAttribute("code", -6002);
                return "/common/success";
            }

            List<Document> documents = documentService.getObjectsByIds(documentIds);

            log.info("-=-=-=-=-="+documents);

            Map<Long,Boolean> documentId_like = new HashMap<>();
            Map<Long,Boolean> documentId_collection = new HashMap<>();
            for(Long documentId : documentIds){

                Long   likeRelation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, documentId, 1, 1);
                Long collectionRlation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, documentId, 2, 1);

                if(likeRelation==null){
                    documentId_like.put(documentId,false);
                }else {
                    documentId_like.put(documentId,true);
                }
                if(collectionRlation==null){
                    documentId_collection.put(documentId,false);
                }else{
                    documentId_collection.put(documentId,true);
                }

            }

            Integer total = documentService.countDocumentIdBySidAndType(sid,1);
            boolean next = false;
            if(total>end){
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("documentId_like", documentId_like);
            model.addAttribute("documentId_collection", documentId_collection);
            model.addAttribute("documents", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill document error,sid= " + sid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/loginDocumentListJson";
    }

    //36、登陆技能视频
    @RequestMapping(value = "/a/u/skill/video/{sid}", method = RequestMethod.GET)
    public String getSkillVideoLogin(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model, @PathVariable Long sid, Integer page, Integer size)
            throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        log.info("get skill document : sid= " + sid);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        log.info("get  user data is " + user);

        try {
            List<Long> documentIds = documentService.getDocumentIdBySidAndType(sid, 2, start, size);
            log.info("get document data is " + documentIds);

            if(documentIds==null){
                log.info("document is null");
                model.addAttribute("code", -6002);
                return "/common/success";
            }

            List<Document> documents = documentService.getObjectsByIds(documentIds);

            Map<Long,Boolean> documentId_like = new HashMap<>();
            Map<Long,Boolean> documentId_collection = new HashMap<>();
            for(Long documentId : documentIds){
                Long likeRelation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatus(uid, documentId, 1);
                Long collectionRlation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatus(uid, documentId, 2);
                if(likeRelation==null){
                    documentId_like.put(documentId,false);
                }else {
                    documentId_like.put(documentId,true);
                }
                if(collectionRlation==null){
                    documentId_collection.put(documentId,false);
                }else{
                    documentId_collection.put(documentId,true);
                }

            }

            Integer total = documentService.countDocumentIdBySidAndType(sid,2);
            boolean next = false;
            if(total>end){
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", documents.size());
            model.addAttribute("documentId_like", documentId_like);
            model.addAttribute("documentId_collection", documentId_collection);
            model.addAttribute("documents", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill document error,sid= " + sid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/loginDocumentListJson";
    }


    //37、技能文档
    @RequestMapping(value = "/a/skill/document/{sid}", method = RequestMethod.GET)
    public String getSkillDocument(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long sid, Integer page, Integer size)
            throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        log.info("get skill document : sid= " + sid);
        try {
            List<Long> documentIds = documentService.getDocumentIdBySidAndType(sid, 1, start, size);
            log.info("get document data is " + documentIds);

            if(documentIds==null){
                log.info("document is null");
                model.addAttribute("code", -6002);
                return "/common/success";
            }

            List<Document> documents = documentService.getObjectsByIds(documentIds);
            Integer total = documentService.countDocumentIdBySidAndType(sid,1);
            boolean next = false;
            if(total>end){
                next = true;
            }

            List<Long> documentIds1 = documentService.getDocumentIdBySidAndType(sid, 1, 0, Integer.MAX_VALUE);
            Integer total1 = documentIds1.size();


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total1);
            model.addAttribute("documents", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill document error,sid= " + sid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentListJson";
    }

    //37、技能视频
    @RequestMapping(value = "/a/skill/video/{sid}", method = RequestMethod.GET)
    public String getSkillVedio(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long sid, Integer page, Integer size)
            throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        log.info("get skill document : sid= " + sid);
        try {
            List<Long> documentIds = documentService.getDocumentIdBySidAndType(sid,2,start,size);
            log.info("get document data is " + documentIds);

            if(documentIds==null){
                log.info("document is null");
                model.addAttribute("code", -6002);
                return "/common/success";
            }

            List<Document> documents = documentService.getObjectsByIds(documentIds);

            Integer total = documentService.countDocumentIdBySidAndType(sid,2);
            boolean next = false;
            if(total>end){
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", documents.size());
            model.addAttribute("documents", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill document error,sid= " + sid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentListJson";
    }

    //38、任务技能列表
    @RequestMapping(value = "/a/task/skill/list/{tid}", method = RequestMethod.GET)
    public String addSkillJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long tid) throws Exception {

        log.info("get task skill list : tid = " + tid);

        try {
            List<Long> relationIds = taskSkillRelationService.getTaskSkillRelationIdsByTid(tid, 0, Integer.MAX_VALUE);

            if(relationIds==null){
                log.info("the task skill is null");
                model.addAttribute("code", -6007);
                return "/common/success";
            }

            List<TaskSkillRelation> relations = taskSkillRelationService.getObjectsByIds(relationIds);

            List<Skill> skills = new ArrayList<>();
            for(TaskSkillRelation realtion:relations){
                Long sid = realtion.getSid();
                Skill skill = skillService.getObjectById(sid);
                skills.add(skill);
            }

            model.addAttribute("code", 0);
            model.addAttribute("total", skills.size());
            model.addAttribute("skills", skills);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add skill error ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/skill/json/skillListJson";
    }


    //34、职业任务技能
    @RequestMapping(value = "/a/occupation/task/skill/{oid}", method = RequestMethod.GET)
    public String countDocument(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long oid)
            throws Exception {


        log.info("get occupation skill : oid= " + oid);
        try {
            List<Long> taskIds = taskService.getTaskIdsByOid(oid, 0, Integer.MAX_VALUE);
            List<Task> tasks = taskService.getObjectsByIds(taskIds);

            if(taskIds==null) {
                log.info("no this skill");
                model.addAttribute("code", -6001);
                return "/common/success";
            }

            Map<Long,List<Skill>> tid_skills = new HashMap<>();
            Map<Long,Integer> sid_documentCount = new HashMap<>();
            Map<Long,Integer> sid_videoCount = new HashMap<>();
            for(Long tid:taskIds){
                List<Long> sids = taskSkillRelationService.getSkillIdsByTid(tid,0,Integer.MAX_VALUE);
                List<Skill> skills = skillService.getObjectsByIds(sids);
                tid_skills.put(tid, skills);
                for(Long sid:sids){
                    Integer documentCount = documentService.countDocumentIdBySidAndType(sid, 1);
                    Integer videoCount = documentService.countDocumentIdBySidAndType(sid, 2);
                    sid_documentCount.put(sid,documentCount);
                    sid_videoCount.put(sid,videoCount);
                }
            }


            model.addAttribute("code", 0);
            model.addAttribute("taskIds",taskIds);
            model.addAttribute("tasks",tasks);
            model.addAttribute("tid_skills",tid_skills);
            model.addAttribute("sid_documentCount",sid_documentCount);
            model.addAttribute("sid_videoCount",sid_videoCount);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get occupation skill error : oid= " + oid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/occupationSkillJson";
    }

    //35、任务相关日报
    @RequestMapping(value = "/a/task/daily/{tid}", method = RequestMethod.GET)
    public String getTaskDaily(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long tid, Integer page, Integer size)
            throws Exception {

        log.info("get task daily : tid= " + tid);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        try {

            Task task = taskService.getObjectById(tid);

            if(task.equals(null)) {
                log.info(tid+" no this task");
                model.addAttribute("code", -4008);
                return "/common/success";
            }

            List<Long> dailyIds = articleTaskRelationService.getDidsByTid(tid,start,size);

            Integer total = articleTaskRelationService.countDidsByTid(tid);

            List<Article> articles = articleService.getObjectsByIds(dailyIds);

            Map<Long,UserClassRelation> aid_relation = new HashMap<>();
            Map<Long,List<Task>> aid_taskList = new HashMap<>();
            Long relationId;
            UserClassRelation relation = new UserClassRelation();

            for(Article article:articles){
                Long aid = article.getId();
                relationId = userClassRelationService.getUserClassRelationIdByCidAndUid(article.getCid(), article.getUid());
                relation = userClassRelationService.getObjectById(relationId);
                aid_relation.put(aid, relation);
                List<Long> taskIdList = articleTaskRelationService.getTidsByDid(aid, 0, Integer.MAX_VALUE);
                List<Task> taskList = taskService.getObjectsByIds(taskIdList);
                aid_taskList.put(aid,taskList);
            }

            boolean next = false;
            if(total>end+1){
                next = true;
            }


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("articles",articles);
            model.addAttribute("aid_relation",aid_relation);
            model.addAttribute("aid_taskList",aid_taskList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get task daily error : tid= " + tid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/skill/json/taskDailyList";
    }

}

