package com.ptteng.common.skill.util;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Repository;
import org.springframework.ui.ModelMap;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by weijie on 2018/2/10.
 * 功能描述：抽取QuestionController重复的代码为本工具类的方法
 */
@Repository
public class QuestionCtrlUtil {

    private static final Log log = LogFactory.getLog(QuestionCtrlUtil.class);

    @Resource
    private UserService userService;

    @Resource
    private OccupationService occupationService;

    @Resource
    private QuestionService questionService;

    @Resource
    private AnswerService answerService;

    @Resource
    private LabelService labelService;

    @Resource
    private QuestionLabelRelationService questionLabelRelationService;

    @Resource
    private UserArticleRelationService userArticleRelationService;

    @Resource
    private CommonUtil commonUtil;

    //建立新的问题-标签关系
    public void updateQuestionLabelRelationship(Long questionId, Long userId, String labelIds, List<Long> labelIdList,
                                                List<Label> labelList, List<QuestionLabelRelation> questionLabelRelationList)
            throws ServiceException, ServiceDaoException {

        //把入参labelIds分解成字符串数组ids
        String[] ids = labelIds.split(",");

        //遍历ids
        for (String labelId : ids) {
            labelIdList.add(Long.valueOf(labelId));

            QuestionLabelRelation questionLabelRelation = new QuestionLabelRelation();
            questionLabelRelation.setQuestionId(questionId);
            questionLabelRelation.setLabelId(Long.valueOf(labelId));
            questionLabelRelation.setCreateBy(userId);
            questionLabelRelation.setUpdateBy(userId);
            questionLabelRelationList.add(questionLabelRelation);
        }
        //通过labelIdList得到一个labelList
        labelList = labelService.getObjectsByIds(labelIdList);
        //更新各个标签对应的问题数
        for (Label label : labelList) {
            label.setQuestionNum(label.getQuestionNum() + 1);
        }
        labelService.updateList(labelList);
        log.info("labelList size is " + labelList.size());

        //批量插入新的问题-标签关系
        questionLabelRelationService.insertList(questionLabelRelationList);
        log.info("questionLabelRelationList size is " + questionLabelRelationList.size());
    }

    //用户是否点赞过或者收藏过问答
    public void checkQuestionAndAnswerLikeOrCollection(Long curUserId, List<Long> questionIdList, List<Question> questionList,
                                                       List<Long> answerIdList, List<Answer> answerList) throws ServiceException, ServiceDaoException {
        //问题id不会为空，但是新增的提问回答为空，所以分开判断
        if (CollectionUtils.isEmpty(questionIdList)) {
            log.info(" questionIdList is null ");
        } else {
            //判断用户是否点赞或收藏问题
            checkQuestionLikeOrCollection(curUserId, questionIdList, questionList);
        }

        if (CollectionUtils.isEmpty(answerIdList)) {
            log.info(" answerIdList is null");
        } else {
            //判断用户是否点赞或收藏回答
            checkAnswerLikeOrCollection(curUserId, answerIdList, answerList);
        }

    }

    //拼接某个问题的所有回答者的昵称
    public Map<Long, String> getNickMap(List<Long> uidList, Map<Long, User> userMap, List<Long> occupationIds, Map<Long, Occupation> occupationMap) throws ServiceException, ServiceDaoException {

        Map<Long, String> nickMap = new HashMap<>();

        List<User> userList = userService.getObjectsByIds(uidList);
        //若该问题有回答，把回答者添加到userMap中;把回答者的职业id添加到occupationIds中
        for (User user : userList) {
            userMap.put(user.getId(), user);
            if (!user.getOid().equals(User.Occupation_None)) {
                occupationIds.add(user.getOid());
            }

        }
        //遍历回答者的职业，并添加到occupationMap中
        List<Occupation> occupations = occupationService.getObjectsByIds(occupationIds);
        for (Occupation occupation : occupations) {
            occupationMap.put(occupation.getId(), occupation);
        }

        //根据user和user对应的occupation拼出用户的名称并放到nickMap中
        for (User user : userList) {
            if (!user.getOid().equals(User.Occupation_None)) {
                nickMap.put(user.getId(), commonUtil.setUserShowName(user, occupationMap.get(user.getOid())));
            } else {
                nickMap.put(user.getId(), commonUtil.setUserShowName(user, null));
            }

        }

        return nickMap;
    }

    //获取当前登录的用户，返回model
    public ModelMap getCurUser(Long curUserId, ModelMap model) throws ServiceException, ServiceDaoException {

        User curUser = userService.getObjectById(curUserId);

        Map<Long, String> curNickMap = new HashMap<>();

        Long curUserOccupationId = curUser.getOid();
        if (!curUser.getOid().equals(User.Occupation_None)) {
            Occupation curUserOccupation = occupationService.getObjectById(curUserOccupationId);
            curNickMap.put(curUser.getId(), commonUtil.setUserShowName(curUser, curUserOccupation));
        } else {
            curNickMap.put(curUser.getId(), commonUtil.setUserShowName(curUser, null));
        }
        model.addAttribute("curUser", curUser);
        model.addAttribute("curNickMap", curNickMap);

        return model;
    }

    //获取标签map
    public Map<Long, Label> getLabelMap(List<Long> labelIdList) throws ServiceException, ServiceDaoException, NoSuchFieldException, IllegalAccessException {

        List<Label> labelList = labelService.getObjectsByIds(labelIdList);

        return (Map<Long, Label>) MyListUtil.convert2Map(Label.class.getDeclaredField("id"), labelList);
    }

    //判断用户是否点赞或收藏问题
    public void checkQuestionLikeOrCollection(Long userId, List<Long> questionIdList, List<Question> questionList) throws ServiceException, ServiceDaoException {

        if (CollectionUtils.isEmpty(questionIdList)) {
            log.info(" questionIdList is null ");
        } else {
            Integer targetType = UserArticleRelation.TARGET_QUESTION;
            Map<String, Object> curUserQuestionRelationParam = DynamicUtil.getArticleRelationListParam(questionIdList,
                    userId,targetType, false);
            log.info("query curUserQuestionRelation sql: " + curUserQuestionRelationParam);

            List<Long> curUserQuestionRelationIds = userArticleRelationService.getIdsByDynamicCondition(UserArticleRelation.class, curUserQuestionRelationParam, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(curUserQuestionRelationIds)) {
                log.info("curUserQuestionRelationIds has:" + curUserQuestionRelationIds);

                List<UserArticleRelation> curUserQuestionRelationList = userArticleRelationService.getObjectsByIds(curUserQuestionRelationIds);

                Map<Long, Integer> questionIfLikeMap = new HashedMap();
                Map<Long, Integer> questionIfCollectionMap = new HashedMap();

                for (UserArticleRelation curUserQuestionRelation : curUserQuestionRelationList) {
                    Integer status = curUserQuestionRelation.getType();
                    log.info(" relation id = " + curUserQuestionRelation.getId() + " aid = " + curUserQuestionRelation.getAid() + " relationStatus = " + status);

                    Long aid = curUserQuestionRelation.getAid();
                    //替换掉旧值
                    log.info(" questionIfLikeMap = " + questionIfLikeMap + " questionIfCollectionMap = " + questionIfCollectionMap);

                    updateRelationMap(aid, status, questionIfLikeMap, questionIfCollectionMap);

                    log.info(" questionIfLikeMap = " + questionIfLikeMap + " questionIfCollectionMap = " + questionIfCollectionMap);
                }

                for (Question question : questionList) {
                    Long aid = question.getId();
                    log.info(" aid = " + aid + " questionIfLikeMap = " + questionIfLikeMap + " questionIfCollectionMap = " + questionIfCollectionMap);
                    question.setIsAgree(questionIfLikeMap.get(aid) == null ? 0 : questionIfLikeMap.get(aid));
                }
            }
        }

    }

    //判断用户是否点赞或收藏回答
    public void checkAnswerLikeOrCollection(Long userId, List<Long> answerIdList, List<Answer> answerList) throws ServiceException, ServiceDaoException {

        if (CollectionUtils.isEmpty(answerIdList)) {
            log.info(" answerIdList is null ");
        } else {
            //生成用户和回答（article）列表的关系的动态查询条件
            Integer targetType = UserArticleRelation.TARGET_QUESTION;
            Map<String, Object> curUserAnswerRelationParam = DynamicUtil.getArticleRelationListParam(answerIdList,
                    userId, targetType,false);
            log.info("query curUserAnswerRelation sql: " + curUserAnswerRelationParam);

            //执行动态查询，得到用户和回答列表的关系ids
            List<Long> curUserAnswerRelationIds = userArticleRelationService.getIdsByDynamicCondition(UserArticleRelation.class, curUserAnswerRelationParam, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(curUserAnswerRelationIds)) {
                log.info("answerRelationIds has:" + curUserAnswerRelationIds);

                //获取用户和articleList的关系对象集合
                List<UserArticleRelation> curUserAnswerRelationList = userArticleRelationService.getObjectsByIds(curUserAnswerRelationIds);

                Map<Long, Integer> answerIfLikeMap = new HashedMap();
                Map<Long, Integer> answerIfCollectionMap = new HashedMap();

                //遍历用户和article的关系对象集合
                for (UserArticleRelation curUserArticleRelation : curUserAnswerRelationList) {
                    //获取用户和article的关系（1=点赞，2=收藏）
                    Integer status = curUserArticleRelation.getType();
                    log.info(" answerRelationStatus id = " + curUserArticleRelation.getId() + " aid = " + curUserArticleRelation.getAid() + " answerRelationStatus = " + status);

                    //获取articleId
                    Long aid = curUserArticleRelation.getAid();

                    //替换掉旧值
                    log.info(" answerIfLikeMap = " + answerIfLikeMap + " answerIfCollectionMap = " + answerIfCollectionMap);

                    updateRelationMap(aid, status, answerIfLikeMap, answerIfCollectionMap);

                    log.info(" answerIfLikeMap = " + answerIfLikeMap + " answerIfCollectionMap = " + answerIfCollectionMap);
                }

                for (Answer answerItem : answerList) {
                    Long aid = answerItem.getId();
                    log.info(" aid = " + aid + " answerIfLikeMap = " + answerIfLikeMap + " answerIfCollectionMap = " + answerIfCollectionMap);
                    answerItem.setIsLike(answerIfLikeMap.get(aid) == null ? 0 : answerIfLikeMap.get(aid));
                }
            }
        }
    }

    //私有的方法
    private void updateRelationMap(Long targetArticleId, Integer type, Map<Long, Integer> ifLikeMap, Map<Long, Integer> ifCollectionMap) {
        switch (type) {
            case UserArticleRelation.STATUS_LOVE:
                ifLikeMap.put(targetArticleId, 1);
                break;
            case UserArticleRelation.STATUS_COLLECTION:
                ifCollectionMap.put(targetArticleId, 1);
                break;
            default:
                break;
        }
    }
}
