package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Team;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.UserTeamRelation;
import com.ptteng.common.skill.service.TeamService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.service.UserTeamRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * UserTeamRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserTeamRelationController {
	private static final Log log = LogFactory.getLog(UserTeamRelationController.class);

	@Autowired
	private UserTeamRelationService userTeamRelationService;
	@Autowired
	private UserService userService;
	@Autowired
	private TeamService teamService;


	//组员列表 通过tid搜索
	@RequestMapping(value = "/a/members/detail", method = RequestMethod.GET)
	public String getUserTeamRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size, Long tid)
			throws Exception {

		log.info("get data : 小组id= " + tid);
		/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try {
			//获取组员id列表
			List<Long> memberIds=userTeamRelationService.getUserTeamRelationIdsByTidOrderByCreateAt(tid,start,Integer.MAX_VALUE);
//			log.info("get userTeamRelation data is " + userTeamRelation);
			//获取组员列表
			List<UserTeamRelation> userTeamRelationList=userTeamRelationService.getObjectsByIds(memberIds);

			model.addAttribute("code", 0);

			model.addAttribute("code", 0);
			model.addAttribute("total",userTeamRelationList.size());
			model.addAttribute("userTeamRelationList", userTeamRelationList);

			//获取用户和小组信息
			Set<Long> uids= new HashSet();
			Set<Long> tids = new HashSet();
			for (UserTeamRelation member:userTeamRelationList){
				if (member.getUid()>0){
					uids.add(member.getUid());
				}
				if (member.getTid()>0){
					tids.add(member.getTid());
				}
			}
			List<User> users = this.userService.getObjectsByIds(new ArrayList(uids));
			log.info("get users is "+users.size());
			List<Team> teams = this.teamService.getObjectsByIds(new ArrayList(tids));
			log.info("get teams is "+teams.size());

			model.addAttribute("users",users);
			model.addAttribute("teams",teams);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userTeamRelation error,id is  " );
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userTeamRelation/json/userTeamRelationListJson";
	}


	
	//组员列表
	@RequestMapping(value = "/a/members/search", method = RequestMethod.GET)
	public String getMultiUserTeamRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] uid)
			throws Exception {
			
		List<Long> uidList = new ArrayList();
		List<UserTeamRelation> userTeamRelationList = new ArrayList();
		List<Long> idList = new ArrayList();

		try {
			if (uid == null) {
				log.info("not get any data ");
				model.addAttribute("code", -1000);
				return "/common/success";
			} else {
				uidList = Arrays.asList(uid);
				log.info(uidList + " want get member detail  ");
				//获取组员ID列表
				int uidSize = uidList.size();
				log.info("用户id数组长度"+uidSize);
				for (int i=0;i<uidSize;i++){
					List<Long> memberIds = userTeamRelationService.getUserTeamRelationIdsByUidOrderByCreateAt(uidList.get(i),0,Integer.MAX_VALUE);
					int memberIdsSize = memberIds.size();
					for (int j=0;j<memberIdsSize;j++){
						idList.add(memberIds.get(j));
					}
				}
				//获取组员列表
				userTeamRelationList = userTeamRelationService.getObjectsByIds(idList);
				log.info("get member is "+uid);
			}

			log.info("组员列表"+userTeamRelationList);

			model.addAttribute("code", 0);
			model.addAttribute("total",userTeamRelationList.size());
			model.addAttribute("userTeamRelationList", userTeamRelationList);
			//获取用户和小组信息
			Set<Long> uids= new HashSet();
			Set<Long> tids = new HashSet();
			for (UserTeamRelation member:userTeamRelationList){
				if (member.getUid()>0){
					uids.add(member.getUid());
				}
				if (member.getTid()>0){
					tids.add(member.getTid());
				}
			}
			List<User> users = this.userService.getObjectsByIds(new ArrayList(uids));
			log.info("get users is "+users.size());
			List<Team> teams = this.teamService.getObjectsByIds(new ArrayList(tids));
			log.info("get teams is "+teams.size());

			model.addAttribute("users",users);
			model.addAttribute("teams",teams);


		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userTeamRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userTeamRelation/json/userTeamRelationListJson";
	}
	
	
	
	
	
}

