package com.ptteng.common.skill.controller;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.GetUserFromCookieUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.util.*;

/**
 * UserArticleRelation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserArticleRelationController {
    private static final Log log = LogFactory.getLog(UserArticleRelationController.class);

    @Autowired
    private UserArticleRelationService userArticleRelationService;

    @Autowired
    private ArticleService articleService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private UserService userService;

    @Autowired
    private ClassesService classesService;

    @Autowired
    private AnswerService answerService;

    @Autowired
    private QuestionService questionService;

    @Resource
    private MessageService messageService;

    @Autowired
    private GetUserFromCookieUtil getUserFromCookieUtil;


    /**
     * 1 点赞
     *
     * @param request
     * @param response
     * @param model
     * @param targetType     类型  1 日报-daily  2 文档-document  3 视频-video 4 问题-question 5 回答-answer
     * @param did      id
     * @param action   动作  点赞/收藏-love  取消点赞/收藏-dislike
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/love/{targetType}/{did}/{action}", method = RequestMethod.POST)
    public String loveJson(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model,
                           @PathVariable Integer targetType, @PathVariable Long did, @PathVariable String action) throws Exception {

        log.info(" love start,targetType =  " + targetType + " id = " + did + " action = " + action);
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        if (DataUtils.isNullOrEmpty(did)) {
            model.addAttribute("code", -1112);
            log.info("did is null");
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(targetType)) {
            model.addAttribute("code", -1113);
            log.info("targetType is null");
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(action)) {
            model.addAttribute("code", -1114);
            log.info("action is null");
            return "/common/failure";
        }

        try {
            Long userArticleId = null;
            Article article = null;
            Question question = null;
            Answer answer = null;

            // 1 判断类型
            if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                log.info(" update article love count ");
                article = articleService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(article)) {
                    log.info("get article error :article == null");
                    model.addAttribute("code", -5000);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_LOVE, UserArticleRelation.TARGET_DAILY);
            } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                log.info(" update question love count ");
                question = questionService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(question)) {
                    log.info("get question error :question == null");
                    model.addAttribute("code", -28006);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_LOVE, UserArticleRelation.TARGET_QUESTION);
            } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                log.info(" update answer love count ");
                answer = answerService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(answer)) {
                    log.info("get answer error :answer == null");
                    model.addAttribute("code", -29004);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_LOVE, UserArticleRelation.TARGET_ANSWER);
            }

            //2 判断动作  点赞
            if (UserArticleRelation.ACTION_LOVE.equals(action)) {
                log.info(" user " + uid + " love this article, article = " + did);
                log.info(" Does user " + uid + " have loved this article ? ");
                //判断之前是否存在关系，有则改变，无则新建
                if (DataUtils.isNotNullOrEmpty(userArticleId)) {
                    UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
                    log.info(" userArticleRelation weather = " + userArticleRelation.getWhether());
                    if (UserArticleRelation.WHETHER_VALID == userArticleRelation.getWhether()) {
                        log.info(" yes ,he loved");
                        model.addAttribute("code", -1115);
                        return "/common/failure";
                    } else {
                        log.info(" yes ,he canceled love ,now relove ");
                        userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                        userArticleRelation.setUpdateBy(uid);
                        userArticleRelationService.update(userArticleRelation);
                    }
                } else {
                    log.info(" no,he doesn't ");
                    UserArticleRelation userArticleRelation = new UserArticleRelation();
                    userArticleRelation.setTargetType(targetType);
                    userArticleRelation.setUid(uid);
                    userArticleRelation.setAid(did);
                    userArticleRelation.setType(UserArticleRelation.STATUS_LOVE);
                    userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                    userArticleRelation.setCreateBy(uid);
                    userArticleRelation.setUpdateBy(uid);
                    userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                    userArticleRelationService.insert(userArticleRelation);
                }
                // 更新article相关统计数据
                if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                    article.setLove(article.getLove() + 1);
                } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                    question.setAgreeNum(question.getAgreeNum() + 1);
                } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                    answer.setLikeNum(answer.getLikeNum() + 1);//回答的点赞数+1

                    //点赞数+1的同时，还要发一条通知消息
                    Message message = new Message();
                    message.setSendId(uid);//发信人id为当前登录的用户id
                    message.setReceiveId(answer.getCreateBy());//收信人为回答的创建人id
                    message.setSendName(userService.getObjectById(uid).getNick());
                    message.setReceiveName(userService.getObjectById(answer.getCreateBy()).getNick());
                    message.setContent(String.valueOf(answer.getId()));//当点赞的模板为1时，content字段的值为回答的id
                    message.setStatus(Message.STATUS_UNDELETE);
                    message.setUnread(Message.Status_Unread);
                    message.setType(Message.QUESTION_TYPE);//属于“question”类的消息
                    message.setTemplate(Message.TEMPLATE_1);//点赞的消息模本template=1
                    message.setRelationId(answer.getQuestionId());//为问题的id
                    message.setCreateBy(uid);
                    message.setUpdateBy(uid);

                    messageService.insert(message);
                }

            } else {
                //取消点赞
                log.info(" Does user " + uid + " have loved this did ? ");
                if (DataUtils.isNotNullOrEmpty(userArticleId)) {
                    UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
                    log.info(" userArticleRelation weather = " + userArticleRelation.getWhether());
                    if (UserArticleRelation.WHETHER_VALID == userArticleRelation.getWhether()) {
                        log.info(" yes ,he loved");
                        userArticleRelation.setWhether(UserArticleRelation.WHETHER_INVALID);
                        userArticleRelation.setUpdateBy(uid);
                        userArticleRelationService.update(userArticleRelation);
                    } else {
                        log.info(" no,he doesn't ");
                        model.addAttribute("code", -1116);
                        return "/common/failure";
                    }
                }
                // 更新article相关统计数据
                if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                    article.setLove(article.getLove() - 1);
                } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                    question.setAgreeNum(question.getAgreeNum() - 1);
                } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                    answer.setLikeNum(answer.getLikeNum() - 1);
                }
            }

            boolean isUpdate = false;
            if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                isUpdate = articleService.update(article);
            } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                isUpdate = questionService.update(question);
            } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                isUpdate = answerService.update(answer);
            }

            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add userArticleRelation error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    /**
     * 2 收藏
     *
     * @param request
     * @param response
     * @param model
     * @param targetType     类型  1 日报-daily  2 文档-document  3 视频-video
     * @param did      id
     * @param action   动作  点赞/收藏-love  取消点赞/收藏-dislike
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/collection/{targetType}/{did}/{action}", method = RequestMethod.POST)
    public String collectJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model,
                              @PathVariable Integer targetType, @PathVariable Long did, @PathVariable String action) throws Exception {

        log.info(" collection start,targetType =  " + targetType + " id = " + did + " action = " + action);
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        if (null == did) {
            model.addAttribute("code", -1112);
            log.info("did is null");
            return "/common/failure";
        }
        if (null == targetType) {
            model.addAttribute("code", -1113);
            log.info("targetType is null");
            return "/common/failure";
        }
        if (null == action) {
            model.addAttribute("code", -1114);
            log.info("action is null");
            return "/common/failure";
        }

        try {

            Long userArticleId = null;
            Article article = null;
            Question question = null;
            Answer answer = null;
            // 1 判断类型
            if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                log.info(" update article collection count ");
                article = articleService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(article)) {
                    log.info("get article error :article == null");
                    model.addAttribute("code", -5000);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.TARGET_DAILY);
            } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                log.info(" update question collection count ");
                question = questionService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(question)) {
                    log.info("get question error :question == null");
                    model.addAttribute("code", -28006);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.TARGET_QUESTION);
            } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                log.info(" update answer collection count ");
                answer = answerService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(answer)) {
                    log.info("get answer error :answer == null");
                    model.addAttribute("code", -29004);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.TARGET_ANSWER);
            }
            //2 判断动作  收藏
            if (UserArticleRelation.ACTION_LOVE.equals(action)) {
                log.info(" user " + uid + " collected this article ,id = " + did);
                log.info(" Does user " + uid + " have collected this article ? ");
                //判断之前是否存在关系，有则改变，无则新建   目前只有日报有收藏，问题和回答均无
                if (DataUtils.isNotNullOrEmpty(userArticleId)) {
                    UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
                    log.info(" userArticleRelation weather = " + userArticleRelation.getWhether());
                    if (UserArticleRelation.WHETHER_VALID == userArticleRelation.getWhether()) {
                        log.info(" yes ,he collected");
                        model.addAttribute("code", -1115);
                        return "/common/failure";
                    } else {
                        log.info(" yes ,he canceled collected ,now recollect ");
                        userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                        userArticleRelation.setUpdateBy(uid);
                        userArticleRelationService.update(userArticleRelation);
                    }

                } else {
                    log.info(" no,he doesn't ");
                    UserArticleRelation userArticleRelation = new UserArticleRelation();
                    userArticleRelation.setTargetType(targetType);
                    userArticleRelation.setUid(uid);
                    userArticleRelation.setAid(did);
                    userArticleRelation.setType(UserArticleRelation.STATUS_LOVE);
                    userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                    userArticleRelation.setCreateBy(uid);
                    userArticleRelation.setUpdateBy(uid);
                    userArticleRelationService.insert(userArticleRelation);
                }
                // 更新article相关统计数据
                if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                    article.setCollection(article.getCollection() + 1);
                } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                    log.info("question can't be collected");
                    model.addAttribute("code", -1118);
                    return "/common/failure";
                } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                    log.info("answer can't be  collected");
                    model.addAttribute("code", -1118);
                    return "/common/failure";
                }

            } else {
                //取消
                log.info(" Does user " + uid + " have collected this did ? ");
                if (DataUtils.isNotNullOrEmpty(userArticleId)) {
                    UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
                    log.info(" userArticleRelation weather = " + userArticleRelation.getWhether());
                    if (UserArticleRelation.WHETHER_VALID == userArticleRelation.getWhether()) {
                        log.info(" yes ,he collected");
                        userArticleRelation.setWhether(UserArticleRelation.WHETHER_INVALID);
                        userArticleRelation.setUpdateBy(uid);
                        userArticleRelationService.update(userArticleRelation);

                    } else {
                        log.info(" no,he doesn't ");
                        model.addAttribute("code", -1117);
                        return "/common/failure";
                    }
                }
                // 更新article相关统计数据
                if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                    article.setCollection(article.getCollection() - 1);
                } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                    log.info("question can't be collected");
                    model.addAttribute("code", -1118);
                    return "/common/failure";
                } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                    log.info("answer can't be  collected");
                    model.addAttribute("code", -1118);
                    return "/common/failure";
                }
            }


            boolean isUpdate = false;
            if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                isUpdate = articleService.update(article);
            } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                log.info("question can't be collected");
                model.addAttribute("code", -1118);
                return "/common/failure";
            } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                log.info("answer can't be  collected");
                model.addAttribute("code", -1118);
                return "/common/failure";
            }

            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add userArticleRelation error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 1 v点赞
     *
     * @param request
     * @param response
     * @param model
     * @param targetType     类型  1 日报-daily  2 文档-document  3 视频-video 4 问题-question 5 回答-answer
     * @param did      id
     * @param action   动作  点赞/收藏-love  取消点赞/收藏-dislike
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/v/love/{targetType}/{did}/{action}", method = RequestMethod.POST)
    public String vloveJson(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model,
                           @PathVariable Integer targetType, @PathVariable Long did, @PathVariable String action) throws Exception {

        log.info(" love start,targetType =  " + targetType + " id = " + did + " action = " + action);


        //未登录返回-2，前端模态框提示用户重新登录
        Long uid = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("uid is " + uid);
        if (DataUtils.isNullOrEmpty(uid)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "/common/failure";
        }

        if (null == did) {
            model.addAttribute("code", -1112);
            log.info("did is null");
            return "/common/failure";
        }
        if (null == targetType) {
            model.addAttribute("code", -1113);
            log.info("targetType is null");
            return "/common/failure";
        }
        if (null == action) {
            model.addAttribute("code", -1114);
            log.info("action is null");
            return "/common/failure";
        }

        try {

            Long userArticleId = null;
            Article article = null;
            Question question = null;
            Answer answer = null;
            // 1 判断类型
            if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                log.info(" update article love count ");
                article = articleService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(article)) {
                    log.info("get article error :article == null");
                    model.addAttribute("code", -5000);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_LOVE, UserArticleRelation.TARGET_DAILY);
            } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                log.info(" update question love count ");
                question = questionService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(question)) {
                    log.info("get question error :question == null");
                    model.addAttribute("code", -28006);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_LOVE, UserArticleRelation.TARGET_QUESTION);
            } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                log.info(" update answer love count ");
                answer = answerService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(answer)) {
                    log.info("get answer error :answer == null");
                    model.addAttribute("code", -29004);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_LOVE, UserArticleRelation.TARGET_ANSWER);
            }
            //2 判断动作  点赞
            if (UserArticleRelation.ACTION_LOVE.equals(action)) {
                log.info(" user " + uid + " love this article ,id = " + did);
                log.info(" Does user " + uid + " have loved this article ? ");
                //判断之前是否存在关系，有则改变，无则新建
                if (DataUtils.isNotNullOrEmpty(userArticleId)) {
                    UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
                    log.info(" userArticleRelation weather = " + userArticleRelation.getWhether());
                    if (UserArticleRelation.WHETHER_VALID == userArticleRelation.getWhether()) {
                        log.info(" yes ,he loved");
                        model.addAttribute("code", -1115);
                        return "/common/failure";
                    } else {
                        log.info(" yes ,he canceled love ,now relove ");
                        userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                        userArticleRelation.setUpdateBy(uid);
                        userArticleRelationService.update(userArticleRelation);
                    }

                } else {
                    log.info(" no,he doesn't ");
                    UserArticleRelation userArticleRelation = new UserArticleRelation();
                    userArticleRelation.setTargetType(targetType);
                    userArticleRelation.setUid(uid);
                    userArticleRelation.setAid(did);
                    userArticleRelation.setType(UserArticleRelation.STATUS_LOVE);
                    userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                    userArticleRelation.setCreateBy(uid);
                    userArticleRelation.setUpdateBy(uid);
                    userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                    userArticleRelationService.insert(userArticleRelation);
                }
                // 更新article相关统计数据
                if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                    article.setLove(article.getLove() + 1);
                } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                    question.setAgreeNum(question.getAgreeNum() + 1);
                } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                    answer.setLikeNum(answer.getLikeNum() + 1);

                    //发信人 && 收件人
                    User sender = userService.getObjectById(uid);
                    User receiver = userService.getObjectById(answer.getCreateBy());

                    //点赞数+1的同时，还要发一条通知消息
                    Message message = new Message();
                    message.setSendId(uid);//发信人id为当前登录的用户id
                    message.setReceiveId(answer.getCreateBy());//收信人为回答的创建人id
                    message.setSendName(sender.getNick());
                    message.setReceiveName(receiver.getNick());
                    message.setContent(String.valueOf(answer.getId()));//当点赞的模板为1时，content字段的值为回答的id
                    message.setStatus(Message.STATUS_UNDELETE);
                    message.setUnread(Message.Status_Unread);
                    message.setType(Message.QUESTION_TYPE);//属于“question”类的消息
                    message.setTemplate(Message.TEMPLATE_1);//点赞的消息模本template=1
                    message.setRelationId(answer.getQuestionId());//为问题的id
                    message.setCreateBy(uid);
                    message.setUpdateBy(uid);

                    Long messageId = messageService.insert(message);
                    //若消息发送成功，收件人未读消息+1，消息类型为“question”
                    if (DataUtils.isNotNullOrEmpty(messageId)) {
                        receiver.setIsLook(receiver.getIsLook() + 1);
                        receiver.setLatestMsg(Message.QUESTION_TYPE);
                        userService.update(receiver);
                    }
                }

            } else {
                //取消
                log.info(" Does user " + uid + " have loved this did ? ");
                if (DataUtils.isNotNullOrEmpty(userArticleId)) {
                    UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
                    log.info(" userArticleRelation weather = " + userArticleRelation.getWhether());
                    if (UserArticleRelation.WHETHER_VALID == userArticleRelation.getWhether()) {
                        log.info(" yes ,he loved");
                        userArticleRelation.setWhether(UserArticleRelation.WHETHER_INVALID);
                        userArticleRelation.setUpdateBy(uid);
                        userArticleRelationService.update(userArticleRelation);
                    } else {
                        log.info(" no,he doesn't ");
                        model.addAttribute("code", -1116);
                        return "/common/failure";
                    }
                }
                // 更新article相关统计数据
                if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                    article.setLove(article.getLove() - 1);
                } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                    question.setAgreeNum(question.getAgreeNum() - 1);
                } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                    answer.setLikeNum(answer.getLikeNum() - 1);
                }
            }

            boolean isUpdate = false;
            if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                isUpdate = articleService.update(article);
            } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                isUpdate = questionService.update(question);
            } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                isUpdate = answerService.update(answer);
            }

            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add userArticleRelation error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    /**
     * 2 v收藏
     *
     * @param request
     * @param response
     * @param model
     * @param targetType     类型  1 日报-daily  2 文档-document  3 视频-video
     * @param did      id
     * @param action   动作  点赞/收藏-love  取消点赞/收藏-dislike
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/v/collection/{targetType}/{did}/{action}", method = RequestMethod.POST)
    public String vcollectJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model,
                              @PathVariable Integer targetType, @PathVariable Long did, @PathVariable String action) throws Exception {

        log.info(" collection start,targetType =  " + targetType + " id = " + did + " action = " + action);

        //未登录返回-2，前端模态框提示用户重新登录
        Long uid = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("uid is " + uid);
        if (DataUtils.isNullOrEmpty(uid)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "/common/failure";
        }

        if (null == did) {
            model.addAttribute("code", -1112);
            log.info("did is null");
            return "/common/failure";
        }
        if (null == targetType) {
            model.addAttribute("code", -1113);
            log.info("targetType is null");
            return "/common/failure";
        }
        if (null == action) {
            model.addAttribute("code", -1114);
            log.info("action is null");
            return "/common/failure";
        }

        try {

            Long userArticleId = null;
            Article article = null;
            Question question = null;
            Answer answer = null;
            // 1 判断类型
            if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                log.info(" update article collection count ");
                article = articleService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(article)) {
                    log.info("get article error :article == null");
                    model.addAttribute("code", -5000);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.TARGET_DAILY);
            } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                log.info(" update question collection count ");
                question = questionService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(question)) {
                    log.info("get question error :question == null");
                    model.addAttribute("code", -28006);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.TARGET_QUESTION);
            } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                log.info(" update answer collection count ");
                answer = answerService.getObjectById(did);
                if (DataUtils.isNullOrEmpty(answer)) {
                    log.info("get answer error :answer == null");
                    model.addAttribute("code", -29004);
                    return "/common/failure";
                }
                userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(uid, did, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.TARGET_ANSWER);
            }
            //2 判断动作  收藏
            if (UserArticleRelation.ACTION_LOVE.equals(action)) {
                log.info(" user " + uid + " collected this article ,id = " + did);
                log.info(" Does user " + uid + " have collected this article ? ");
                //判断之前是否存在关系，有则改变，无则新建   目前只有日报有收藏，问题和回答均无
                if (DataUtils.isNotNullOrEmpty(userArticleId)) {
                    UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
                    log.info(" userArticleRelation weather = " + userArticleRelation.getWhether());
                    if (UserArticleRelation.WHETHER_VALID == userArticleRelation.getWhether()) {
                        log.info(" yes ,he collected");
                        model.addAttribute("code", -1115);
                        return "/common/failure";
                    } else {
                        log.info(" yes ,he canceled collected ,now recollect ");
                        userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                        userArticleRelation.setUpdateBy(uid);
                        userArticleRelationService.update(userArticleRelation);
                    }

                } else {
                    log.info(" no,he doesn't ");
                    UserArticleRelation userArticleRelation = new UserArticleRelation();
                    userArticleRelation.setTargetType(targetType);
                    userArticleRelation.setUid(uid);
                    userArticleRelation.setAid(did);
                    userArticleRelation.setType(UserArticleRelation.STATUS_LOVE);
                    userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
                    userArticleRelation.setCreateBy(uid);
                    userArticleRelation.setUpdateBy(uid);
                    userArticleRelationService.insert(userArticleRelation);
                }
                // 更新article相关统计数据
                if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                    article.setCollection(article.getCollection() + 1);
                } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                    log.info("question can't be collected");
                    model.addAttribute("code", -1118);
                    return "/common/failure";
                } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                    log.info("answer can't be  collected");
                    model.addAttribute("code", -1118);
                    return "/common/failure";
                }

            } else {
                //取消
                log.info(" Does user " + uid + " have collected this did ? ");
                if (DataUtils.isNotNullOrEmpty(userArticleId)) {
                    UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
                    log.info(" userArticleRelation weather = " + userArticleRelation.getWhether());
                    if (UserArticleRelation.WHETHER_VALID == userArticleRelation.getWhether()) {
                        log.info(" yes ,he collected");
                        userArticleRelation.setWhether(UserArticleRelation.WHETHER_INVALID);
                        userArticleRelation.setUpdateBy(uid);
                        userArticleRelationService.update(userArticleRelation);

                    } else {
                        log.info(" no,he doesn't ");
                        model.addAttribute("code", -1117);
                        return "/common/failure";
                    }
                }
                // 更新article相关统计数据
                if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                    article.setCollection(article.getCollection() - 1);
                } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                    log.info("question can't be collected");
                    model.addAttribute("code", -1118);
                    return "/common/failure";
                } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                    log.info("answer can't be  collected");
                    model.addAttribute("code", -1118);
                    return "/common/failure";
                }
            }


            boolean isUpdate = false;
            if (UserArticleRelation.TARGET_DAILY.equals(targetType)) {
                isUpdate = articleService.update(article);
            } else if (UserArticleRelation.TARGET_QUESTION.equals(targetType)) {
                log.info("question can't be collected");
                model.addAttribute("code", -1118);
                return "/common/failure";
            } else if (UserArticleRelation.TARGET_ANSWER.equals(targetType)) {
                log.info("answer can't be  collected");
                model.addAttribute("code", -1118);
                return "/common/failure";
            }

            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add userArticleRelation error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 获取用户点赞/收藏日报列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param type
     * @param orderBy
     * @param sort
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/daily/{type}/sort/list", method = RequestMethod.GET)
    public String getUserArticleRelationIdsByUidAndTypeAndWhetherJsonList(HttpServletRequest request,
                                                                          HttpServletResponse response, ModelMap model, Integer page,
                                                                          Integer size, @PathVariable Integer type, Integer orderBy, Integer sort, Long uid) throws Exception {
        log.info(" get user like dailys,type = " + type + " orderBy = " + orderBy + " sort = " + sort);
//			User user = (User)request.getAttribute("user");
//			Long uid = user.getId();
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            int limit = size + 1;
            boolean next = false;


            if (DataUtils.isNullOrEmpty(orderBy)) {
                orderBy = UserArticleRelation.ARTICLE_CREATE_AT;
            }
            if (DataUtils.isNullOrEmpty(sort)) {
                sort = UserArticleRelation.DESC;
            }
            if (sort != UserArticleRelation.ASC && sort != UserArticleRelation.DESC) {
                log.info(" sort value is not currect ");
                model.addAttribute("code", -1003);
                return "/data/json";
            }
            if (orderBy != UserArticleRelation.ARTICLE_CREATE_AT &&
                    orderBy != UserArticleRelation.LOVE &&
                    orderBy != UserArticleRelation.COLLECTION &&
                    orderBy != UserArticleRelation.COMMENT &&
                    orderBy != UserArticleRelation.READ) {
                log.info(" orderBy value is not currect ");
                model.addAttribute("code", -1003);
                return "/data/json";
            }

            Map<String, Object> map = DynamicUtil.getUserLoveArticleList(type, orderBy, sort, uid, false);
            List<Long> ids = articleService.getIdsByDynamicCondition(Article.class, map, start, limit);
            List<Article> articles = new ArrayList<>();
            if (CollectionUtils.isEmpty(ids)) {

            } else {
                articles = articleService.getObjectsByIds(ids);
                if (articles.size() >= size) {
                    articles = articles.subList(0, size);
                    next = true;
                }
            }

            int total = articleService.getIdsByDynamicCondition(Article.class, map, 0, Integer.MAX_VALUE).size();
            log.info("get userArticleRelation count is " + total);


            List<Task> tasks = new ArrayList();
            List<Classes> classes = new ArrayList();
            List<User> users = new ArrayList<>();


            Gson gson = new Gson();
            Type typeToken = new TypeToken<List<Long>>() {
            }.getType();
            Set<Long> uids = new HashSet();
            Set<Long> tids = new HashSet();
            Set<Long> cids = new HashSet();
            for (Article article : articles) {
                uids.add(article.getUid());
                cids.add(article.getCid());
                List<Long> taskIDS = gson.fromJson(article.getTids(), typeToken);
                if (taskIDS != null) {
                    tids.addAll(taskIDS);
                }


            }

            if (org.springframework.util.CollectionUtils.isEmpty(tids)) {

            } else {
                tasks = this.taskService.getObjectsByIds(new ArrayList(tids));
                log.info(" get tasks is " + tids);
            }


            if (org.springframework.util.CollectionUtils.isEmpty(uids)) {

            } else {
                users = this.userService.getObjectsByIds(new ArrayList(uids));
                log.info(" get user is " + uids);
                classes = this.classesService.getObjectsByIds(new ArrayList(cids));
            }

            //用户是否点赞过或者收藏过
            Map<Long, Boolean> iflikeMap = new HashedMap(),
                    ifCollectionMap = new HashedMap();
            Map<String, Object> paramRelation = DynamicUtil.getArticleRelationListParam(ids, uid, false);
            log.info("query relationId sql: " + paramRelation);
            List<Long> relationIds = userArticleRelationService.getIdsByDynamicCondition(UserArticleRelation.class, paramRelation, 0, Integer.MAX_VALUE);

            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relationIds)) {
                log.info("relationIds has:" + relationIds);
                List<UserArticleRelation> relationList = userArticleRelationService.getObjectsByIds(relationIds);

                int relationSize = relationList.size();
                for (int i = 0; i < relationSize; i++) {
                    UserArticleRelation relation = relationList.get(i);
                    Integer relationStatus = relation.getType();
                    log.info(" relation id = " + relation.getId() + " aid = " + relation.getAid() + " relationStatus = " + relationStatus);
                    Long aid = relation.getAid();

                /* 替换掉旧值 */
                    log.info(" iflikeMap = " + iflikeMap + " ifCollectionMap = " + ifCollectionMap);
                    switch (relationStatus) {
                        case UserArticleRelation.STATUS_LOVE:
                            iflikeMap.put(aid, true);
                            break;
                        case UserArticleRelation.STATUS_COLLECTION:
                            ifCollectionMap.put(aid, true);
                            break;
                        default:
                            break;
                    }
                    log.info(" iflikeMap = " + iflikeMap + " ifCollectionMap = " + ifCollectionMap);

                }
                for (int i = 0; i < articles.size(); i++) {
                    Article article = articles.get(i);
                    Long aid = article.getId();
                    log.info(" aid = " + aid + " iflikeMap = " + iflikeMap + " ifCollectionMap = " + ifCollectionMap);
                    article.setIfLike(iflikeMap.get(aid) == null ? false : iflikeMap.get(aid));
                    article.setIfCollection(ifCollectionMap.get(aid) == null ? false : ifCollectionMap.get(aid));
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("next", next);
            model.addAttribute("articles", articles);
            model.addAttribute("users", users);
            model.addAttribute("tasks", tasks);
            model.addAttribute("classesList", classes);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userArticleRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/article/json/articleListJson";
    }


    @RequestMapping(value = "/a/userArticleRelation2 ", method = RequestMethod.GET)
    public String getUserArticleRelationIdsByAidAndTypeAndWhetherJsonList(HttpServletRequest request,
                                                                          HttpServletResponse response, ModelMap model, Integer page,
                                                                          Integer size, Long aid, Integer type, Integer whether) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            List<Long> ids = userArticleRelationService.getUserArticleRelationIdsByAidAndTypeAndWhether(aid, type, whether, start, size);
            log.info("get countUserArticleRelationIdsByAidAndTypeAndWhether size is " + ids.size());

            List<UserArticleRelation> userArticleRelationList = userArticleRelationService.getObjectsByIds(ids);
            log.info("get userArticleRelation data is " + userArticleRelationList.size());

            Integer total = userArticleRelationService.countUserArticleRelationIdsByAidAndTypeAndWhether(aid, type, whether);
            log.info("get userArticleRelation count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("userArticleRelationList", userArticleRelationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userArticleRelation list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/userArticleRelation/json/userArticleRelationListJson";
    }


    @RequestMapping(value = "/a/userArticleRelation/{id}", method = RequestMethod.GET)
    public String getUserArticleRelationJson(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(id);
            log.info("get userArticleRelation data is " + userArticleRelation);

            model.addAttribute("code", 0);

            model.addAttribute("userArticleRelation", userArticleRelation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userArticleRelation error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/userArticleRelation/json/userArticleRelationDetailJson";
    }

    @RequestMapping(value = "/a/userArticleRelation/{id}", method = RequestMethod.PUT)
    public String updateUserArticleRelationJson(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, UserArticleRelation userArticleRelation) throws Exception {

        log.info("update userArticleRelation : userArticleRelation= " + userArticleRelation);

        try {

            userArticleRelationService.update(userArticleRelation);

            model.addAttribute("code", 0);

            model.addAttribute("userArticleRelation", userArticleRelation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update userArticleRelation error,id is  " + userArticleRelation.getId());
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/a/userArticleRelation/{id}", method = RequestMethod.DELETE)
    public String deleteUserArticleRelationJson(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete userArticleRelation : id= " + id);
        try {
            userArticleRelationService.delete(id);

            log.info("add userArticleRelation success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete userArticleRelation error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/a/multi/userArticleRelation", method = RequestMethod.GET)
    public String getMultiUserArticleRelationJson(HttpServletRequest request,
                                                  HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<UserArticleRelation> userArticleRelationList = userArticleRelationService.getObjectsByIds(idList);
            log.info("get  userArticleRelation data is " + userArticleRelationList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", userArticleRelationList.size());

            model.addAttribute("userArticleRelationList", userArticleRelationList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userArticleRelation error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/userArticleRelation/json/userArticleRelationListJson";
    }

    public static void main(String[] args) {
        Integer a = 1;
        a = a + 1;
        System.out.print(" a = " + a);

    }


}

