package com.ptteng.common.skill.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.Successor;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.SuccessorService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.ObjectConvertUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Successor  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SuccessorController {
	private static final Log log = LogFactory.getLog(SuccessorController.class);

	@Autowired
	private SuccessorService successorService;
	@Autowired
	private UserService userService;
	@Autowired
	private OccupationService occupationService;




	/**
	 * show 分院真传、职业信息
	 * @param  branchId 分院id
	 * @param  oid 职业id(暂时不用）
	 * @return java.lang.String
	 * @exception Exception 异常信息
	 * @author lishaobo
	 * @date    2018/5/5
	 */
	@RequestMapping(value = "/a/successor/search", method = RequestMethod.GET)
	public String getSuccessorDetail(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model,Long branchId,Long oid) throws Exception {

		log.info("getSuccessorDetail: branchId="+branchId+" ,oid="+oid);
		try {
			//取分院信息
			List<Long> ids = successorService.getSuccessorIdsByBranchId(branchId, 0, Integer.MAX_VALUE);
			List<Successor> successorList = successorService.getObjectsByIds(ids);
			log.info("successor list size is "+ids.size());

			//取负责人信息
			List<Long> uids = MyListUtil.getList(Successor.class.getDeclaredField("uid"), successorList);
			List<User> userList = userService.getObjectsByIds(uids);
			log.info("user list size is "+userList.size());

			//取职业信息
			List<Long> oids = MyListUtil.getList(Successor.class.getDeclaredField("oid"), successorList);
			List<Occupation> occupationList = occupationService.getObjectsByIds(oids);
			log.info("occupation list size is "+occupationList.size());
			//统计分院各职业信息
			Map<String,Object > countSqlMap=DynamicUtil.getOccupationStatisticsByStatusAndBranch(branchId,true);
			Object r = userService.getObjectByDynamicCondition(User.class, countSqlMap, 0, Integer.MAX_VALUE);
			List<Object[]> result = (List<Object[]>) ObjectConvertUtil.objectToArrayList(r);
			log.info(" result size is " + result.size());

			model.addAttribute("code", 0);
			model.addAttribute("successorList", successorList);
			model.addAttribute("userList", userList);
			model.addAttribute("occupationList", occupationList);
			model.addAttribute("result", result);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage(), t);
			log.error("get successor error,branchId is "+ branchId+" ,oid is "+oid);
			model.addAttribute("code", -1);
		}
		return "/common-skill-service/successor/json/successorListJson";
	}

	
}

