package com.ptteng.common.skill.controller;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Constant;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.Skill;
import com.ptteng.common.skill.service.ConstantService;
import com.ptteng.common.skill.service.OccupationService;


/**
 * OccupationType  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class OccupationController {
	private static final Log log = LogFactory.getLog(OccupationController.class);



    @Autowired
    private OccupationService occupationService;


    @Autowired
	private ConstantService constantService;






	
	
	
	
    //12、获取职业简要信息列表
    @RequestMapping(value = "/a/occupation/list", method = RequestMethod.GET)
    public String occupationInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        try {
            log.info("get occupation list");      
            List<Occupation> occupations=new ArrayList();
            List<Constant> constants=new ArrayList();

			List<Long> ids = occupationService.getOccupationIds( 0, Integer.MAX_VALUE);

			if(CollectionUtils.isEmpty(ids)){
				
				
				
			}else{
				occupations=this.occupationService.getObjectsByIds(ids);
				List<Long> constantIDS=this.constantService.getConstantIdsByType(Occupation.Constant_Type_occupation, 0, Integer.MAX_VALUE);
				
				if(CollectionUtils.isEmpty(constantIDS)){
					
				}else{
					constants=this.constantService.getObjectsByIds(constantIDS);
				}
				
			}
           
			log.info("get occupation size is "+occupations.size()+" and type is "+constants.size());

            model.addAttribute("code", 0);
            model.addAttribute("occupations", occupations);
            model.addAttribute("constants", constants);
   

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get occupation number error");
            model.addAttribute("code", -1);
        }


        return "/common-skill-service/occupation/json/occupationListJson";
    }



    //14、职业详情
    @RequestMapping(value = "/a/occupation/{oid}", method = RequestMethod.GET)
    public String occupationDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid) throws Exception {

        try {

            log.info(" ===================================================== ");
            log.info(oid+" get occupation detail ");

      
            Occupation occupation=new Occupation();
            
         
            	//获取Base
            	occupation = occupationService.getObjectById(oid);

         
            	
         
            //职业下的任务详情

            model.addAttribute("code", 0);
            model.addAttribute("occupation", occupation);
        
           


        } catch (Throwable t) {
        	t.printStackTrace();
        	log.error(t);
            log.error(t.getMessage());
            log.error("get occupation number error");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/occupation/json/occupationDetailJson";
    }
	
}

