package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Leaves;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.LeavesService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.LogUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Leave  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class LeavesController {
	private static final Log log = LogFactory.getLog(LeavesController.class);

	@Autowired
	private LeavesService leavesService;
	@Autowired
	private UserService userService;
	@Autowired
	private OccupationService occupationService;
	@Autowired
	private CookieUtil cookieUtil;

	//1 搜索用户请假列表
	@RequestMapping(value = "/a/u/leaves/search", method = RequestMethod.GET)
	public String searchLeavesList(
			HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long uid, String nick, Long oid, Integer identity, String type,
			Long startAt, Long endAt,
			Integer page, Integer size)
			throws Exception {

		//打印入参
		log.info("============================================");
		String paramStr = LogUtil.convertParam("/a/u/leaves/search  by==uid", uid, "nick", nick, "oid", oid,
				"identity", identity, "type", type, "startAt", startAt, "endAt", endAt, "page", page, "size", size);
		log.info(paramStr);

		if (uid == null) {
			model.addAttribute("code", -21000);
			log.info("uid is null");
			return "/common/success";
		}


		//初始化page size start
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
		log.info(pageStr);

		try {
			//初始值
			List<Long> userIdList = new ArrayList<>();
			List<Long> occupationIdList = new ArrayList<>();
			Long total = 0L;

			//动态查询-获取参数列表
			Map<String, Object> paramList = DynamicUtil.getLeavesListParam(uid,nick, oid, identity, type, startAt, endAt,false);
			log.info(" paramList size =  " + paramList.size());
			//获取请leavesIdList
			List<Long> leavesIdList = leavesService.getIdsByDynamicCondition(Leaves.class, paramList, start, size);
			if (CollectionUtils.isEmpty(leavesIdList)) {
				log.info(" leavesIdList is null ");
			} else {
				log.info(" leavesIdList size =  " + leavesIdList.size());
			}
			//获取total
			Map<String, Object> paramCount = DynamicUtil.getLeavesListParam(uid,nick, oid, identity, type, startAt, endAt,true);
			log.info("get param:" + paramCount);
			List<Long> leavesIdCount = leavesService.getIdsByDynamicCondition(Leaves.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("get leavesIdCount:" + leavesIdCount.size());
			if (CollectionUtils.isNotEmpty(leavesIdCount)) {
				total = leavesIdCount.get(0);
			}

			//获取leavesList
			List<Leaves> leavesList = leavesService.getObjectsByIds(leavesIdList);


			//获取用户IDList
			int leavesSize = leavesList.size();

			for (int i = 0; i < leavesSize; i++) {
				Leaves leaves = leavesList.get(i);
				userIdList.add(leaves.getUid());
			}
			//获取uesrList数据
			List<User> userList = userService.getObjectsByIds(userIdList);
			log.info("userList" + userList.size());

			//获取全部用户的职业ID
			int userSize = userList.size();
			log.info("userSize" + userSize);
			for (int n = 0; n < userSize; n++) {
				User user = userList.get(n);
				occupationIdList.add(user.getOid());
				log.info("occupationIdList" + occupationIdList);
			}

			// 获得occupationList
			List<Occupation> occupationList = occupationService.getObjectsByIds(occupationIdList);
			log.info("occupationList" + occupationList.size());
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("leavesList", leavesList);
			model.addAttribute("users", userList);
			model.addAttribute("occupations", occupationList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get leaves list error,page is " + page + " , size " + size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/leaves/json/leavesListJson";
	}

}

