package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.LabelService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.TaskService;
import com.ptteng.common.skill.util.LogUtil;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * Label  crud
 *
 * @author guchen
 * @Date 2018-01-19
 */
@Controller
public class LabelController {
    private static final Log log = LogFactory.getLog(LabelController.class);

    @Autowired
    private LabelService labelService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private CookieUtil cookieUtil;


    /**
     * 1 搜索标签列表
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param oid
     * @param tid
     * @param title
     * @param status
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/label/search", method = RequestMethod.GET)
    public String searchLabelList(
            HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long id, Long oid, Long tid, String title,
            Integer status, Integer page, Integer size)
            throws Exception {

        //打印入参
        log.info("============================================");
        String paramStr = LogUtil.convertParam("/a/label/search  by==id", id, "oid", oid, "tid", tid, "page", page, "size", size);
        log.info(paramStr);

        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);

        try {
            //初始值
            List<Long> labelIdList = new ArrayList<>();
            List<Long> oidList = new ArrayList<>();
            List<Long> tidList = new ArrayList<>();

            List<Label> labelList = new ArrayList<>();
            List<Occupation> occupationList = new ArrayList<>();
            List<Task> taskList = new ArrayList<>();
            //动态查询-获取参数列表
            Map<String, Object> paramList = DynamicUtil.getLabelListParam(id, oid, tid, title,Constants.STATUS_SHOW);
            log.info(" paramList size =  " + paramList.size());
            //获取list
            labelIdList = labelService.getIdsByDynamicCondition(Label.class, paramList, start, size);
            if (CollectionUtils.isEmpty(labelIdList)) {
                log.info(" labelIdList is null ");
                model.addAttribute("code", 0);
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
                return "/common-skill-service/label/json/labelListJson";
            } else {
                log.info(" labelIdList size =  " + labelIdList.size());

            }
            //获取total
            List<Long> allLabel = labelService.getIdsByDynamicCondition(Label.class, paramList, 0, Integer.MAX_VALUE);
            log.info("total is:" + allLabel.size());

            //获取相关关系list
            labelList = labelService.getObjectsByIds(labelIdList);
            for (Label label : labelList) {
                if (label.getOid() != null) {
                    oidList.add(label.getOid());
                }
                if (label.getTid()> 0) {
                    tidList.add(label.getTid());
                }
            }

            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
            }

            if (CollectionUtils.isEmpty(tidList)) {
                log.info(" tidList is null ");
            } else {
                log.info(" tidList size =  " + tidList.size());
                taskList = taskService.getObjectsByIds(tidList);
            }


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", labelList.size());
            model.addAttribute("total", allLabel.size());
            model.addAttribute("labelList", labelList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("taskList", taskList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get label list error,page is " + page + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/label/json/labelListJson";
    }
}

