package com.ptteng.common.skill.controller;

import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.PasswordUtils;


import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.CheckDataUtil;
import com.ptteng.common.skill.util.ConvertUtil;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.CalendarType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.management.LockInfo;
import java.util.*;

/**
 * Card  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CardController {
	private static final Log log = LogFactory.getLog(CardController.class);
	private static final Integer MAX_CESSIONS = 3;

	@Autowired
	private CardService cardService;

	@Autowired
	private CtypeService ctypeService;

	@Autowired
	private ClogService clogService;

	@Autowired
	private UserService userService;

	@Autowired
	private MessageService messageService;

	@Autowired
	private ClassesService classesService;

	@Autowired
	private UserStatisticsService userStatisticsService;


	/**
	 * 使用卡券
	 * @param id 卡券id
	 * @return json
	 * @throws Exception;
	 * */
	@RequestMapping(value = "/a/u/card/{id}/apply", method = RequestMethod.PUT)
	public String updateCards(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model,
							  @PathVariable Long id) throws Exception {

		// 传参检查
		log.info("update card id is: " + id);
		if (id == null) {
			model.addAttribute("code",-23004);
			return "/data/json";
		}

		// 根据id获取原来的卡券数据
		Card card = null;
		try {
			card = cardService.getObjectById(id);
			log.info("get card is success, by id: " + id);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23005);
			return "/data/json";
		}

		try {
            //卡券类型禁用，无法进行修改操作
            if (card.getTypeValid() == Ctype.Status_Disable ) {
                model.addAttribute("code",-23022);
                return "/data/json";
            }else {
                log.info(card.getTid() + " ctype is enabled!");
            }
        }catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update card error, id is " + id + " , ctype id is " + card.getTid());
            model.addAttribute("code", -23005);
            return "/data/json";
        }

		// 卡券禁用，无法进行修改操作
		if (card.getCardValid() == Card.CARD_VALID_DISABLE) {
			model.addAttribute("code",-23008);
			return "/data/json";
		} else {
			log.info(id + " card is enabled!");
		}

		//卡券状态为申请使用中的，无法进行修改操作
		if (card.getStatus().equals(Card.STATUS_VERIFICATING)) {
			log.info("the card has been submitted for application，cardId = " + id);
			model.addAttribute("code", -23024); //卡券已提出使用申请，请联系审核姐姐进行确认
			return "/data/json";
		}

		// 获得请求接口用户的id
		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		//检查请求发起人是否为卡券持有人
		if (CheckDataUtil.notEqual(uid, card.getOwnerId())) {
			model.addAttribute("code",-23009);
			return "/data/json";
		}

		//结业学员不可使用卡券
		if (DataUtils.isNotNullOrEmpty(user.getStatus()) && ObjectUtils.equals(User.STATUS_3, user.getStatus())) {
			log.info("user has graduated, can't use this card: uid = " + uid + ", cardId = " + id);
			model.addAttribute("code", -23023);
			return "/data/json";
		}

		card.setApplyAt(System.currentTimeMillis());
		card.setStatus(Card.STATUS_VERIFICATING);
		card.setUpdateBy(uid);
		try {
			Boolean isUpdate = cardService.update(card);
			if (isUpdate) {
				log.info("assign card update success");
				//设置用户卡券统计信息 核销中+1 未使用-1
				setUserStatistics(uid,Card.STATUS_VERIFICATING);

				//设置卡券类型统计信息 核销中+1 未使用-1
				setCardTypeStatistics(card.getTid(),Card.STATUS_VERIFICATING);

				//卡券记录
				Clog clog = ConvertUtil.card2Clog(Clog.TYPE_APPLY, card.getId(), card.getTid(), card.getAssignId(), uid, null, null,uid);
				Long clogId = clogService.insert(clog);
				log.info("insert clog, id is: " + clogId);

				//发送消息
				sendMessage(uid,null, Card.STATUS_VERIFICATING, card.getCode(), card.getTid());

				//给凡丽发审核消息
				sendMessage(Admin_fanli,uid, sendToAdmin, card.getCode(), card.getTid());

			} else {
				log.info("assign card update failed");
				model.addAttribute("code",-23007);
				return "/data/json";
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}


	/**
	 * 卡券转让
	 * @param mobile 卡券接收人手机号
	 * @param id 转让卡券id
	 * @param ownerId 卡券持有人
	 * @param pwd 卡券持有人密码
	 * @return json
	 * @throws Exception;
	 * */
	@RequestMapping(value = "/a/u/card/{id}/cession", method = RequestMethod.PUT)
	public String cessionCard(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model,
							  @PathVariable Long id, Long ownerId, String mobile, String pwd) throws Exception {

		log.info("card id is: " + id + ". mobile is: " + mobile + ". pwd is: " + pwd);
		// 传参检查
		if (id == null) {
			model.addAttribute("code",-23004);
			return "/data/json";
		}
		if (ownerId == null) {
			model.addAttribute("code",-23016);
			return "/data/json";
		}
		if (mobile == null) {
			model.addAttribute("code",-23012);
			return "/data/json";
		}
		if (pwd == null) {
			model.addAttribute("code",-23020);
			return "/data/json";
		}

		// 获取用户信息
		User user = (User) request.getAttribute("user");
		Long userId = user.getId();
		if (userId == null) {
			model.addAttribute("code", -2000);
			return "/common/success";
		}
		// 判断是否转让给本人
		String userMobile = user.getMobile();
		if (userMobile.equals(mobile)){
			model.addAttribute("code",-23021);
			return "/common/success";
		}

		// 验证密码
		String pass = PasswordUtils.encode(pwd);
		Boolean verify = user.getPwd().equals(pass);
		if (verify) {
			log.info(userId + " login ");
		} else {
			log.info(mobile + " wrong pwd " + pwd);
			model.addAttribute("code", -2006);
			return "/common/success";
		}

		// 根据id获取原来的卡券数据
		Card orignCard = new Card();
		try {
			orignCard = cardService.getObjectById(id);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23005);
		}

		// 检测卡券是不是ownerId的
		if (CheckDataUtil.notEqual(orignCard.getOwnerId(), userId)) {
			model.addAttribute("code",-23009);
			return "/data/json";
		}



		try	{
			//卡券类型禁用，无法操作
			if (orignCard.getTypeValid() == Ctype.Status_Disable) {
				model.addAttribute("code",-23022);
				return "/data/json";
			}else {
				log.info(orignCard.getTid() + " ctype is enabled!");
			}
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get ctype error,id is " + orignCard.getTid() );
			model.addAttribute("code", -23000);
			return "/data/json";
		}


		// 检测卡券禁用，无法进行修改操作
		if (orignCard.getCardValid() == Card.CARD_VALID_DISABLE) {
			model.addAttribute("code",-23008);
			return "/data/json";
		} else {
			log.info(id + " card is enabled!");
		}

		// 检测ownerId今日转让是否超过3次
		Integer[] typeList = {Clog.TYPE_CESSION};
		Map<String, Object>  ownerClogParam = DynamicUtil.getClogsQueryListParam(null, null,null,null,
				ownerId,null,null,typeList,MyTimeUtil.getTodayZeroTimeMillions(),System.currentTimeMillis(),null,null,null,null,null,null,null,null, true);
		List<Long> cessionList = clogService.getIdsByDynamicCondition(Clog.class, ownerClogParam, 0, Integer.MAX_VALUE);
		Integer cessionTimes = cessionList.get(0).intValue();
		log.info("card session times is: " + cessionTimes);
		if (cessionTimes >= MAX_CESSIONS) {
			model.addAttribute("code",-23017);
			return "/data/json";
		}

		//卡券接收人id
		Long otherUserId = userService.getUserIdByMobile(mobile);
		orignCard.setOwnerId(otherUserId);
		orignCard.setUpdateAt(System.currentTimeMillis());
		orignCard.setUpdateBy(userId);
		try {
			Boolean update = cardService.update(orignCard);
			if (update) {
				log.info("cession card update success.");
				//用户卡券统计信息 转让方 未使用-1 已转让+1
				setUserStatistics(ownerId,Card.STATUS_CESSION);
				//用户卡券统计信息 接收方 未使用+1
				setUserStatistics(otherUserId,Card.STATUS_ISSUED);

				//设置卡券类型统计 已转让+1
				setCardTypeStatistics(orignCard.getTid(),Card.STATUS_CESSION);

				//卡券记录
				Clog clog = ConvertUtil.card2Clog(Clog.TYPE_CESSION, orignCard.getId(), orignCard.getTid(), orignCard.getAssignId(), userId, otherUserId, null,userId);
				Long clogId = clogService.insert(clog);
				log.info("insert clog, id is: " + clogId);

				// 消息通知 uid：消息接收人、oid
				log.info("================sendMessage to uid===========================" + otherUserId);
				sendMessage(userId, otherUserId, Clog.TYPE_CESSION, orignCard.getCode(), orignCard.getTid());
				log.info("================sendMessage to oid===========================" + userId);
				sendMessage(otherUserId, userId, 10, orignCard.getCode(), orignCard.getTid());
			} else {
				log.info("cession card update failed.");
				model.addAttribute("code",-23007);
				return "/data/json";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}

	/**
	 * 卡券列表
	 * @param page 页数
	 * @param size 展示数
	 * @param code 卡券编号
	 * @param tid 卡券类型
	 * @param status 卡券状态
	 * @param sort 排序方式
	 * @return json
	 * @throws Exception;
	 * */
	@RequestMapping(value = "/a/u/card/search", method = RequestMethod.GET)
	public String getCardList(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model,
							  Integer page,
							  Integer size,
                              Integer cardValid,
							  Integer ctypeValid,
							  String code,
							  Long tid,
							  Integer status,
							  Integer sort
	) throws Exception {
		log.info("card list, code = " + code + ", tid = " + tid + ", cardValid = " + cardValid + ", ctypeValid = " + ctypeValid +", status = " + status +", sort = " + sort);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		//获取用户信息
		User user = (User) request.getAttribute("user");
		Long ownerId = user.getId();
		log.info("============userID is============" + ownerId);
		try {
			List<Long> ids;
			Integer total;
			//已转让卡券
			if(CheckDataUtil.isNotNull(status) && status == Card.STATUS_CESSION) {
				log.info("===========已转让卡券=============");
				//获取用户转让卡券记录
				Integer[] status_cession={Card.STATUS_CESSION};
				Map<String, Object> param =DynamicUtil.getClogsQueryListParam(code,tid,null,null,ownerId,null,null,status_cession,null,null,null,null,
						null,null,null,null,null,null,false);

				//已转让所有卡券记录ids
				List<Long> allClogIds = clogService.getIdsByDynamicCondition(Clog.class, param,0,Integer.MAX_VALUE);

				if (CollectionUtils.isEmpty(allClogIds)) {
					model.addAttribute("code",0);
					model.addAttribute("page", page);
					model.addAttribute("size", size);
					model.addAttribute("total", 0);
					model.addAttribute("cardList", allClogIds);
					return "/common-skill-service/card/json/cardListJson";
				} else {
					log.info("get card list ids length is: " + allClogIds.size());
				}

				//实例化卡券记录
				List<Clog> clogs = clogService.getObjectsByIds(allClogIds);
				log.info("get clogs object length is: " + clogs.size());

				//生成卡券ids
				List<Long> cids = new ArrayList<>();
				for (Clog clog:clogs){
					cids.add(clog.getCid());
				}
				//卡券ids转string
				String idsStr = org.apache.commons.lang3.StringUtils.join(cids,",");
				//生成ids排序sql语句
				Map<String, Object> param2 =DynamicUtil.getCardsQueryListOrderByParam(sort,idsStr);
				//排序后卡券ids
				ids = cardService.getIdsByDynamicCondition(Clog.class, param2, start, size);
				log.info("cession card ids is: " + ids);

				//已转让所有卡券ids
				List<Long> idsTotal = cardService.getIdsByDynamicCondition(Clog.class, param2, 0, Integer.MAX_VALUE);
				total = idsTotal.size();
				log.info("cession card total is: " + total);


			} else{
				Map<String, Object> param;
				//失效卡券（类型+卡券失效）
				if(CheckDataUtil.isNotNull(ctypeValid) && CheckDataUtil.isNotNull(cardValid) && ctypeValid.equals(Ctype.Status_Disable) && cardValid.equals(Card.CARD_VALID_DISABLE)){
					param = DynamicUtil.getCardsQueryListByCardValidAndTypeValidParam(code,tid,ownerId,status,cardValid,ctypeValid,sort,false);
				}else{
					param = DynamicUtil.getCardsQueryListParam(code,tid,ownerId,status,cardValid,ctypeValid,sort,false);
				}

				ids = cardService.getIdsByDynamicCondition(Card.class, param, start, size);

				total = cardService.getIdsByDynamicCondition(Card.class, param, 0, Integer.MAX_VALUE).size();

			}
			if (CollectionUtils.isEmpty(ids)) {
				model.addAttribute("code",0);
				model.addAttribute("page", page);
				model.addAttribute("size", size);
				model.addAttribute("total", 0);
				model.addAttribute("cardList", ids);
				return "/common-skill-service/card/json/cardListJson";
			} else {
				log.info("get card list ids length is: " + ids.size());
			}
			List<Card> cardList = cardService.getObjectsByIds(ids);
			log.info("get card list success, length is: " + cardList.size());


			// 获取type的内容
			List<Long> tids = new ArrayList<>();
			for (Card cardTemp : cardList) {
				tids.add(cardTemp.getTid());
			}
			List<Ctype> ctypeList = ctypeService.getObjectsByIds(tids);
			log.info("get card type list success, length is: " + tids);

			//设置用户卡券通知状态为已读，卡券统计暂未使用先注释
//			UserStatistics userStatistics = userStatisticsService.getObjectById(ownerId);
//			if (userStatistics.getCardNotice().equals(UserStatistics.Card_Notice_Unread)){
//				userStatistics.setCardNotice(UserStatistics.Card_Notice_Read);
//				userStatisticsService.update(userStatistics);
//			}else {
//				log.info("This user does not have a new card");
//			}
//			Integer total = cardList.size();
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("cardList", cardList);
			model.addAttribute("ctypeList", ctypeList);

		}  catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get card list error");
			model.addAttribute("code", -1);
		}


		return "/common-skill-service/card/json/cardListJson";
	}



	/**
	 * 卡券转让前验证手机和次数
	 * @param mobile 卡券接收人手机号
	 * @return json
	 * @throws Exception；
	 * */
	@RequestMapping(value = "/a/u/card/verify/{mobile}", method = RequestMethod.GET)
	public String verifyCard(HttpServletRequest request,
							 HttpServletResponse response,
							 ModelMap model,
							 @PathVariable String mobile) throws Exception {

		if (mobile == null) {
			model.addAttribute("code",-23012);
			return "/data/json";
		}

		// 根据mobile获取用户信息
		Long userId;
		User user;
		User owner;
		Classes classes;
		try {
			userId = userService.getUserIdByMobile(mobile);
			if (userId != null) {
				user = userService.getObjectById(userId);
				classes = classesService.getObjectById(user.getCid());
			} else {
				model.addAttribute("code",-23019);
				return "/data/json";
			}
			//设置卡券不能转让给自己
			owner =(User) request.getAttribute("user");
			if (user.getMobile().equals(owner.getMobile())){
				model.addAttribute("code",-23021);
				return "/data/json";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get user id error, mobile is " + mobile );
			model.addAttribute("code", -23015);
			return "/data/json";
		}

		
		// 检测ownerId今日转让是否超过3次
		Integer[] typeList = {Clog.TYPE_CESSION};
		Map<String, Object>  ownerClogParam = DynamicUtil.getClogsQueryListParam(null, null,null,null,
				owner.getId(),null,null,typeList,MyTimeUtil.getTodayZeroTimeMillions(),System.currentTimeMillis(),null,null,null,null,null,null,null,null, true);
		List<Long> cessionList = clogService.getIdsByDynamicCondition(Clog.class, ownerClogParam, 0, Integer.MAX_VALUE);
		log.info("cessionList is :" + cessionList);
		Integer cessionTimes = cessionList.get(0).intValue();
		log.info("card session times is: " + cessionTimes);


		model.addAttribute("code", 0);
		model.addAttribute("user", user);
		model.addAttribute("classes", classes);
		model.addAttribute("cessionTimes", cessionTimes);


		return "/common-skill-service/card/json/cardVerifyJson";


	}
	//守关大师前台id
	private static final Long Admin_fanli = 3576L;
	//给审核人发信息
	private static final Integer sendToAdmin = 10000;
	// 消息通知 uid:用户id oid：当前用户id type=10为给卡券接收人发信息 10000为给凡丽发消息
	private void sendMessage(Long uid, Long oid, Integer type, String code, Long tid) throws Exception {
		//参数校验
		log.info("send message args, uid: " + uid + ". oid: "+ oid +". type: " + type + ". code: " + code + ". tid: " + tid);


		try {
			// 获取用户信息 uid为消息接收人
			User user = userService.getObjectById(uid);

			String userName = user.getNick();

			log.info("user name is: " + userName);

			// 获取卡券类型信息
			Ctype ctype = ctypeService.getObjectById(tid);
			String title = ctype.getTitle();

			//存入系统消息
			Message message = new Message();
			message.setSendName("admin");
			message.setSendId(0L);
			message.setReceiveName(userName);
			message.setReceiveId(uid);
			message.setContent("");
			message.setStatus(1);
			message.setUnread(1);
			message.setType(Message.CARD_TYPE);
			Long mid = messageService.insert(message);

			//发送系统信息
			String content = "";
			if (type == Clog.TYPE_APPLY) {
				// 使用
				content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
						"您申请使用了一张<a data-mid=" + mid + " ng-click=\"sendAlertMsg(li.id);vm.goCard("+code+")\" class=\\\"font-orange\\\" target=\"_blank\" \\\">"+ title + "[" + code + "]" +"</a>，请等待审核" +
						"</span>";

			}else if (type.equals(sendToAdmin)) {
				User other = userService.getObjectById(oid);
				String otherName = other.getNick();
				content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
						"用户<span>"+
						"<a data-mid=" + mid +  " target=\"_blank\" href=\"/school/" + oid +"/class\"><span class=\"font-orange\">" + otherName + "</span></a>" +
						"申请使用了一张<a data-mid=" + mid + " ng-click=\"sendAlertMsg(li.id);vm.goCard("+code+")\" class=\\\"font-orange\\\" target=\"_blank\" \\\">"+ title + "[" + code + "]" +"</a>，请进入后台审核" +
						"</span>";
			} else if (oid!=null) {
				User other = userService.getObjectById(oid);
				String otherName = other.getNick();
				if (type == Clog.TYPE_CESSION ) {
					// 转让：你给{被转让人名称}转让了一张{卡券类型名称}
					content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
							"您给<span class=\"font-green\">"+
							"<a data-mid=" + mid +  " target=\"_blank\" href=\"/school/" + oid +"/class\"><span class=\"font-orange\">" + otherName + "</span></a>" +
							"</span>转让了一张" +
							"<a data-mid=" + mid + "  ng-click=\"sendAlertMsg(li.id);vm.goCard("+code+")\" class=\\\"font-orange\\\">"+ title + "[" + code + "]" +"</a>" +
							"</span>";
				}else {
					// {转让人名称}给你转让了一张{卡券类型名称}
					content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
							"<a data-mid=" + mid + " target=\"_blank\" href=\"/school/" + oid +"/class\"><span class=\"font-orange\">" + otherName + "</span></a>" +
							"<span>给您转让了一张</span>" +
							"<a data-mid=" + mid + "  ng-click=\"sendAlertMsg(li.id);vm.goCard("+code+")\" class=\\\"font-orange\\\">"+ title + "[" + code + "]" +"</a>" +
							"</span>";
				}

			} else {
				log.info("message error");
				return;
			}

			adminSend(user.getMobile(), content);
			message = messageService.getObjectById(mid);
			message.setContent(content);
			log.info("message mid is " + mid);

			Boolean result = messageService.update(message);
			log.info("message update result is " + result);


			//更新用户信息
			user.setIsLook(user.getIsLook() + 1);
			user.setLatestMsg(Message.CARD_TYPE);
			userService.update(user);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("send message error ");
		}

	}


	//设置卡券类型统计信息
	/**
	 * @param tid 卡券类型id
	 * @param type 卡券类型统计
	 * @throws Exception;
	 * */
	private void setCardTypeStatistics(Long tid, Integer type) throws Exception {
		log.info("setCardTypeStatistics start, tid is " + tid + " , type is " + type );

        try {
            Ctype ctype = ctypeService.getObjectById(tid);
            if (ctype == null) {
                log.info("get ctype error, tid is :" + tid);
                return;
            }else {
                log.error("get ctype error, tid is :" + tid);
            }

            switch (type) {
                //卡券使用 核销中+1 发放未使用-1
                case Card.STATUS_VERIFICATING:
                    ctype.setVerifyingCount(ctype.getVerifyingCount()+1);
                    ctype.setAssignCount(ctype.getAssignCount()-1);
                    log.info("setCardTypeStatistics, ctype id is " + tid + ",card: assign --> verifying");
                    break;
                //卡券转让 转让数+1
                case Card.STATUS_CESSION:
                    ctype.setCessionCount(ctype.getCessionCount()+1);
                    log.info("setCardTypeStatistics, ctype id is " + tid + ",card: Cession");
                    break;
                //卡券过期 发放未使用-1 已过期+1
                case Card.STATUS_EXPIRE:
                    ctype.setAssignCount(ctype.getAssignCount()-1);
                    ctype.setExpiredCount(ctype.getExpiredCount()+1);
                    log.info("setCardTypeStatistics, ctype id is " + tid + ",card: Expired");
                    break;
                default:
                    log.info("setCardTypeStatistics, type error");
                    break;
            }
            ctypeService.update(ctype);
            log.info("update ctype success, id is " + tid);

        }catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update ctype error, tid is :" + tid +" ,please checks data");
        }
	}
	//设置用户卡券统计信息
	/**
	 * @param uid 用户id
	 * @param type 用户卡券统计类型
	 * @throws Exception;
	 * */
	private void setUserStatistics(Long uid, Integer type) throws Exception{
		log.info("setUserStatistics uid is " + uid +" ,type is " + type );


		try	{
            UserStatistics userStatistics = userStatisticsService.getObjectById(uid);

			if (userStatistics == null){
                log.error("get setUserStatistics error, uid is " + uid);
                return;
            }else {
                log.info("get setUserStatistics success, uid is " + uid);
            }

            switch (type){
                //未使用
                case Card.STATUS_ISSUED:
                    userStatistics.setCardUnused(userStatistics.getCardUnused()+1);
                    log.info("update UserStatistics , user id is " + uid + " ,unused card is "+ userStatistics.getCardUnused());
                    break;
                //申请中,未使用-1 核销中+1
                case Card.STATUS_VERIFICATING:
                    userStatistics.setCardVerifying(userStatistics.getCardVerifying()+1);
                    userStatistics.setCardUnused(userStatistics.getCardUnused()-1);
                    log.info("update UserStatistics , user id is " + uid + " ,Verifying card is "+ userStatistics.getCardVerifying() + " ,unused card is "+ userStatistics.getCardUnused());
                    break;
                //已过期，未使用-1 已过期+1
                case Card.STATUS_EXPIRE:
                    userStatistics.setCardExpired(userStatistics.getCardExpired()+1);
                    userStatistics.setCardUnused(userStatistics.getCardUnused()-1);
                    log.info("update UserStatistics , user id is " + uid + " ,Expired card is "+ userStatistics.getCardExpired() + " ,unused card is "+ userStatistics.getCardUnused());
                    break;
                //已转让 未使用-1 已转让+1
                case Card.STATUS_CESSION:
                    userStatistics.setCardCession(userStatistics.getCardCession()+1);
                    userStatistics.setCardUnused(userStatistics.getCardUnused()-1);
                    break;
                default:
                    log.info("setUserStatistics type error, uid is " + uid + " ,type is " + type );
                    break;
            }
            userStatisticsService.update(userStatistics);
            log.info("update UserStatistics success");


        } catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get setUserStatistics error, uid is :" + uid);
		}

	}

	private static String adminSend(String mobile, String content) {


		String param = "{\n" +
				"    \"target_type\" : \"users\", \n" +
				"    \"target\" : [\"" + mobile + "\"],   \n" +
				"                                   \n" +
				"                                   \n" +
				"    \"msg\" : {\n" +
				"        \"type\" : \"txt\",\n" +
				"        \"msg\" : \"" + content + "\" \n" +
				"        },\n" +
				"    \"from\" : \"admin\"\n" +
				"}";
		String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");


		return result;
	}
	
}

