package com.ptteng.common.skill.util;

import com.gemantic.common.util.StringUtil;
import com.gemantic.dal.config.helper.GroupHelper;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.skill.service.model.UserTaskRelation;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

import javax.sql.DataSource;
import java.util.*;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);


    public static Map<String, Object> getMajorByName(String major) {

        Map<String, Object> params = new HashMap<>();

        params.put("@query", "id");
        params.put("@table", "major");

        if (StringUtils.isNotEmpty(major)) {
            params.put("CONCAT(primary_major, secondary_major, major) & like", "'%" + major + "%'");
        }

        return params;
    }


    public static Map<String, Object> getSchoolByName(String school) {

        Map<String, Object> params = new HashMap<>();

        if (StringUtil.isNotEmpty(school)) {
            params.put("@query", "id");
            params.put("@table", "school");
            params.put("@order", "id asc");
            params.put("name & like", "'%" + school + "%'");
            return params;
        }

        return null;
    }


    //查询合作校园
    public static Map<String, Object> getCorporateSchool() {

        Map<String, Object> params = new HashMap<>();
        params.put("is_corporate", 1);
        params.put("@query", "id");
        params.put("@table", "school");
        params.put("@order", "status desc,update_at desc");

        return params;
    }

    //查询校园学员的日报总数
    public static Map<String, Object> getSchoolDailyCount(List<Long> uids) {

        Map<String, Object> params = new HashMap<>();
        params.put("@table", "article a,message m,user u");

        //只筛选学员加入校园之后的日报
        params.put("m.receive_id ", "u.id");
        params.put("m.type ", "'" + Message.JOIN_SCHOOL + "'");
        params.put("a.create_at & >=", "m.create_at");
        params.put("a.uid", "u.id");

        if (CollectionUtils.isNotEmpty(uids)) {
            String str = StringUtils.join(uids.toArray(), ",");
            params.put("u.id & in ", "(" + str + ")");
        }

        params.put("@query", " count(distinct a.id) ");

        return params;
    }


    public static List<Document> getSkillMastLoveDocument(Long[] sids, Integer type) {

        StringBuilder sidStr = new StringBuilder("");
        int i = 0;
        for (Long sid : sids) {
            i += 1;
            if (i == sids.length) {
                sidStr.append(sid);
            } else {
                sidStr.append(sid + ",");
            }

        }


        log.info("Test 111 ");
        List<Document> indentParmList = new ArrayList<Document>();
        log.info("Test 222 ");
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_skill");
            log.info("Test 333 ");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            log.info("Test 44 ");
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT  GROUP_CONCAT(DISTINCT a.sid) sid  ,b.id id, b.love love ,b.document_name document_name ,b.url url from " +
                    "(select   sid,MAX(love) love  from document where sid in(" + sidStr.toString() + ") and type = " + type + " GROUP BY sid) a," +
                    "document b " +
                    "where a.sid = b.sid and b.love = a.love and b.sid in (" + sidStr.toString() + ")  and b.type = " + type + " GROUP BY a.sid");


            log.info("Sql " + sql.toString());
            indentParmList =
                    simpleJdbcTemplate.query(sql.toString(),
                            ParameterizedBeanPropertyRowMapper.newInstance(Document.class));
        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }

        log.info("  size  = " + indentParmList.size());
        return indentParmList;
    }

    //获取结业师兄视频列表
    public static List<User> getUserVideo(Integer start, Integer limit, Long bid) {

        List<User> indentParmList = new ArrayList<User>();
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_skill");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
            StringBuilder sql = new StringBuilder();
            sql.append("select id from user where  graduated_video is not null and graduated_video !=''");
            if (DataUtils.isNotNullOrEmpty(bid)){
                sql.append(" and user.branch=").append(bid);
            }
            //结业时间倒排
            sql.append("  order by graduate_at desc ");

            sql.append(" limit  " + start + "," + limit);
            log.info("Sql " + sql.toString());
            indentParmList =
                    simpleJdbcTemplate.query(sql.toString(),
                            ParameterizedBeanPropertyRowMapper.newInstance(User.class));
        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }

        log.info("  size  = " + indentParmList.size());
        return indentParmList;
    }


    public static Map<String, Object> getUserListByParams(Long oid, Long tid, Integer branch, Integer identity, Integer level,
                                                          Long studyStartAt, Long studyEndAt, Long graduatedStartAt, Long graduatedEndAt,
                                                          String nick, String type, Integer studyNumber, Integer status, Integer age,
                                                          String city, String major, String school, Long schoolId, String classmateType, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user");
        //在学状态的用户应包含请假学员
        if (DataUtils.isNotNullOrEmpty(status)) {
            if (status.equals(User.Status_Student)) {
                params.put("user.status & in ", "(" + status + "," + User.STATUS_5 + ")");
            } else {
                params.put("user.status", status);
            }

        }
        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("user.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(branch)) {
            params.put("user.branch", branch);
        }
        if (DataUtils.isNotNullOrEmpty(identity)) {
            params.put("user.identity", identity);
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("user.level", level);
        }
        if (DataUtils.isNotNullOrEmpty(studyStartAt)) {
            params.put("user.start_at & >= ", studyStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(studyEndAt)) {
            params.put("user.start_at & <= ", studyEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(graduatedStartAt)) {
            params.put("user.graduate_at & >= ", graduatedStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(graduatedEndAt)) {
            params.put("user.graduate_at & <= ", graduatedEndAt);

        }
        if (StringUtil.isNotEmpty(nick)) {
            params.put("user.nick & like ", "'%" + nick + "%'");
        }
        if (StringUtil.isNotEmpty(type)) {
            params.put("user.type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(studyNumber)) {
            params.put("user.study_number", studyNumber);
        }

        if (DataUtils.isNotNullOrEmpty(tid)) {
            tables.add("user_task_relation");
            params.put("user.id", "user_task_relation.uid");
            params.put("user_task_relation.tid & <= ", tid);
        }

        if (DataUtils.isNotNullOrEmpty(age) || DataUtils.isNotNullOrEmpty(city) || DataUtils.isNotNullOrEmpty(school)
                || DataUtils.isNotNullOrEmpty(major)) {
            tables.add("record");
            params.put("user.id", " record.uid");
            params.put("record.status", Record.STATUS_SAVE);
            if (ObjectUtils.equals(1, age)) { //年龄小于18岁
                params.put("TIMESTAMPDIFF(YEAR, FROM_UNIXTIME(record.born_at/1000), CURRENT_TIMESTAMP()) & <", 18);
            }
            if (ObjectUtils.equals(2, age)) { //年龄大于等于18岁，小于24岁
                params.put("TIMESTAMPDIFF(YEAR, FROM_UNIXTIME(record.born_at/1000), CURRENT_TIMESTAMP()) & >=", 18);
                params.put("TIMESTAMPDIFF(YEAR, FROM_UNIXTIME(record.born_at/1000), CURRENT_TIMESTAMP()) & <", 24);
            }
            if (ObjectUtils.equals(3, age)) { //年龄大于等于24岁，小于30岁
                params.put("TIMESTAMPDIFF(YEAR, FROM_UNIXTIME(record.born_at/1000), CURRENT_TIMESTAMP()) & >=", 24);
                params.put("TIMESTAMPDIFF(YEAR, FROM_UNIXTIME(record.born_at/1000), CURRENT_TIMESTAMP()) & <", 30);
            }
            if (ObjectUtils.equals(4, age)) { //年龄大于30岁
                params.put("TIMESTAMPDIFF(YEAR, FROM_UNIXTIME(record.born_at/1000), CURRENT_TIMESTAMP()) & >=", 30);
            }
            if (DataUtils.isNotNullOrEmpty(city)) {
                params.put("CONCAT(record.province, record.city) & like", "'%" + city + "%'");
            }
            if (DataUtils.isNotNullOrEmpty(school)) {
                params.put("record.school & like", "'%" + school + "%'");
            }
            if (DataUtils.isNotNullOrEmpty(major)) {
                params.put("record.major & like", "'%" + major + "%'");
            }
        }

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("user.school_id", schoolId);
        }

        if (DataUtils.isNotNullOrEmpty(classmateType)) {
            if (classmateType.equals("normal")) {

            } else if (classmateType.equals("excelent")) {
                params.put("user.identity", "55"); //约定55为荣耀师兄
            }
        }

        if (count) {
            params.put("@query", " count(distinct user.id) ");
        } else {
            params.put("@query", " user.id ");
            params.put("@order", "user.start_at desc");

        }


        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        /*打印sql语句
        String convert2Sql = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);
        System.out.println("语句："+convert2Sql);
        */
        return params;
    }


    public static void checkUserGraduateStatus(List<User> users) {
        Long now = System.currentTimeMillis();
        for (User user : users) {
            Long graduateAt = user.getGraduateAt();
            if (DataUtils.isNullOrEmpty(graduateAt)) {
                log.info(" user graduateAt is null ,so he dosen't graduate ");
                user.setGraduated(false);
            } else {
                if (graduateAt <= now) {
                    log.info(" user graduateAt<=now ,so he has graduated ");
                    user.setGraduated(true);
                } else {
                    log.info(" user graduateAt>now , so he dosen't graduate ");
                    user.setGraduated(false);
                }
            }

        }
    }


    public static void checkUserGraduateStatus(User user) {
        Long now = System.currentTimeMillis();
        Long graduateAt = user.getGraduateAt();
        if (DataUtils.isNullOrEmpty(graduateAt)) {
            log.info(" user graduateAt is null ,so he dosen't graduate ");
            user.setGraduated(false);
        } else {
            if (graduateAt <= now) {
                log.info(" user graduateAt<=now ,so he has graduated ");
                user.setGraduated(true);
            } else {
                log.info(" user graduateAt>now , so he dosen't graduate ");
                user.setGraduated(false);
            }
        }
    }

    public static Map<String, Object> getMessageListParam(Integer status, String type, Long uid, Integer unread,
                                                          boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" receive_id ", uid);
        }
        //1-显示正常状态的消息   0-显示删除状态的消息
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        // 0已读，1未读
        if (DataUtils.isNotNullOrEmpty(unread)) {
            params.put(" unread ", unread);
        }
        if (StringUtils.isNotEmpty(type)) {
            //师兄弟关系teacher的消息，目前前台也展示在学院消息classes中
            if (Message.CLASS_TYPE.equals(type)) {
                params.put(" type & in ", "('" + Message.CLASS_TYPE + "','" + Message.TEACHER_TYPE + "')");
            } else {
                params.put(" type ", "'" + type + "'");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {

            params.put("@order", "  create_at desc ");

            params.put("@query", " id ");
        }
        params.put("@table", "message");

        return params;

    }

    public static List<DocumentAndSkill> getDocumentIdByMaxLove(Set<Long> skillIDS) {
        log.info("skillIDS: " + skillIDS);
        List<DocumentAndSkill> documentAndSkills = new ArrayList<>();
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_skill");
            log.info("getBeforeNextArticleId datasource: " + dataSource);

            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);

            StringBuilder sql = new StringBuilder("");
            StringBuffer sbuf = new StringBuffer();
            for (Long skillID : skillIDS) {
                sbuf.append(skillID);
                sbuf.append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
            }


            sql.append("select MAX(love) as love,sid ,id from document where sid in (" + sbuf + ") GROUP BY sid");
            documentAndSkills = simpleJdbcTemplate.query(sql.toString(),
                    ParameterizedBeanPropertyRowMapper.newInstance(DocumentAndSkill.class));
            log.info("ids: " + documentAndSkills.size());
        } catch (Exception e) {
            log.error("getDocumentIdByMaxLove error ", e);
        }
        return documentAndSkills;
    }


    public static Map<String, Object> getUserLoveArticleList(Integer type, Integer orderBy, Integer sort, Long uid,
                                                             boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user_article_relation");
        tables.add("article");
        params.put(" user_article_relation.aid ", " article.id ");
        params.put(" user_article_relation.whether  ", UserArticleRelation.WHETHER_VALID);
        params.put("user_article_relation.uid", uid);
        if (UserArticleRelation.STATUS_LOVE == type) {
            //点赞
            params.put(" user_article_relation.type ", UserArticleRelation.STATUS_LOVE);
        } else if (UserArticleRelation.STATUS_COLLECTION == type) {
            //收藏
            params.put(" user_article_relation.type  ", UserArticleRelation.STATUS_COLLECTION);
        }

        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ").toString();
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ").toString();
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getUserTaskListByTeacherId(Long teacherId,
                                                                 Integer type,
                                                                 boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user_task_relation");
        tables.add("user");
        params.put(" user_task_relation.uid ", " user.id ");
        params.put(" user.teacher_id ", teacherId);

        if (UserTaskRelation.UNJUDGE == type) {
            params.put(" user_task_relation.progress ", UserTaskRelation.PROGRESS_SUBMITED);

        } else if (UserTaskRelation.JUDGE_FAILD == type) {
            params.put(" user_task_relation.progress  ", UserTaskRelation.PROGRESS_FAIL);

        } else if (UserTaskRelation.JUDGE_PASS == type) {
            params.put(" user_task_relation.progress  ", UserTaskRelation.PROGRESS_PASSED);

        }

        if (count) {
            params.put("@query", " count(user_task_relation.id) ");
        } else {
            if (UserTaskRelation.UNJUDGE == type) {
                params.put("@order", "  user_task_relation.submit_at desc ");
            } else {
                params.put("@order", "  user_task_relation.judge_at desc ");

            }

            params.put("@query", " user_task_relation.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getDocumentListParam(Set<Long> skillIDS,
                                                           boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("document");

        if (skillIDS.size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            for (Long skillID : skillIDS) {
                sbuf.append(skillID);
                sbuf.append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("sid & in ", "(" + sbuf + ")");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {

            params.put("@order", "  love desc ");

            params.put("@query", " id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getUserDocumentRelationListParam(Long uid, List<Long> dids,
                                                                       Integer type, Integer status, Integer whether, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user_document_relation");

        if (type != null) {
            params.put("type", type);
        }

        if (status != null) {
            params.put("status", status);
        }

        if (whether != null) {
            params.put("whether", whether);
        }

        if (uid != null) {
            params.put("uid", uid);
        }

        if (dids != null) {
            if (dids.size() > 0) {
                StringBuffer sbuf = new StringBuffer();
                for (Long did : dids) {
                    sbuf.append(did.toString());
                    sbuf.append(",");
                }
                if (sbuf.length() > 0) {
                    sbuf.deleteCharAt(sbuf.length() - 1);
                    params.put("document_id & in ", "(" + sbuf.toString() + ")");
                }
            }
        }

        if (count) {
            params.put("@query", " count(document_id) ");
        } else {
            params.put("@query", " distinct(document_id) ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    public static Map<String, Object> getArticleAuthorListParam(Long uid, Long tid, Long cid, Long oid,
                                                                Long createAt, Long endAt, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & > ", createAt);

        }


        if (endAt != null) {
            params.put("article.create_at & < ", endAt);

        }

        if (count) {
            params.put("@query", " count(article.uid) ");
        } else {

            params.put("@order", "  article.create_at desc ");

            params.put("@query", " distinct(article.uid) ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getStudentsArticleParam(List<Long> uidList, String type, Long oid, Integer orderBy, Integer sort,
                                                              Integer stuEvaluation, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (oid != null) {
            params.put("oid", oid);
        }

        if (DataUtils.isNotNullOrEmpty(stuEvaluation)) {
            if (stuEvaluation == 1) {
                params.put("evaluation & is  null ", "");
            } else if (stuEvaluation == 2) {
                params.put("evaluation & is not null ", "");
            } else {
                params.put("evaluation & is  null ", "");
            }
        }

        if (StringUtils.isNotBlank(type)) {
            params.put("type", "'" + type + "'");
        }


        if (CollectionUtils.isNotEmpty(uidList)) {
            StringBuffer sbuf = new StringBuffer();
            for (Long uid : uidList) {
                if (uid != null) {
                    sbuf.append(uid.toString());
                    sbuf.append(",");
                }
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("uid & in ", "(" + sbuf.toString() + ")");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ").toString();
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ").toString();
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }

            params.put("@order", a.toString());

            params.put("@query", " id ");
        }

        params.put("@table", "article");

        return params;

    }

    public static Map<String, Object> getNearStudentsArticleParam(List<Long> uidList, Long startAt, Long endAt) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CollectionUtils.isNotEmpty(uidList)) {
            StringBuffer sbuf = new StringBuffer();
            for (Long uid : uidList) {
                if (uid != null) {
                    sbuf.append(uid.toString());
                    sbuf.append(",");
                }
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("uid & in ", "(" + sbuf.toString() + ")");
            }
        }

        if (null != startAt) {

            params.put(" create_at & > ", startAt);

            params.put("@order", " create_at ");
        }

        if (null != endAt) {

            params.put(" create_at & < ", endAt);

            params.put("@order", " create_at DESC ");
        }


        params.put("@query", " id ");

        params.put("@table", "article");

        return params;

    }

    public static Map<String, Object> getArticleListByDirectionParam(Long uid, Long tid, Long cid, Long oid,
                                                                     Long createAt, Long endAt, boolean direction, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & > ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & < ", endAt);


        }

        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            params.put("@query", " article.id ");

            if (direction && createAt != null) {
                params.put("@order", "  article.create_at ");
            } else {
                params.put("@order", "  article.create_at desc ");
            }
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getArticleListParam(Long uid, Long tid, Long cid, Long oid,
                                                          Long createAt, Long endAt, boolean direction, Integer orderBy, Integer sort, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & > ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & < ", endAt);


        }

        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ").toString();
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ").toString();
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getArticleListByParam(Long uid, Long tid, Long cid, Long oid,
                                                            Long createAt, Long endAt, boolean direction, Integer orderBy, Integer sort,
                                                            Integer evaluation, String userType, Long userOid, Integer studyNumber,
                                                            String type, List<Long> teamIds, Integer status, Long seniorId, boolean count,
                                                            String content, Long schoolId) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");

        if (type != null) {
            params.put(" article.type ", "'" + type + "'");
        }

        if (content != null) {
//            params.put(" article.content ", "'" + content + "'");
            params.put("article.content & like ", "'%" + content + "%'");
        }

        if (uid != null) {

            params.put("article.uid", uid);

        }

        if (seniorId != null) {

            params.put("article.senior_id", seniorId);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (status != null) {

            params.put("article.status", status);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }

        StringBuffer tids = new StringBuffer();

        if (CollectionUtils.isNotEmpty(teamIds)) {
            for (Long teamId : teamIds) {
                if (null != teamId) {
                    tids.append(teamId.toString());
                    tids.append(",");
                }
            }
            if (tids.length() > 0) {
                tids.deleteCharAt(tids.length() - 1);
                params.put("team_id & in ", "(" + tids.toString() + ")");
            }
        }


        if (createAt != null) {
            params.put("article.create_at & >= ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & <= ", endAt);


        }

        if (DataUtils.isNotNullOrEmpty(evaluation)) {
            params.put(" article.evaluation", "'" + evaluation + "'");
        }
        if (DataUtils.isNotNullOrEmpty(userType) || DataUtils.isNotNullOrEmpty(userOid) || DataUtils.isNotNullOrEmpty(studyNumber) || DataUtils.isNotNullOrEmpty(schoolId)) {
            tables.add("user");
            params.put("article.uid ", "user.id");
            if (DataUtils.isNotNullOrEmpty(userType)) {
                params.put("user.type ", "'" + userType + "'");
            }
            if (DataUtils.isNotNullOrEmpty(userOid)) {
                params.put(" user.oid ", userOid);
            }
            if (DataUtils.isNotNullOrEmpty(studyNumber)) {
                params.put("user.study_number ", studyNumber);
            }
            if (DataUtils.isNotNullOrEmpty(schoolId)) {
                params.put("user.school_id", schoolId);

                //校园日报，要过滤掉学员加入校园之前的日报
                tables.add("message");
                params.put("message.type ", "'" + Message.JOIN_SCHOOL + "'");
                params.put("message.receive_id ", "user.id");
                params.put("article.create_at  & >= ", "message.create_at");
            }
        }


        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ");
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ");
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ");
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ");
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ");
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    //晨报搜索不带uid
    public static Map<String, Object> getArticleListPaper(Long tid, Long cid, Long oid,
                                                          Long createAt, Long endAt, boolean direction, Integer orderBy, Integer sort,
                                                          Integer evaluation, String userType, Long userOid, Integer studyNumber,
                                                          String type, List<Long> teamIds, Integer status, Long seniorId, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");

        if (type != null) {
            params.put(" type ", "'" + type + "'");
        }

//        if (uid != null) {
//
//            params.put("article.uid", uid);
//
//        }

        if (seniorId != null) {

            params.put("article.senior_id", seniorId);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (status != null) {

            params.put("article.status", status);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }

        StringBuffer tids = new StringBuffer();

        if (CollectionUtils.isNotEmpty(teamIds)) {
            for (Long teamId : teamIds) {
                if (null != teamId) {
                    tids.append(teamId.toString());
                    tids.append(",");
                }
            }
            if (tids.length() > 0) {
                tids.deleteCharAt(tids.length() - 1);
                params.put("team_id & in ", "(" + tids.toString() + ")");
            }
        }


        if (createAt != null) {
            params.put("article.create_at & >= ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & <= ", endAt);


        }

        if (DataUtils.isNotNullOrEmpty(evaluation)) {
            params.put(" article.evaluation", "'" + evaluation + "'");
        }
        if (DataUtils.isNotNullOrEmpty(userType)
                || DataUtils.isNotNullOrEmpty(userOid)
                || DataUtils.isNotNullOrEmpty(studyNumber)) {
            tables.add("user");
            params.put("article.uid ", "user.id");
            if (DataUtils.isNotNullOrEmpty(userType)) {
                params.put("user.type ", "'" + userType + "'");
            }
            if (DataUtils.isNotNullOrEmpty(userOid)) {
                params.put(" user.oid ", userOid);
            }
            if (DataUtils.isNotNullOrEmpty(studyNumber)) {
                params.put("user.study_number ", studyNumber);
            }
        }


        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ");
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ");
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ");
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ");
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ");
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getTaskListParam(Long id, Long oid, Long sid,
                                                       boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("task");

        if (id != null) {

            params.put("task.id", id);

        }
        if (id != oid) {

            params.put("task.oid", oid);

        }
        if (null != sid) {

            params.put("task.sid", sid);

        }


        if (count) {
            params.put("@query", " count(task.id) ");
        } else {

            params.put("@order", "  task.num ");

        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    public static Map<String, Object> getCommentListParam(Long did,
                                                          Long startAt, Long endAt, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("comment");

        if (did != null) {

            params.put("comment.did", did);

        }


        if (count) {
            params.put("@query", " count(comment.id) ");
        } else {

            params.put("@order", "  comment.create_at ");

        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    //有uid则依据uid、oid、status查询，否则依据oid、type、status查询
    public static Map<String, Object> getClassesListParam(Long oid, Long uid,
                                                          String type, Long status, Integer branch, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();


        if (uid != null) {
            if (oid != null) {
                params.put("oid", oid);
            }

            if (status != null) {
                params.put("user_class_relation.status", status);
            }
            //个人班级只传uid，按照更新时间排序
            params.put("user_class_relation.uid", uid);

            if (count) {
                params.put("@query", " count(user_class_relation.cid) ");
            } else {
                params.put("user_class_relation.cid", "classes.id");
                params.put("@query", " distinct(user_class_relation.cid) ");
                params.put("@order", "  user_class_relation.update_at desc ");
            }

            tables.add("user_class_relation");
            tables.add("classes");
        } else {
            if (oid != null) {
                params.put("oid", oid);
            }

            if (status != null) {
                params.put("status", status);
            }
            if (StringUtils.isNotBlank(type)) {
                params.put("type", "'" + type + "'");
            }
            if (DataUtils.isNotNullOrEmpty(branch)) {
                params.put("branch", branch);
            }

            if (count) {
                params.put("@query", " count(id) ");
            } else {
                params.put("@query", " id ");
                params.put("@order", "  name+0 desc ");
            }

            tables.add("classes");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getHisStudentRelationListParam(Long teacherId, String type, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (StringUtils.isNotBlank(type)) {
            params.put("type", "'" + type + "'");
        }

        if (CheckDataUtil.isNotNull(teacherId)) {
            params.put("teacher_id", teacherId);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", "  id ");
        }

        params.put("@table", "user");

        return params;
    }


    public static Map<String, Object> getAllUserClassRelationIdsByUids(List<Long> uids, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CollectionUtils.isNotEmpty(uids)) {
            StringBuffer sbuf = new StringBuffer();
            for (Long uid : uids) {
                sbuf.append(uid.toString());
                sbuf.append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put(" uid & in ", "(" + sbuf.toString() + ")");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {

            params.put("@query", " id ");

        }

        params.put("@table", " user_class_relation ");

        return params;
    }


    /**
     * 查找师兄，用来分配给师弟师兄
     *
     * @param oid
     * @param identify
     * @param orderBy
     * @param count
     * @return
     */
    public static Map<String, Object> getTeacherInfoListParam(Long oid, Integer identify, String orderBy, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("user");
        tables.add("teacher");
        tables.add("branch_institute");

        if (CheckDataUtil.isNotNull(oid)) {
            if (Occupation.CSS_ID.equals(oid)) {
                params.put("user.oid & in ", "(" + Occupation.CSS_ID + "," + Occupation.JS_ID + ")");

            } else {
                params.put("user.oid", oid);
            }
        }
        //只有为结业的可作为师兄，已结业不可
        params.put("(user.graduate_at & > ", System.currentTimeMillis() + " or user.graduate_at is null )");
        //只有正常状态的用户可以作为师兄，退学用户不可
        params.put("user.status", User.Status_Student);
        if (count) {
            params.put("@query", " count(user.id) ");

        } else {
            params.put("@query", " user.id ");
        }


        params.put("user.id", "teacher.id");
        params.put("user.identity", identify);
        params.put("@order", " teacher." + orderBy);

        //只有所在分院设置为可分配师弟的学员，才可以作为师兄
        params.put("user.branch", "branch_institute.id");
        params.put("branch_institute.teacher", BranchInstitute.Is_teacher);

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;


    }

    public static Map<String, Object> getMyCreateDocumentList(Integer type, Long uid,
                                                              Integer orderBy, Integer sort,
                                                              boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("document.author ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" document.type", type);
        }


        if (count) {
            params.put("@query", " count(document.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  document.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  document.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  document.create_at ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " document.id ");
        }

        params.put("@table", "document");

        return params;
    }

    public static Map<String, Object> getMyCollectionDocumentList(Integer type, Long uid, Integer status, Integer weather,
                                                                  Integer orderBy, Integer sort,
                                                                  boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("document");
        tables.add("user_document_relation");
        params.put("document.id", " user_document_relation.document_id");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("user_document_relation.uid ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" document.type", type);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("user_document_relation.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(weather)) {
            params.put(" user_document_relation.whether", weather);
        }

        if (count) {
            params.put("@query", " count(user_document_relation.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  document.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  document.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  document.create_at ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " user_document_relation.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static Map<String, Object> getDocumentQueryListParam(Integer type, Integer rating, Long oid, Long[] sids,
                                                                String name, Integer orderBy, Integer sort,
                                                                String userType, Integer studyNumber,
                                                                boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("document");
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("document.type", type);
        }

        StringBuffer sbuf = new StringBuffer();

        if (DataUtils.isNotNullOrEmpty(sids)) {

            if (sids.length > 0) {
                for (Long sid : sids) {
                    if (null != sid) {
                        sbuf.append(sid.toString());
                        sbuf.append(",");
                    }
                }

                if (sbuf.length() > 0) {
                    sbuf.deleteCharAt(sbuf.length() - 1);
                    params.put("document.sid & in ", "(" + sbuf.toString() + ")");
                }

                sbuf.setLength(0);
            }

        } else if (null != oid) {

            params.put("document.oid", oid);

        } else {

        }

        if (StringUtils.isNotBlank(name)) {

            params.put("document.document_name & like ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(userType)
                || DataUtils.isNotNullOrEmpty(studyNumber)) {
            tables.add("user");
            params.put("document.author ", "user.id");
            if (DataUtils.isNotNullOrEmpty(userType)) {
                params.put("user.type ", "'" + userType + "'");
            }
            if (DataUtils.isNotNullOrEmpty(studyNumber)) {
                params.put("user.study_number ", studyNumber);
            }
        }


        if (DataUtils.isNotNullOrEmpty(rating)) {
            switch (rating) {
                case Document.LOW:
                    params.put(" document.love & > ", Document.NORMAL_UP_LIMIT);
                    break;
                case Document.NORMAL:
                    params.put(" document.love & BETWEEN " + Document.NORMAL_DOWN_LIMIT + " AND " + Document.NORMAL_UP_LIMIT + " ", "");
                    break;
                case Document.BEST:
                    params.put(" document.love & < ", Document.NORMAL_DOWN_LIMIT);
                    break;
                default:
                    break;
            }
        }

        /* 正序的情况 */
        if (CheckDataUtil.equal(sort, 1)) {
            switch (orderBy) {
                case 1:
                    params.put("@order", " document.love ");
                    break;
                case 2:
                    params.put("@order", " document.collection ");
                    break;
                default:
                    params.put("@order", " document.create_at ");
                    break;
            }

            /* 逆序的情况 */
        } else {
            switch (orderBy) {
                case 1:
                    params.put("@order", " document.love desc ");
                    break;
                case 2:
                    params.put("@order", " document.collection desc ");
                    break;
                default:
                    params.put("@order", " document.create_at desc ");
                    break;
            }
        }

        if (count) {

            params.put("@query", " count(document.id) ");
        } else {


            params.put("@query", " document.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;

    }

    public static Map<String, Object> getDocumentParamByType(Integer type, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CheckDataUtil.isNotNull(type)) {
            params.put("type", type);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " love desc ");
            params.put("@query", " id ");
        }

        params.put("@table", "document");

        return params;

    }

    public static Map<String, Object> getDocumentRelationListParam(List<Long> dids, Long uid, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        StringBuffer sbuf = new StringBuffer();

        if (CollectionUtils.isNotEmpty(dids)) {

            for (Long did : dids) {
                if (null != did) {
                    sbuf.append(did.toString());
                    sbuf.append(",");
                }
            }

            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("document_id & in ", "(" + sbuf.toString() + ")");
            }

            sbuf.setLength(0);
        }

        if (null != uid) {

            params.put("uid", uid);
        }

        if (count) {

            params.put("@query", " count(id) ");
        } else {

            params.put("@query", " id ");
        }

        /* 只获取有效记录 */
        params.put("whether", UserArticleRelation.WHETHER_VALID);

        params.put("@table", "user_document_relation");

        return params;

    }


    //获取用户文章关系
    public static Map<String, Object> getArticleRelationListParam(List<Long> aIds, Long uid, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        StringBuffer sbuf = new StringBuffer();

        if (CollectionUtils.isNotEmpty(aIds)) {

            for (Long did : aIds) {
                if (null != did) {
                    sbuf.append(did.toString());
                    sbuf.append(",");
                }
            }

            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("aid  & in ", "(" + sbuf.toString() + ")");
            }

            sbuf.setLength(0);
        }

        if (null != uid) {

            params.put("uid", uid);
        }

        if (count) {

            params.put("@query", " count(id) ");
        } else {

            params.put("@query", " id ");
        }


        /* 只获取有效记录 */
        params.put("whether", UserArticleRelation.WHETHER_VALID);

        params.put("@table", "user_article_relation");

        return params;

    }


    /**
     * 第一种方法：根据评级查询该评级下每个任务的日报的id（不使用）
     * 用户任务统计接口调用动态查询
     * 用户每个任务下上、中、下的数量
     */
    public static Map<String, Object> getArticleIdsByUidAndEvaluationAndOid(Long uid, Integer evaluation, Long oid) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CheckDataUtil.isNotNull(uid)) {
            params.put("uid", uid);
        }
        if (CheckDataUtil.isNotNull(evaluation)) {
            params.put("evaluation", evaluation);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid", oid);
        }
        params.put("@query", " id ");

        params.put("@table", "article");

        log.info("getArticleIdsByUidAndEvaluationAndOid sql is " + SQLUtil.convert2Sql(params, 0, 0));

        return params;

    }


    /**
     * 第二种方法：每个任务下日报的id（使用）
     * 用户任务统计接口调用动态查询
     * 用户每个任务下上、中、下的数量
     */
    public static Map<String, Object> getArticleIdsByUidAndTid(Long uid, Long tid) {

        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "article");

        if (CheckDataUtil.isNotNull(uid)) {
            params.put("uid", uid);
        }
        if (CheckDataUtil.isNotNull(tid)) {
            params.put("(tids", "'[" + tid + "]'" + " or " + " tids  like " + "'%," + tid + "]%')");
        }

        log.info("getArticleIdsByUidAndEvaluationAndOid sql is " + SQLUtil.convert2Sql(params, 0, 0));
        return params;

    }

    /**
     * 查询用户已完成的任务id
     *
     * @param uid
     * @param oid
     * @return
     */
    public static Map<String, Object> getUserTaskRelationIdsIdsByUidAndOid(Long uid, Long oid) {

        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "user_task_relation");

        if (CheckDataUtil.isNotNull(uid)) {
            params.put("uid", uid);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid", oid);
        }
        params.put("progress", UserTaskRelation.PROGRESS_PASSED);

        log.info("getArticleIdsByUidAndEvaluationAndOid sql is " + SQLUtil.convert2Sql(params, 0, 0));
        return params;

    }

    //获取日报下篇 id
    public static Map<String, Object> getDownArticleByDidAndOid(Long did, Long oid) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "article");
        if (CheckDataUtil.isNotNull(did)) {
            params.put("id  &<", did);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid", oid);
        }
        params.put("@order", "id desc");
        log.info("sql is ： " + SQLUtil.convert2Sql(params, 0, 1));
        return params;
    }

    //获取日报上篇 id
    public static Map<String, Object> getUpArticleByDidAndOid(Long did, Long oid) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "article");
        if (CheckDataUtil.isNotNull(did)) {
            params.put("id  &>", did);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid", oid);
        }
        log.info("sql is ： " + SQLUtil.convert2Sql(params, 0, 1));
        return params;
    }


    public static Map<String, Object> getContentsQueryListParam(Integer[] type,
                                                                Integer subType,
                                                                Integer status,
                                                                String title,
                                                                String author,
                                                                Long createBy,
                                                                Long createStartAt,
                                                                Long createEndAt,
                                                                Long publishStartAt,
                                                                Long publishEndAt, String url, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(type)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (type != null) {
                for (Integer t : type) {
                    if (t != null) {
                        sb.append(t.toString());
                        sb.append(",");
                        i++;
                    }
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("type & in ", "(" + sb.toString() + ")");
        }
        if (DataUtils.isNotNullOrEmpty(subType)) {
            params.put("sub_type", subType);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title", "'" + title + "'");
        }
        if (DataUtils.isNotNullOrEmpty(author)) {
            params.put("author", "'" + author + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put("create_by", createBy);
        }
        if (DataUtils.isNotNullOrEmpty(url)) {
            params.put("url", "'" + url + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishStartAt)) {
            params.put("publish_at & >=", publishStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishEndAt)) {
            params.put("publish_at & <=", publishEndAt);
        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
//            params.put("@order", "update_at desc ");
            params.put("@order", "is_top desc, status desc, update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "contents ");

        return params;
    }


    public static Map<String, Object> getQueryBranchList(String name, Long uid,
                                                         String qq, Integer period, String phone, String url, String address, Integer status, Long branchId) {


        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@table", "branch_institute");
        params.put("@query", "id");
        params.put("@order", "sort asc");

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", "'%" + name + "%'");
        }
        if (uid != null) {
            params.put("uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty(qq)) {
            params.put("qq", qq);
        }
        if (DataUtils.isNotNullOrEmpty(period)) {
            params.put("period", period);
        }
        if (DataUtils.isNotNullOrEmpty(phone)) {
            params.put("phone", phone);
        }
        if (DataUtils.isNotNullOrEmpty(url)) {
            params.put("url", url);
        }
        if (DataUtils.isNotNullOrEmpty(address)) {
            params.put("address", address);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(branchId)) {
            params.put("id", branchId);
        }

        return params;
    }

    public static Map<String, Object> getUserListParam2(String nick) {
        Map<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like", "'%" + nick + "%'");
        }
        return params;
    }


    /**
     * show
     *
     * @param status   用户状态
     * @param branchId 分院id
     * @param salary   薪资
     * @param employ   就业率
     * @param group    是否分组-true为分组
     * @return java.util.Map<java.lang.String                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               java.lang.Object>
     * @author lishaobo
     * @date 2018/5/8
     */
    public static Map<String, Object> getUserStatisticsByStatusAndBranch(Integer status, Long branchId, boolean salary, boolean employ, boolean group) {

        Map<String, Object> params = new HashMap<String, Object>();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder statusSql = new StringBuilder();
        StringBuilder querySql = new StringBuilder();
        //用户状态统计
        statusSql.append("and u.type='offline'");
        if (DataUtils.isNotNullOrEmpty(status)) {
            if (status.equals(User.Status_Student)) {
                statusSql.append("and u.status in (-1,5)");
            } else {
                statusSql.append("and u.status=");
                statusSql.append(status);
            }

            querySql.append("count(case when 1 ").append(statusSql).append(" then u.id else null end)");
        } else {
            querySql.append("1");
        }
        if (DataUtils.isNotNullOrEmpty(branchId)) {
            stringBuilder.append(" and b.id=").append(branchId);
        }

        params.put("@order", "b.sort asc");
        //结业平均薪资统计
        if (salary) {
            querySql.append(",(sum(case when u.status=3 then u.salary else null end)/count(case when u.status=3 then u.id else null end))");
        }

        //统计就业率 结业/（退学+结业+待业）
        if (employ) {
            querySql.append(",(count(case when u.status=3 then u.id else null end)/count(case when u.status in (1,2,3) then u.id else null end))");
        }
        params.put("b.status", 0);
        params.put("@query", querySql);
        //是否分组统计
        if (group) {
            params.put("@group", " b.id");
            params.put("@table", "user u right join branch_institute b on u.branch=b.id" + stringBuilder);
        } else {
            params.put("u.branch", "b.id" + stringBuilder);

            params.put("@table", "user u,branch_institute b");
        }

        return params;
    }

    /**
     * show 职业统计
     *
     * @param branchId 分院id
     * @param group    是否分组-true为分组
     * @return java.util.Map<java.lang.String                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               java.lang.Object>
     * @author lishaobo
     * @date 2018/5/8
     */
    public static Map<String, Object> getOccupationStatisticsByStatusAndBranch(Long branchId, boolean group) {

        Map<String, Object> params = new HashMap<String, Object>();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder querySql = new StringBuilder();
        //用户状态统计

        querySql.append("count(case when u.status in (-1,5) and s.oid=u.oid and s.branch_id=u.branch then u.id else null end),count(case when u.status=3 and s.oid=u.oid and u.branch=s.branch_id then u.id else null end)");


        if (DataUtils.isNotNullOrEmpty(branchId)) {
            stringBuilder.append(" and s.branch_id=").append(branchId);
        }

        params.put("@order", "s.sort asc");

        params.put("@query", querySql);
        //是否分组统计
        if (group) {
            params.put("@group", " s.oid");
            params.put("@table", "user u inner join successor s on 1 " + stringBuilder);
        } else {
            params.put("u.branch", "s.branch_id" + stringBuilder);
            params.put("@table", "user u,successor s");
        }

        return params;
    }

    /**
     * show 统计职业用户
     *
     * @param schoolId 学校id
     * @param branchId 分院id
     * @return java.util.Map<java.lang.String                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               java.lang.Object>
     * @author lishaobo
     * @date 2018/5/8
     */
    public static Map<String, Object> getUserOccupationStatisticsBySchoolIdAndBranchId(Long schoolId, Long branchId) {

        Map<String, Object> params = new HashMap<String, Object>();
        StringBuilder querySql = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        //用户状态统计
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            sql.append(" and u.school_id=").append(schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(branchId)) {
            sql.append(" and u.branch=").append(branchId);
        }
        querySql.append("o.id,o.name,count(u.id)");
        params.put("@group", "o.id");
        params.put("@order", "o.id");
        params.put("@query", querySql);
        params.put("@table", "user u right join occupation o on u.oid=o.id" + sql);
        return params;
    }

    /**
     * show 统计日报
     *
     * @param schoolId 学校id
     * @param branchId 分院id
     * @return java.util.Map<java.lang.String                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               java.lang.Object>
     * @author lishaobo
     * @date 2018/5/8
     */
    public static Map<String, Object> getArticleStatisticsBySchoolIdAndBranchId(Long schoolId, Long branchId, String type, Long startTime, Long endTime) {

        Map<String, Object> params = new HashMap<String, Object>();
        StringBuilder querySql = new StringBuilder();
        //用户状态统计
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("u.school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("a.type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(branchId)) {
            params.put("u.branch", branchId);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("a.create_at & >= ", startTime);
        }
        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("a.create_at & <=", endTime);
        }
        querySql.append("COUNT(DISTINCT(u.id)),COUNT(a.id)");
        params.put("a.uid", "u.id");
        params.put("@query", querySql);
        params.put("@table", "user u,article a");
        return params;
    }

    /**
     * show 校园统计
     *
     * @param schoolId 学校id
     * @return java.util.Map<java.lang.String                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               java.lang.Object>
     * @author lishaobo
     * @date 2018/5/8
     */
    public static Map<String, Object> getSchoolStatisticsBySchoolId(Long schoolId, Long startTime, Long endTime) {

        Map<String, Object> params = new HashMap<String, Object>();
        StringBuilder querySql = new StringBuilder();
        querySql.append("COUNT(DISTINCT(u.id))").append(",COUNT(CASE WHEN 1 ");
        //用户状态统计
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("u.school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            querySql.append("AND a.create_at>=").append(startTime);
        }
        if (DataUtils.isNotNullOrEmpty(endTime)) {
            querySql.append(" AND a.create_at<=").append(endTime);
        }
        querySql.append(" THEN a.id ELSE NULL END),COUNT(DISTINCT(s.id))");
        params.put("s.is_corporate", "1");
        params.put("s.id", "u.school_id");

        params.put("a.uid", "u.id");
        params.put("@query", querySql);
        params.put("@table", "user u,article a,school s");
        return params;
    }


    /**
     * show 分院信息统计
     *
     * @param branchId 分院id
     * @return java.util.Map<java.lang.String                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               java.lang.Object>
     * @author lishaobo
     * @date 2018/5/8
     */
    public static Map<String, Object> getBranchStatisticsByBranchIdAndType(Long branchId) {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@query", "FROM_UNIXTIME(graduate_at / 1000, '%Y-%m'),SUM(CASE WHEN salary IS NULL THEN 0 ELSE salary END),COUNT(id)");

        params.put("1 & AND ", "TIMESTAMPDIFF(MONTH, FROM_UNIXTIME(user.graduate_at / 1000, '%Y-%m-%h'), DATE_FORMAT(CURRENT_DATE(), '%Y-%m-%h')) BETWEEN 0 AND 11");
        params.put("status", "3");
        params.put("branch", branchId);
        params.put("@order", "graduate_at");
        params.put("@group", "from_unixtime(graduate_at / 1000, '%Y-%m')");

        params.put("@table", "user");

        return params;
    }


    //    @Test
////    public void test(){
////        Map<String,Object> map=getUserStatisticsByStatusAndBranch(-1, null,true,true,true);
////        System.out.print(SQLUtil.convert2Sql(map,0,Integer.MAX_VALUE));
////    }
    //获取请假记录
    public static Map<String, Object> getLeavesListParam(Long uid, String nick, Long oid, Integer identity, String type,
                                                         Long startAt, Long endAt, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("user user");
        tables.add("leaves leaves");
        params.put("leaves.uid", "user.id");

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("user.id", uid);
        }

        if (StringUtils.isNotBlank(nick)) {
            params.put(" user.nick & like ", "'%" + nick + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("user.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(identity)) {
            params.put("user.identity", identity);
        }
        if (StringUtils.isNotBlank(type)) {
            params.put("user.type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("leaves.start_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("leaves.start_at &  <= ", endAt);
        }

        if (count) {
            params.put("@query", " count(leaves.id) ");
        } else {
            params.put("@order", " leaves.start_at desc ");
            params.put("@query", " leaves.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    //查询常量列表
    public static Map<String, Object> getConstantListParam(String type, String name, String value, String comments, Long startAt, Long endAt, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from constant");
        tables.add("constant");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type & like ", "'%" + type + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(value)) {
            params.put(" value & like ", "'%" + value + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(comments)) {
            params.put(" comments & like ", "'%" + comments + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("leaves.create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("leaves.create_at &  <= ", endAt);
        }
        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " create_at desc ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static void main(String[] args) {
        //getArticleIdsByUidAndTid(6030l,5l);
        //getUserTaskRelationIdsIdsByUidAndOid(6030l,5l);
//        getDownArticleByDidAndOid(17259L,5L);
//        getClogsQueryListParam("0217070516000926", null, null, null, null, null,null, false);
    }

    public static Map<String, Object> getScoresListParam(Long uid, Integer scoreType, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        log.info("start select from  user_score ");

        tables.add("user_score scores");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("scores.uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty(scoreType)) {
            params.put("scores.scoreType", scoreType);
        }
        if (count) {
            params.put("@query", " count(scores.id) ");
        } else {
            params.put("@order", " scores.create_at desc ");
            params.put("@query", " scores.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getCardsQueryListParam(String code,
                                                             Long tid,
                                                             Long ownerId,
                                                             Integer status,
                                                             Integer cardValid,
                                                             Integer typeValid,
                                                             Integer sort,
                                                             boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from card");
        tables.add("card");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" code & like ", "'%" + code + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid ", tid);
        }

        if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put(" owner_id ", ownerId);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(cardValid)) {
            params.put(" card_valid ", cardValid);
        }
        if (DataUtils.isNotNullOrEmpty(typeValid)) {
            params.put(" ctype_valid ", typeValid);
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            if (DataUtils.isNotNullOrEmpty(sort)) {
                switch (sort) {
                    case 1:
                        params.put("@order", "expire_at asc");
                        break;
                    case 2:
                        params.put("@order", "expire_at desc ");
                        break;
                    case 3:
                        params.put("@order", "assign_at desc ");
                        break;
                    case 4:
                        params.put("@order", "assign_at asc ");
                        break;
                }
            } else {
                params.put("@order", "update_at desc ");
            }
            params.put("@query", "id ");
        }

        params.put("@table", "card ");

        return params;
    }

    public static Map<String, Object> getCardsQueryListByCardValidAndTypeValidParam(String code,
                                                                                    Long tid,
                                                                                    Long ownerId,
                                                                                    Integer status,
                                                                                    Integer cardValid,
                                                                                    Integer typeValid,
                                                                                    Integer sort,
                                                                                    boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from card");
        tables.add("card");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" code & like ", "'%" + code + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid ", tid);
        }

        if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put(" owner_id ", ownerId);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(cardValid) && DataUtils.isNotNullOrEmpty(typeValid)) {
            params.put("( card_valid & = " + cardValid + " or " + "ctype_valid ", "=" + typeValid + ")");
        }
//        if (DataUtils.isNotNullOrEmpty(typeValid)) {
//            params.put("ctype_valid ", typeValid);
//        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            if (DataUtils.isNotNullOrEmpty(sort)) {
                switch (sort) {
                    case 1:
                        params.put("@order", "expire_at asc");
                        break;
                    case 2:
                        params.put("@order", "expire_at desc ");
                        break;
                    case 3:
                        params.put("@order", "assign_at desc ");
                        break;
                    case 4:
                        params.put("@order", "assign_at asc ");
                        break;
                }
            } else {
                params.put("@order", "update_at desc ");
            }
            params.put("@query", "id ");
        }

        params.put("@table", "card ");

        return params;
    }


    public static Map<String, Object> getClogsQueryListParam(String code, Long tid,
                                                             Long createId, Long issueId, Long ownerId, Long cessionId, Long verificationId,
                                                             Integer[] type,
                                                             Long createStartAt, Long createEndAt,
                                                             Long assignStartAt, Long assignEndAt,
                                                             Long applyStartAt, Long applyEndAt,
                                                             Long cessionStartAt, Long cessionEndAt,
                                                             Long verificationStartAt, Long verificationEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();
        log.info("start select from clog");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" cid & in ", "(select id from card where code like '%" + code + "%')");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid ", tid);
        }
        if (DataUtils.isNotNullOrEmpty(issueId) || DataUtils.isNotNullOrEmpty(verificationId)) {
            params.put(" admin_id & in ", "(" + issueId + "," + verificationId + ")");
            params.put("type & in", "(4,5)");
        }
        if (DataUtils.isNotNullOrEmpty(createId)) {
            params.put(" create_by ", createId);
        }

        if (DataUtils.isNotNullOrEmpty(ownerId) && DataUtils.isNotNullOrEmpty(cessionId)) {

            params.put("( use_id ", ownerId + " or receive_id = " + cessionId + " )");
        } else if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put("use_id ", ownerId);
        }

        if (DataUtils.isNotNullOrEmpty(type)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (type != null) {
                for (Integer t : type) {
                    if (t != null) {
                        sb.append(t.toString());
                        sb.append(",");
                        i++;
                    }
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("type & in ", "(" + sb.toString() + ")");
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }

        if (DataUtils.isNotNullOrEmpty(assignStartAt)) {
            params.put("create_at & >=", assignStartAt);
            params.put("type", 2);
        }
        if (DataUtils.isNotNullOrEmpty(assignEndAt)) {
            params.put("create_at & <=", assignEndAt);
            params.put("type", 2);
        }
        if (DataUtils.isNotNullOrEmpty(applyStartAt)) {
            params.put("create_at & >=", applyStartAt);
            params.put("type", 3);
        }
        if (DataUtils.isNotNullOrEmpty(applyEndAt)) {
            params.put("create_at & <=", applyEndAt);
            params.put("type", 3);
        }
        if (DataUtils.isNotNullOrEmpty(cessionStartAt)) {
            params.put("create_at & >=", cessionStartAt);
            params.put("type", 6);
        }
        if (DataUtils.isNotNullOrEmpty(cessionEndAt)) {
            params.put("create_at & <=", cessionEndAt);
            params.put("type", 6);
        }
        if (DataUtils.isNotNullOrEmpty(verificationStartAt)) {
            params.put("create_at & >=", verificationStartAt);
            params.put("type & in", "(4,5)");
        }
        if (DataUtils.isNotNullOrEmpty(verificationEndAt)) {
            params.put("create_at & <=", verificationEndAt);
            params.put("type & in", "(4,5)");
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "clog");

        return params;
    }

    public static Map<String, Object> getCardsTypeQueryListParam(String title,
                                                                 Long id,
                                                                 Integer status,
                                                                 Long createStarAt,
                                                                 Long createEndAt,
                                                                 String createBy,
                                                                 boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();
        log.info("start select from ctype");
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put(" title & like", "'%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put(" id ", id);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }

        if (DataUtils.isNotNullOrEmpty(createStarAt)) {
            params.put(" create_at & >= ", createStarAt);
        }

        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put(" create_at & <= ", createStarAt);
        }

        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put(" create_by ", createBy);
        }

        if (count) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "ctype");

        return params;
    }


    public static Map<String, Object> getCardsQueryListOrderByParam(Integer sort, String ids) {

        Map<String, Object> params = new HashMap<String, Object>();

//        Set<String> tables = new HashSet();
//        log.info("start select from card");
//        tables.add("card");


        if (DataUtils.isNotNullOrEmpty(ids)) {
            params.put(" id & in ", "(" + ids + ")");
        }


        if (DataUtils.isNotNullOrEmpty(sort)) {
            switch (sort) {
                case 1:
                    params.put("@order", "expire_at asc");
                    break;
                case 2:
                    params.put("@order", "expire_at desc ");
                    break;
                case 3:
                    params.put("@order", "assign_at desc ");
                    break;
                case 4:
                    params.put("@order", "assign_at asc ");
                    break;
            }
        } else {
            params.put("@order", "update_at desc ");
        }
        params.put("@query", "id ");

        params.put("@table", "card ");

        return params;
    }


    public static Map<String, Object> getCardsQueryListInTidByParam(String code, String tid,
                                                                    Long ownerId,
                                                                    Long assignId,
                                                                    Long verificationId,
                                                                    Long createId,
                                                                    Integer status, Integer cardValid,
                                                                    Long assignStartAt, Long assignEndAt,
                                                                    Long applyStartAt, Long applyEndAt,
                                                                    Integer sort,
                                                                    Long verificationStartAt, Long verificationEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from card");
        tables.add("card");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" code & like ", "'%" + code + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid & in ", "(" + tid + ")");
        }
        if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put(" owner_id ", ownerId);
        }
        if (DataUtils.isNotNullOrEmpty(assignId)) {
            params.put(" assign_id ", assignId);
        }
        if (DataUtils.isNotNullOrEmpty(verificationId)) {
            params.put(" verification_id ", verificationId);
        }
        if (DataUtils.isNotNullOrEmpty(createId)) {
            params.put(" create_by ", createId);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(cardValid)) {
            params.put(" card_valid ", cardValid);
        }
        if (DataUtils.isNotNullOrEmpty(assignStartAt)) {
            params.put("assign_at & >=", assignStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(assignEndAt)) {
            params.put("assign_at & <=", assignEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyStartAt)) {
            params.put("apply_at & >=", applyStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyEndAt)) {
            params.put("apply_at & <=", applyEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationStartAt)) {
            params.put("verification_at & >=", verificationStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationEndAt)) {
            params.put("verification_at & <=", verificationEndAt);
        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            if (DataUtils.isNotNullOrEmpty(sort)) {
                switch (sort) {
                    case 1:
                        params.put("@order", "expire_at asc");
                        break;
                    case 2:
                        params.put("@order", "expire_at desc ");
                        break;
                    case 3:
                        params.put("@order", "assign_at desc ");
                        break;
                    case 4:
                        params.put("@order", "assign_at asc ");
                        break;
                }
            } else {
                params.put("@order", "update_at desc ");
            }
            params.put("@query", "id ");
        }

        params.put("@table", "card ");

        return params;
    }

    //获取产品列表
    public static Map<String, Object> getProductListParam(String name, String industry, Integer status, String client,
                                                          boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("product p");


        if (StringUtils.isNotBlank(name)) {
            params.put(" p.name & like ", "'%" + name + "%'");
        }
        if (StringUtils.isNotBlank(industry)) {
            params.put(" p.industry & like ", "'%" + industry + "%'");
        }
        if (null != status) {
            params.put("p.status", status);
        }
        if (StringUtils.isNotBlank(client)) {
            params.put(" p.client & like ", "'%" + client + "%'");
        }

        if (count) {
            params.put("@query", " count(p.id) ");
        } else {
            params.put("@order", "  p.level desc ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    //获取迭代列表
    public static Map<String, Object> getIterationListParam(Long productId, String name, Long period, Integer status,
                                                            boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("iteration i");


        if (StringUtils.isNotBlank(name)) {
            params.put(" i.name & like ", "'%" + name + "%'");
        }

        if (null != status) {
            params.put("i.status", status);
        }
        if (null != productId) {
            params.put("i.product_id", productId);
        }
        if (null != period) {
            params.put("i.period", period);
        }


        if (count) {
            params.put("@query", " count(i.id) ");
        } else {
            params.put("@order", "  i.sort desc ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    //获取项目记录
    public static Map<String, Object> getProjectsListParam(Long tid, String name, Long productId, Long iterationId,
                                                           Long startAt, Long endAt, Long finishStartAt, Long finishEndAt,
                                                           Long createBy, Long sid, Long status, Long createStartAt, Long createEndAt, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("project p");


        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put("p.tid", tid);
        }
        if (StringUtils.isNotBlank(name)) {
            params.put(" p.name & like ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(productId)) {
            params.put("p.product_id", productId);
        }
        if (DataUtils.isNotNullOrEmpty(iterationId)) {
            params.put("p.iteration_id", iterationId);
        }
        if (DataUtils.isNotNullOrEmpty(sid)) {
            params.put("p.sid", sid);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("p.status", status);
        }
        //搜索项目开始时间
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("p.start_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("p.start_at & <= ", endAt);
        }
        //搜索项目结束时间
        if (DataUtils.isNotNullOrEmpty(finishStartAt)) {
            params.put("p.end_at & >= ", finishStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(finishEndAt)) {
            params.put("p.end_at & <= ", finishEndAt);
        }
        //搜索项目创建开始时间
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("p.create_at & >= ", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("p.create_at & <= ", createEndAt);
        }

        if (count) {
            params.put("@query", " count(p.id) ");
        } else {
            params.put("@order", " p.create_at desc ");
            params.put("@query", " p.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    //获取组员记录
    public static Map<String, Object> getMembersListParam(Long uid, String nick, Long oid, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from user and user_team_relation ");
        tables.add("user u");
        tables.add("user_team_relation m");
        params.put("u.id", "m.uid");

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("m.uid", uid);
        }
        if (StringUtils.isNotBlank(nick)) {
            params.put(" u.nick & like ", "'%" + nick + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("u.oid", oid);
        }


        if (count) {
            params.put("@query", " count(m.id) ");
        } else {
            params.put("@order", " m.create_at desc ");
            params.put("@query", " m.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    //查询标签列表
    public static Map<String, Object> getLabelListParam(Long id, Long oid, Long tid, String title, Integer status) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from label ");
        tables.add("label label");

        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put("label.id", id);
        }
        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("label.oid", oid);
        }
        //前台搜索任务标签时，同时返回通用标签
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put("label.tid & in", "(" + tid + "," + Constants.TASK_ID_None + ")");
        }

        if (StringUtils.isNotBlank(title)) {
            params.put(" label.title & like ", "'%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("label.status", status);
        }

        params.put("@order", " label.update_at desc ");
        params.put("@query", " label.id ");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    //查询问题标签关联列表
    public static Map<String, Object> getQuestionLabelRelationListParam(String labelIdS, String questionIdS) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from question_label_relation ");
        tables.add("question_label_relation qlr");

        if (StringUtils.isNotBlank(labelIdS)) {
            params.put(" qlr.label_id & in ", "(" + labelIdS + ")");
        }

        if (StringUtils.isNotBlank(questionIdS)) {
            params.put(" qlr.question_id & in ", "(" + questionIdS + ")");
        }

        params.put("@query", "qlr.id");
        params.put("@group ", "qlr.id ");
        params.put("@order", " qlr.update_at desc ");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    //查询问题列表
    public static Map<String, Object> getQuestionListParam(Long id, Long oid, Long tid, Long uid, Integer type, Integer status, Integer adopt, Long createBy,
                                                           String title, String labelIds, Integer orderBy, Integer sort) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from question & question_label_relation & label ");
        tables.add("question q");


        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put("q.id", id);
        }
        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("q.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put("q.tid", tid);
        }


        //type  1-用户点赞(配合参数uid)	 2-用户创建(配合参数createBy)  默认时间倒序排列 , 其余默认按照踩坑数倒排
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("@order", " q.update_at desc ");
            if (UserArticleRelation.LIST_TYPE_LOVE == type && DataUtils.isNotNullOrEmpty(uid)) {
                tables.add("user_article_relation  uar");
                params.put("uar.target_type", UserArticleRelation.TARGET_QUESTION);
                params.put("uar.type", UserArticleRelation.STATUS_LOVE);
                params.put("uar.uid", uid);
                params.put("uar.whether", UserArticleRelation.WHETHER_VALID);
                params.put("uar.aid", "q.id");
            } else if (UserArticleRelation.LIST_TYPE_CREATE == type && DataUtils.isNotNullOrEmpty(createBy)) {
                params.put("q.create_by", createBy);
            }
        } else {
            params.put("@order", "q.agree_num desc, q.adopt desc");
        }


        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("q.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(adopt)) {
            params.put("q.adopt", adopt);
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put("q.create_by", createBy);
        }

        if (StringUtils.isNotBlank(title)) {
            params.put(" q.title & like ", "'%" + title + "%'");
        }

        if (StringUtils.isNotBlank(labelIds)) {
            tables.add("question_label_relation qlr");
            tables.add("label l");
            params.put("l.id", "qlr.label_id");
            params.put("q.id", "qlr.question_id");
            params.put(" qlr.label_id & in ", "(" + labelIds + ")");
        }

        //默认按照踩坑数倒排
        if (DataUtils.isNotNullOrEmpty(orderBy)) {
            StringBuilder order = new StringBuilder("");
            if (orderBy.equals(Question.ORDER_BY_UPDATE_AT)) {
                order.append("  q.update_at ");
            } else if (orderBy.equals(Question.ORDER_BY_ANSWER_COUNT)) {
                order.append("  q.answer_num ");
            } else if (orderBy.equals(Question.ORDER_BY_CREATE_AT)) {
                order.append("  q.create_at ");
            } else {
                //默认按照踩坑数倒排、若踩坑数相同则优先收录，最后再按时间倒序
                order.append("  q.agree_num desc, q.adopt desc, q.update_at ");
            }

            if (DataUtils.isNotNullOrEmpty(sort) && sort.equals(Constants.SORT_ASE)) {
                order.append("asc");
            } else {
                order.append("desc");
            }
            params.put("@order", order.toString());
        }

        params.put("@query", "q.id");
        params.put("@group ", "q.id ");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    //查询回答列表
    public static Map<String, Object> getAnswerListParam(Long id, Long oid, Long tid, Long uid, Integer type, String questionIds,
                                                         Integer status, Long createBy, String title, String labelIds,
                                                         Integer orderBy, Integer sort) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from answer & question ");
        tables.add("answer a");
        tables.add("question q");
        params.put("q.id", "a.question_id");

        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put("a.id", id);
        }
        if (DataUtils.isNotNullOrEmpty(oid)) {

            params.put("q.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put("q.tid", tid);
        }

        //type  1-用户点赞(配合参数uid)	 2-用户创建(配合参数createBy)  默认时间倒序排列 , 其余默认按照点赞数倒排
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("@order", " a.update_at desc ");
            if (UserArticleRelation.LIST_TYPE_LOVE == type && DataUtils.isNotNullOrEmpty(uid)) {
                tables.add("user_article_relation  uar");
                params.put("uar.target_type", UserArticleRelation.TARGET_ANSWER);
                params.put("uar.type", UserArticleRelation.STATUS_LOVE);
                params.put("uar.uid", uid);
                params.put("uar.whether", UserArticleRelation.WHETHER_VALID);
                params.put("uar.aid", "a.id");
            } else if (UserArticleRelation.LIST_TYPE_CREATE == type && DataUtils.isNotNullOrEmpty(createBy)) {
                params.put("a.create_by", createBy);
            }
        } else {
            params.put("@order", "a.like_num desc ");
        }

        if (StringUtils.isNotBlank(questionIds)) {
            params.put("a.question_id & in ", "(" + questionIds + ")");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("a.status", status);
        }

        if (StringUtils.isNotBlank(title)) {
            params.put(" q.title & like ", "'%" + title + "%'");
        }

        //默认按照点赞数倒排
        if (DataUtils.isNotNullOrEmpty(orderBy)) {
            StringBuilder order = new StringBuilder("");
            if (orderBy.equals(Question.ORDER_BY_UPDATE_AT)) {
                order.append("  a.update_at ");
            } else if (orderBy.equals(Question.ORDER_BY_CREATE_AT)) {
                order.append("  a.create_at ");
            } else {
                order.append("  a.like_num ");
            }

            if (DataUtils.isNotNullOrEmpty(sort) && sort.equals(Constants.SORT_ASE)) {
                order.append("asc");
            } else {
                order.append("desc");
            }
            params.put("@order", order.toString());
        }
        params.put("@order", "a.like_num desc ");
        params.put("@query", "a.id");
        params.put("@group ", "a.id ");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    //从message表计算指定uid的isLook的值
    public static Map<String, Object> countUnreadMessageParam(Long receiveId) {

        Map<String, Object> param = new HashMap<>();

        if (DataUtils.isNullOrEmpty(receiveId)) {
            return null;
        } else {
            param.put("unread", Message.Status_Unread);
            param.put("receive_id", receiveId);
            param.put("type &!=", " 'collection' and type != 'like' and type != 'private'");
            param.put("@query", "count(id)");
            param.put("@table", "message");
            return param;
        }
    }

    //查找指定用户所有content为空字符串的消息ID
    public static Map<String, Object> getEmptyContentMessageListParam(Long receiveId) {

        Map<String, Object> params = new HashMap<>();

        params.put("@table", "message");
        params.put("@query", "id");
        params.put("@order", "create_by desc");
        params.put("type &!=", " 'collection' and type != 'like' and type != 'private'"); //只跟前台展示相关的
        params.put("content", "''"); //消息的content字段为空字符串
        params.put("receive_id", receiveId);

        return params;
    }

    //校正所有未读消息数为负数的情况
    public static Map<String, Object> adjustIsLookParam() {

        Map<String, Object> params = new HashMap<>();

        params.put("@update", "update");
        params.put("@table", "user a");
        params.put("@field", "a.is_look");
        params.put("@value", "(select count(id) from message b where b.receive_id = a.id and b.unread = 1 and b.type!=\"collection\" and b.type!=\"like\" and b.type!=\"private\")");
        params.put("a.isLook & <", 0);

        return params;
    }

    public static Map<String, Object> getSuccessorListByBranchIdAndOidAndUid(Long branchId, Long oid, Long uid, boolean count) {

        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(branchId)) {
            params.put("s.branch_id", branchId);
            params.put("b.id", "s.branch_id");
        }
        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("s.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("s.oid", uid);
        }
        if (count) {
            params.put("@query", "count(DISTINCT(s.uid))");
        } else {
            params.put("@query", "s.id");
        }

        params.put("@order", "b.sort asc");
        params.put("@table", "successor s,branch_institute b");
        return params;
    }


    //在校园人员关系表中，根据校园id，查找对应的记录id集合
    public static Map<String, Object> getIdsBySchoolId(Long schoolId) {
        Map<String, Object> params = new HashMap<>();
        params.put("@query", "id");
        params.put("@table", "school_person_relation");
        params.put("@order", "id asc");
        if (schoolId != null) {
            params.put("school_id", schoolId);
        }

        return params;
    }


    //统计加入校园的学员数量
    public static Map<String, Object> getSchoolStudentIds(List<Long> schoolIds) {
        Map<String, Object> params = new HashMap<>();
        params.put("@table", "user u, school s");

        if (CollectionUtils.isNotEmpty(schoolIds)) {
            String str = StringUtils.join(schoolIds.toArray(), ",");
            params.put("u.school_id & in ", "(" + str + ")");
        } else {
            params.put("u.school_id & is not ", "null");
        }
        params.put("@query", "distinct u.id");

        return params;
    }

}