package com.ptteng.common.skill.controller;


import com.ptteng.common.skill.model.SchoolPersonRelation;
import com.ptteng.common.skill.service.SchoolPersonRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


/**
 * SchoolPersonRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SchoolPersonRelationController {
	private static final Log log = LogFactory.getLog(SchoolPersonRelationController.class);

	@Autowired
	private SchoolPersonRelationService schoolPersonRelationService;



	@RequestMapping(value = "/a/schoolPersonRelation", method = RequestMethod.GET)
	public String getschoolPersonRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		SchoolPersonRelation schoolPersonRelation = new SchoolPersonRelation();
		schoolPersonRelation.setId(2l);
		schoolPersonRelation.setPersonId(1l);
		schoolPersonRelation.setType(1);

		Long id = schoolPersonRelationService.insert(schoolPersonRelation);

		log.info("id===="+id);

		
		log.info("/schoolPersonRelation  to /schoolPersonRelation/view/schoolPersonRelationList");

//		return "/skill-service/schoolPersonRelation/view/schoolPersonRelationList";
		return "/common-skill-service/account/json/accountListJson";
	}
    
    

    

	@RequestMapping(value = "/c/schoolPersonRelation/{id}", method = RequestMethod.GET)
	public String getSchoolPersonRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/schoolPersonRelation/" + id + "  to /schoolPersonRelation/view/schoolPersonRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-skill-service/schoolPersonRelation/view/schoolPersonRelationDetail";
	}






	@RequestMapping(value = "/a/schoolPersonRelation/{id}", method = RequestMethod.GET)
	public String getSchoolPersonRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			SchoolPersonRelation schoolPersonRelation = schoolPersonRelationService.getObjectById(id);
			log.info("get schoolPersonRelation data is " + schoolPersonRelation);

			model.addAttribute("code", 0);

			model.addAttribute("schoolPersonRelation", schoolPersonRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get schoolPersonRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/schoolPersonRelation/json/schoolPersonRelationDetailJson";
	}

	@RequestMapping(value = "/a/schoolPersonRelation/{id}", method = RequestMethod.PUT)
	public String updateSchoolPersonRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, SchoolPersonRelation schoolPersonRelation) throws Exception {

		log.info("update schoolPersonRelation : schoolPersonRelation= " + schoolPersonRelation);

		try {

			schoolPersonRelationService.update(schoolPersonRelation);

			model.addAttribute("code", 0);

			model.addAttribute("schoolPersonRelation", schoolPersonRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update schoolPersonRelation error,id is  " + schoolPersonRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/schoolPersonRelation", method = RequestMethod.POST)
	public String addSchoolPersonRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, SchoolPersonRelation schoolPersonRelation) throws Exception {

		log.info("update schoolPersonRelation : schoolPersonRelation= " + schoolPersonRelation);

		try {
			schoolPersonRelation.setId(null);

			schoolPersonRelationService.insert(schoolPersonRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add schoolPersonRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/schoolPersonRelation/{id}", method = RequestMethod.DELETE)
	public String deleteSchoolPersonRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete schoolPersonRelation : id= " + id);
		try {
			schoolPersonRelationService.delete(id);

			log.info("add schoolPersonRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete schoolPersonRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}


	@RequestMapping(value = "/a/multi/schoolPersonRelation", method = RequestMethod.GET)
	public String getMultiSchoolPersonRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		List<Long> idList = new ArrayList();
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {



			List<SchoolPersonRelation> schoolPersonRelationList = schoolPersonRelationService.getObjectsByIds(idList);
			log.info("get  schoolPersonRelation data is " + schoolPersonRelationList);

			model.addAttribute("code", 0);
			model.addAttribute("total",schoolPersonRelationList.size());

			model.addAttribute("schoolPersonRelationList", schoolPersonRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get schoolPersonRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/skill-service/schoolPersonRelation/json/schoolPersonRelationListJson";
	}
	
	
	
	
	
}

