package com.ptteng.common.skill.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.AccountService;
import com.ptteng.common.skill.service.GoodsService;
import com.ptteng.common.skill.service.OrderService;
import com.ptteng.common.skill.util.OrderIdUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


/**
 * Order  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class OrderController {
	private static final Log log = LogFactory.getLog(OrderController.class);

	@Autowired
	private OrderService orderService;



	@Autowired
	private CookieUtil cookieUtil;


	@Autowired
	private GoodsService goodsService;


	@Autowired
	private AccountService accountService;


    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/u/order", method = RequestMethod.GET)
	public String getOrderIdsByBuyerJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {


			User user = (User) request.getAttribute("user");
			Long uid = user.getId();

			List<Long> ids= orderService.getOrderIdsByBuyer(uid, start, size);
		    log.info("get countOrderIdsByBuyer size is " + ids.size());

			List<Order> orderList = orderService.getObjectsByIds(ids);
			log.info("get order data is " + orderList.size());

			Integer total = orderService. countOrderIdsByBuyer(uid);
			log.info("get order count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("orderList", orderList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get order list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}
		return "/common-skill-service/order/json/orderListJson";
	}


    // 获取订单详情
	@RequestMapping(value = "/a/u/order/{orderId}", method = RequestMethod.GET)
	public String getOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable String orderId)
			throws Exception {

		log.info("get data : id= " + orderId);
		try {

//			Order order = orderService.getObjectById(id);
			Order order = orderService.getObjectByOrderId(orderId);
			log.info("get order data is " + order);

			model.addAttribute("code", 0);

			model.addAttribute("order", order);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get order error,id is  " + orderId);
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/order/json/orderDetailJson";
	}

	// 确认收货
	@RequestMapping(value = "/a/u/order/confirm/{id}", method = RequestMethod.PUT)
	public String updateOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Order order,@PathVariable String id) throws Exception {


		log.info("update order : order= " + order);

		try {
			User user = (User) request.getAttribute("user");
			Long uid = user.getId();
			if (id == null){

				model.addAttribute("code",-8001);
			}


			Order order1 = orderService.getObjectByOrderId(id);

			if(null != order1){

				order1.setStatus(3);
				order1.setConfirmAt(System.currentTimeMillis());

				boolean update = orderService.update(order1);
				log.info("the order status is"+update);

			}else {
				model.addAttribute("code",-8002);
			}

			model.addAttribute("code", 0);
			model.addAttribute("order", order);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update order error,id is  " + order.getId());
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}

	// 2.生成新的订单(分为两种情况,一是由购物车的商品直接生成订单,二是先生成商品信息,然后再由商品信息生成订单)
	@RequestMapping(value = "/a/u/order", method = RequestMethod.POST,consumes = "application/json")
	public String addOrderJson(@RequestBody OrderEntity orderEntity, HttpServletRequest request,
			HttpServletResponse response, ModelMap model ) throws Exception {

		log.info("update order : order= " + orderEntity);
		log.info("update list"+ orderEntity.getGoodsList());

		try {

			User user = (User) request.getAttribute("user");
			Long uid = user.getId();
			log.info(" user "+uid+" want to buy a account ");
			Order order = orderEntity.getOrder();
			if(DataUtils.isNullOrEmpty(order)){
				log.info(" order is null ");
				model.addAttribute("code",-1000);
				return "/data/json";
			}else {
				if(Order.BUY.equals(order.getType())){
					log.info(" user buy a new account ");
					order.setMobile(user.getMobile());
				}else if(Order.RENEW.equals(order.getType())){
					log.info(" user "+uid+"rebuy account id "+order.getAccountId());
					order.setMobile("renew");
				}else {
					log.info(" order is null ");
					model.addAttribute("code",-1003);
					return "/data/json";
				}

			}


			log.info(" order = "+order);
			List<Goods> goodses = orderEntity.getGoodsList();

			if(CollectionUtils.isEmpty(goodses)){
				log.info(" godds is null ");
				model.addAttribute("code",-19000);
				return "/data/json";
			}else {
				for(Goods goods : goodses){
					if(DataUtils.isNullOrEmpty(goods.getCount())){
						model.addAttribute("code",-19001);
						return "/data/json";
					}
					if(DataUtils.isNullOrEmpty(goods.getGoodCount())){
						model.addAttribute("code",-19002);
						return "/data/json";
					}
					if(DataUtils.isNullOrEmpty(goods.getTotalPrice())){
						model.addAttribute("code",-19004);
						return "/data/json";
					}
				}
			}

			order.setId(null);

			if (order != null){
                // 计算订单价格
				Goods goods1 = goodses.get(0);
				if (goods1.getId() == null){  //直接支付
					// 设置订单价格
					order.setTotalPrice(goods1.getTotalPrice());
				}else {
					Double totalPrice = 0D;
					// 遍历计算
					for (Goods goods: goodses){
						log.info("====="+ goods);
						// 取出原有的产品
						if (goods != null){
							Double price = Double.parseDouble(goods.getTotalPrice());
							totalPrice += price;
						}
					}

					DecimalFormat df = new DecimalFormat("#.00");
                    String totalP = df.format(totalPrice);
					order.setTotalPrice(totalP);
				}


				order.setCreateBy(uid);
                order.setUpdateBy(uid);
				order.setSubmitAt(System.currentTimeMillis());
				// 生成订单号 ,暂定01开头为服务器账号商品
				order.setOrderId(OrderIdUtil.generateOrderId("01"));
				log.info(" order mobile = "+order.getMobile());
//				order.setMobile(user.getMobile());
                Long id = orderService.insert(order);
				model.addAttribute("order",id);


				// 取出,商品集合里的第一个商品,判断它是要生成订单,还是直接支付
				Goods goods2 = goodses.get(0);
				if (goods2.getId() == null){ // 说明这是直接生成订单的,将商品加入列表就可以了
					log.info("don't into car");

					goods2.setOrderId(order.getOrderId());
                      goods2.setBuyer(uid);
					  goods2.setCreateBy(uid);
					  goods2.setUpdateBy(uid);
					/*续费的时候，goods的name是account的id，续费只会单独服务器续费，所以只有一个goods*/
					if(Order.RENEW.equals(order.getType())){
						goods2.setName(order.getAccountId()+"");
					}
					log.info("1 =   goods2 name =  "+goods2.getName());

					/*提交订单，未购买，不配置account*/
//					List<Long> acountids = accountService.getAccountByStatus(2, 0, goods2.getGoodCount());
//					log.info("2 =     ");
//
//					List<Account> accountList = accountService.getObjectsByIds(acountids);
//					log.info("3 =    order.getMobile()  "+order.getMobile());
//					if (!"renew".equals(order.getMobile())){
//						if (goods2.getType() == 1){
//							for (Account account :accountList) {
//								account.setStatus(4);
//							}
//							boolean bool = accountService.updateList(accountList);
//							log.info("the update accountList status is" + bool);
//						}
//					}
					log.info("4 =     ");

					goodsService.insert(goods2);

				}else {

					log.info("go to make order");

					// 遍历修改
					for (Goods goods: goodses){
						log.info("====="+ goods);

						// 取出原有的产品
						Goods goods3 = goodsService.getObjectById(goods.getId());

						if (goods3 != null){

							goods.setCreateBy(goods3.getCreateBy());
							goods.setCreateAt(goods3.getCreateAt());
							goods.setUpdateBy(uid);
							goods.setOrderId(order.getOrderId());
                            goods.setBuyer(uid);
							goodsService.update(goods);

						}else {
							model.addAttribute("code","8000");
							return "/data/json";
						}
					}
				}
				log.info("insert order success"+order);

				log.info("the orderid id " +id);

				model.addAttribute("orderId",order.getOrderId());

				model.addAttribute("code", 0);
			}else {
				log.info("order is null" + order);
			}

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add order error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}


	@RequestMapping(value = "/a/u/order/{oid}", method = RequestMethod.DELETE)
	public String deleteOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable String oid)
			throws Exception {

		log.info("delete order : id= " + oid);
		try {

			User user = (User) request.getAttribute("user");
			Long uid = user.getId();

			// 删除订单对应的商品信息
			List ids = goodsService.getGoodsByBuyerAndOrderid(uid, oid, 0, Integer.MAX_VALUE);

			List<Goods> goodsList = goodsService.getObjectsByIds(ids);
			// 遍历商品,恢复账号库存
			for (Goods goods: goodsList){
				List<Long> acountids = accountService.getAccountByStatus(4, 0, goods.getGoodCount());
				List<Account> accountList = accountService.getObjectsByIds(acountids);

				for (Account account :accountList) {

					account.setStatus(2);
				}
				boolean bool = accountService.updateList(accountList);
				log.info("the update accountList status is" + bool);
			}

			goodsService.deleteList(Goods.class, ids);
			Order order = orderService.getObjectByOrderId(oid);
			if (order != null){

				orderService.delete(order.getId());

			}

			log.info("delete order success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete order error,id is  " + oid);
			model.addAttribute("code", -1);

		}
		return "/data/json";
	}
}