package com.ptteng.common.skill.controller;

import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.CommonUtil;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.GetUserFromCookieUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * OccupationTypeRelation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class MessageController {
    private static final Log log = LogFactory.getLog(MessageController.class);

    @Autowired
    private MessageService messageService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private UserService userService;

    @Autowired
    private ConstantService constantService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private BranchInstituteService branchInstituteService;

    @Autowired
    private GetUserFromCookieUtil getUserFromCookieUtil;

    @Resource
    private QuestionService questionService;

    @Resource
    private CommonUtil commonUtil;

    @Resource
    private TemplateTestService templateTestService;

    /**
     * 校正指定uid的未读消息数
     * @param uid 目标用户ID
     *
     */
    @RequestMapping(value = "/a/u/message/unread/adjust", method = RequestMethod.PUT)
    public String adjustIsLook(Long uid, ModelMap model) {

        log.info("PUT /a/u/message/unread/adjust: adjust isLook number whose uid = " + uid);

        /* 动态查询未读消息数，传入一个uid，统计message表下该uid所有unread=1的消息数
         * 更新用户的isLook字段
         */
        try {
            User user = userService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(user)) { //判断用户是否存在
                log.info("the user is not exist, uid = " + uid);
                model.addAttribute("code", -2000);
                return "/common/failure";
            }

            Map<String, Object> param = DynamicUtil.countUnreadMessageParam(uid);
            log.info("count user's isLook field from table message by dynamic param: " + param);

            List<Long> isLookNumList = messageService.getIdsByDynamicCondition(Message.class, param, 0, Integer.MAX_VALUE);
            log.info("user's isLook = " + isLookNumList.get(0));
            if (CollectionUtils.isEmpty(isLookNumList)) {
                log.info("count user's isLook number error, isLookNumList's size = " + isLookNumList.size());
                model.addAttribute("code", -7006);
                return "/common/failure";
            }

            Integer isLook = isLookNumList.get(0).intValue();
            user.setIsLook(isLook);
            log.info("now user's isLook = " + isLook);
            userService.update(user);

            model.addAttribute("code", 0);
            model.addAttribute("isLookPrevious", user.getIsLook());//这里错了，value应该是isLookNumList.get(0)；但不想重新打tag，下次再改
            model.addAttribute("isLookAfter", isLook);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info(" server error, adjust user's isLook number failure");
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/message/json/isLookJson";
    }

    /*
    * 计算指定uid的未读消息数
    * @param uid 目标用户ID
    *
    */
    @RequestMapping(value = "/a/u/message/unread/count", method = RequestMethod.GET)
    public String countUsersIsLook(Long uid, ModelMap model) {

        log.info("GET /a/u/message/unread/count: count user's isLook number whose uid = " + uid);

        try {
            User user = userService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(user)) {
                log.info("the user is not exist, uid = " + uid);
                model.addAttribute("code", -2000);
                return "/common/failure";
            }

            Map<String, Object> param = DynamicUtil.countUnreadMessageParam(uid);
            log.info("count user's isLook field from table message by dynamic param: " + param);

            List<Long> isLookNumList = messageService.getIdsByDynamicCondition(Message.class, param, 0, Integer.MAX_VALUE);
            log.info("user's isLook number = " + isLookNumList.get(0));
            if (CollectionUtils.isEmpty(isLookNumList)) {
                log.info("count user's isLook number error, isLookNumList's size = " + isLookNumList.size());
                model.addAttribute("code", -7006);
                return "/common/failure";
            }

            Integer isLook = isLookNumList.get(0).intValue();
            log.info("isLook = " + isLook);

            model.addAttribute("code", 0);
            model.addAttribute("isLookPrevious", isLook);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info(" server error, adjust user's isLook number failure");
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/message/json/isLookJson";
    }

    /*
    * 查看指定uid所有content为空的消息
    * @param uid 目标用户ID
    *
    */
    @RequestMapping(value = "/a/u/message/content/empty", method = RequestMethod.GET)
    public String getEmptyContentMessageList(ModelMap model, Long uid) {

        log.info("GET /a/u/message/content/empty: get empty content messageList by receiveId = " + uid);

        try {
            User user = userService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(user)) {
                log.info("the user is not exist, uid = " + uid);
                model.addAttribute("code", -2000);
                return "/common/failure";
            }

            Map<String, Object> params = DynamicUtil.getEmptyContentMessageListParam(uid);
            log.info("get empty content messageList by params: " + params);

            List<Long> messageIds = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            log.info("get empty content messageIds size: " + messageIds.size());
            if (CollectionUtils.isEmpty(messageIds)) {
                log.info("there are no empty content message by receiveId: " + uid);
                model.addAttribute("code", -7008);
                return "/common-skill-service/message/json/emptyContentMessageListJson";
            }

            List<Message> messageList = messageService.getObjectsByIds(messageIds);
            log.info("get empty content messageList size: " + messageList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", messageList.size());
            model.addAttribute("messageList", messageList);

        }catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info(" server error, get user's empty content messageList  failure");
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/message/json/emptyContentMessageListJson";
    }

    /*
    * 校正所有消息数为负数的情况
    *
    */
    @RequestMapping(value = "/a/u/message/adjust", method = RequestMethod.PUT)
    public String adjustIsLook(ModelMap model) {

        log.info("PUT /a/u/message/unread/adjust: adjust all user's isLook number whose  isLook < 0");

        templateTestService.updateIsLookNumber();

        model.addAttribute("code", 0);

        return "/common/success";
    }

    /**
     * 1 根据类型获取消息列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status
     * @param type
     * @param pid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/receive/message/{type}/search", method = RequestMethod.GET)
    public String getReceiveMessageByType(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, Integer page,
                                          Integer size, Integer status, @PathVariable String type, Long pid) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        int end = start + size - 1;

        log.info("receive message :  start = " + start + " , size=" + size + " , status = " + status + ", type = " + type);

        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Map<String, Object> params = DynamicUtil.getMessageListParam(status, type, uid, null, false);
            log.info(params + "===================================");
            List<Long> ids = messageService.getIdsByDynamicCondition(Message.class, params, start, size);
            List<Message> messages = new ArrayList<>();
            List<Long> uids = new ArrayList<>();
            List<Long> messageIds = new ArrayList<>();

            if (null == ids) {
                model.addAttribute("code", -7000);
                log.info("the user message is null");
                return "/common/success";
            }
            List<Long> mids = messageService.getMessageIdsByReceiveIdAndUnreadAndStatusAndType(uid, 1, 1, "like", 0, Integer.MAX_VALUE);

            if (!(mids == null)) {
                List<Message> messageLikes = messageService.getObjectsByIds(mids);
                for (Message message : messageLikes) {
                    message.setUnread(0);
                    messageService.update(message);
                }
            }

            if (type.equals(Message.RECEIVE_TYPE)) {
                //谁发送给我。
                List<Long> messageReceiveIdList = messageService.getMessageIdsByReceiveIdAndStatusAndTypePrivate(uid, start, size);
                List<Message> messagesReceiveList = messageService.getObjectsByIds(messageReceiveIdList);
                //增加未读数。
                for (Message item : messagesReceiveList) {
                    //通过sql语句查询几条未读。 unread=1 /未读
                    uids.add(item.getSendId());
                    if (!(item.getSendId().equals(uid))) {
                        log.info(item.getSendId());
                        log.info(item.getReceiveId());
                        Integer unreadCount = messageService.countMessagesBySendIdAndReceiveId(item.getSendId(), item.getReceiveId());

                        item.setunreadCount(unreadCount);
                    }
                }
                messages.addAll(messagesReceiveList);
                //消息个数
                messageIds = messageService.getMessageIdsByReceiveIdAndStatusAndTypePrivate(uid, 0, Integer.MAX_VALUE);
                //uSer信息
                List<User> receiveUserMessages = this.userService.getObjectsByIds(uids);
                model.addAttribute("users", receiveUserMessages);

                log.info("messages is" + messages.size());

            } else if (type.equals(Message.SEND_TYPE)) {
                //我联系的谁
                List<Long> messagesSendIdList = messageService.getMessageIdsBySendIdAndStatusAndType(uid, start, size);
                List<Message> messagesSendList = messageService.getObjectsByIds(messagesSendIdList);
                //增加未读数字
                for (Message item : messagesSendList) {
                    uids.add(item.getReceiveId());
                }
                messages.addAll(messagesSendList);

                //发送人的基本信息
                List<User> sendUserMessages = userService.getObjectsByIds(uids);
                model.addAttribute("users", sendUserMessages);
                //消息个数
                messageIds = messageService.getMessageIdsBySendIdAndStatusAndType(uid, 0, Integer.MAX_VALUE);
                log.info("sendUserMessages is" + sendUserMessages);
            } else if (type.equals(Message.PRIVATE_TYPE) && DataUtils.isNotNullOrEmpty(pid)) {
                //pid有值 那么查找2人的详细记录。
                List<Long> messagesReceiveAndSendIdsList = messageService.getMessageIdsByReceiveIdAndSendId(uid, pid, start, size);
                List<Message> messagesReceiveAndSendList = messageService.getObjectsByIds(messagesReceiveAndSendIdsList);
                uids.add(pid);
                List<User> receiveUserMessages = this.userService.getObjectsByIds(uids);
                log.info("receiveUserMessages is " + receiveUserMessages);
                messages.addAll(messagesReceiveAndSendList);
                model.addAttribute("users", receiveUserMessages);
                log.info("messages" + messages);
                //消息总数
                messageIds = messageService.getMessageIdsByReceiveIdAndSendId(uid, pid, 0, Integer.MAX_VALUE);
            } else if (type.equals(Message.PRIVATE_TYPE) && DataUtils.isNullOrEmpty(pid)) {
                model.addAttribute("code", -1000);
                log.info("the  pid is null");
                return "/common/success";
            } else {
                messages = messageService.getObjectsByIds(ids);
                log.info("messages is " + messages.size());
                messageIds = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            }
            boolean next = false;
            if (messageIds.size() > end + 1) {
                next = true;
            }
            params = DynamicUtil.getMessageListParam(status, Message.DAILY_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int daily = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.CLASS_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int classes = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.TASK_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int task = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.SCORE_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int score = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.NOTIFY_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int privateNum = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.CARD_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int card = ids.size();
            //未读数

            model.addAttribute("daily", daily);
            model.addAttribute("classes", classes);
            model.addAttribute("task", task);
            model.addAttribute("private", privateNum);
            model.addAttribute("score", score);
            model.addAttribute("card", card);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", messageIds.size());
            model.addAttribute("messages", messages);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/message/json/messageListJson";
    }


    /**
     * 查询所有消息--保留接口，用于APP
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/receive/message/list", method = RequestMethod.GET)
    public String getReceiveMessage(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Integer page,
                                    Integer size, Integer status) throws Exception {
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        log.info("receive message :  start = " + start + " , size=" + size + " , status = " + status);

        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            List<Long> ids = messageService.getMessageIdsByReceiveIdAndStatus(uid, status, start, size);
            if (null == ids) {
                model.addAttribute("code", -7000);
                log.info("the user message is null");
                return "/common/success";
            }
            List<Long> mids = messageService.getMessageIdsByReceiveIdAndUnreadAndStatusAndType(uid, 1, 1, "like", 0, Integer.MAX_VALUE);
            if (!(mids == null)) {
                List<Message> messageLikes = messageService.getObjectsByIds(mids);
                for (Message message : messageLikes) {
                    message.setUnread(0);
                    messageService.update(message);
                }
            }
            List<Message> messages = messageService.getObjectsByIds(ids);
            log.info("messages is " + messages.size());
            List<Long> messageIds = messageService.getMessageIdsByReceiveIdAndStatus(uid, 1, 0, Integer.MAX_VALUE);
            boolean next = false;
            if (messageIds.size() > end + 1) {
                next = true;
            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", messageIds.size());
            model.addAttribute("messages", messages);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-skill-service/message/json/messageListJson";
    }


    /**
     * 发送私信
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param uid
     * @param content
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/message/private/", method = RequestMethod.POST)
    public String insertPrivateMessage(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, Integer page,
                                       Integer size, Long uid, String content) throws Exception {
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("receive message :  start = " + start + " , size=" + size + "  + uid = " + uid + "content = " + content);
        if (StringUtil.isEmpty(content)) {
            model.addAttribute("code", -7004);
            log.info("content is Null");
            return "/common/success";
        }
        //html转义
        //content = CheckDataUtil.htmlEncode(content);
        //log.info(" htmlEncode content is " + content);

        if (uid == null) {
            model.addAttribute("code", -1000);
            log.info("uid is Null");
            return "/common/success";
        }
        try {
            int privateMessageCount = 0;
            //  获取登录用户的数据
            User user = (User) request.getAttribute("user");
            Long sendUid = user.getId();
            User receiveUser = userService.getObjectById(uid);
            log.info(receiveUser);

            String userNick = setUserShowName(user.getId());
            log.info(" userNick:" + userNick);

            String notifyMessage = "<span class=\"font-16px  system-alert-outline  ng-scope\"><a data-mid=\"67054\" ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" href=\"/school/" + user.getId() + "/class\"><span class=\"font-green\">" + userNick + "</span> </a> 给你发送了一条" + "<a ng-click=\"sendAlertMsg(li.id)\"  target=\"_blank\" href=\"/school/" + uid + "/privateDetail/" + user.getId() + "/\"><span class='font-green'>私信</span></a></span>";
            Long timeStr = new Date().getTime();
            SimpleDateFormat timeType = new SimpleDateFormat("yyyy-MM-dd ");
            String nowTime = timeType.format(new Date(Long.parseLong(String.valueOf(timeStr))));
            Long minTodayUnix = timeType.parse(nowTime).getTime();
            List<Long> messagesTodayUnixList = messageService.getMessagesTodayUnixList(uid, minTodayUnix, start, Integer.MAX_VALUE);
            int TodayNum = messagesTodayUnixList.size();
            List<Long> users = this.constantService.getConstantIdsByType(Message.Type_privateCount, 0, Integer.MAX_VALUE);
            List<Constant> constantsUsersList = constantService.getObjectsByIds(users);
            for (Constant constant : constantsUsersList) {
                if (Message.Name_privateMessageCount.equals(constant.getName())) {
                    privateMessageCount = Integer.valueOf(constant.getValue());
                }
            }
            //获取当前时间戳。判断当天是否发送超过500条。
            //从常量表里面 设定每天发送限制500条，然后进行判断；
            if (TodayNum <= privateMessageCount) {
                //生成一条系统通知 type 为notify
                Message notifyItem = new Message();
                notifyItem.setSendId(sendUid);
                notifyItem.setReceiveId(receiveUser.getId());
                notifyItem.setSendName(user.getNick());
                notifyItem.setReceiveName(receiveUser.getNick());
                notifyItem.setContent(notifyMessage);
                notifyItem.setStatus(Message.STATUS_UNDELETE);
                notifyItem.setUnread(Message.Status_Unread);
                notifyItem.setType(Message.NOTIFY_TYPE);
                notifyItem.setReceiveId(uid);
                messageService.insert(notifyItem);

                Integer unreadNum = receiveUser.getIsLook() + 1;
                receiveUser.setIsLook(unreadNum);
                receiveUser.setLatestMsg("notify");
                userService.update(receiveUser);

                Message item = new Message();
                item.setSendId(sendUid);
                item.setReceiveId(receiveUser.getId());
                item.setSendName(user.getNick());
                item.setReceiveName(receiveUser.getNick());
                item.setContent(content);
                item.setStatus(Message.STATUS_UNDELETE);
                item.setUnread(Message.Status_Unread);
                item.setType(Message.PRIVATE_TYPE);
                item.setReceiveId(uid);
                messageService.insert(item);
                model.addAttribute("code", 0);
            } else {
                model.addAttribute("code", -7005);
                log.info("the user messageNum is max");
                return "/common/success";
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 删除单条消息
     *
     * @param request
     * @param response
     * @param model
     * @param mid
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/message/{mid}", method = RequestMethod.DELETE)
    public String deleteMessage(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long mid)
            throws Exception {
        log.info("delete message : mid= " + mid);
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Message message = messageService.getObjectById(mid);
            if (null == message) {
                model.addAttribute("code", -7000);
                log.info("no this user");
                return "/common/success";
            }

            if (message.getReceiveId().equals(uid)) {
                if (Message.Status_Unread.equals(message.getUnread())) {
                    //未读消息被删除，用户未读消息数减1
                    log.info(message.getId() + " is unread " + message.getUnread() + " ready to update user unread message count ");
                    Integer unreadNum = user.getIsLook() - 1;
                    user.setIsLook(unreadNum);
                    boolean result = this.userService.update(user);
                    log.info(message.getId() + " is unread " + message.getUnread() + "  update user " + user.getId() + " unread message count result is  " + result);
                }

                message.setStatus(Message.STATUS_DELETE);
                message.setUnread(Message.Status_Unread);
                messageService.update(message);
                model.addAttribute("code", 0);

            } else {
                model.addAttribute("code", -7001);
                log.info("not your message");
                return "/common/success";
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete message error,mid is  " + mid);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 删除私信消息列表
     *
     * @param request
     * @param response
     * @param model
     * @param uid
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/message/private/{uid}", method = RequestMethod.DELETE)
    public String deleteMessageByUid(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long uid)
            throws Exception {
        log.info("delete message : uid= " + uid);
        try {
            User user = (User) request.getAttribute("user");
            Long userId = user.getId();
            Message message = messageService.getObjectById(uid);
            if (null == message) {
                model.addAttribute("code", -7000);
                log.info("no this user");
                return "/common/success";
            }
            //Sql语句查询所有聊天详情
            List<Long> messageIdsByReceiveIdAndSendIdList = messageService.getMessageIdsByReceiveIdAndSendId(userId, uid, 0, Integer.MAX_VALUE);
            List<Message> messageListByReceiveIdAndSendIdList = messageService.getObjectsByIds(messageIdsByReceiveIdAndSendIdList);
            for (Message item : messageListByReceiveIdAndSendIdList) {
                log.info(item);
                if (Message.Status_Unread.equals(item.getUnread())) {
                    item.setUnread(Message.Status_Unread);
                    Integer unreadNum = user.getIsLook() - 1;
                    user.setIsLook(unreadNum);
                }


                if (!(item.getStatus().equals(Message.STATUS_ALLDELETE))) {
                    if (item.getSendId().equals(userId) && !(item.getStatus().equals(Message.STATUS_RECEIVEDELETE))) {
                        item.setStatus(Message.STATUS_SENDDELETE);
                    } else if (item.getSendId().equals(userId) && item.getStatus().equals(Message.STATUS_RECEIVEDELETE)) {
                        item.setStatus((Message.STATUS_ALLDELETE));
                    }
                    //当登录用户作为收件人删除信息
                    if (item.getReceiveId().equals(userId) && !(item.getStatus().equals(Message.STATUS_SENDDELETE))) {
                        item.setStatus(Message.STATUS_RECEIVEDELETE);
                    } else if (item.getReceiveId().equals(userId) && item.getStatus().equals(Message.STATUS_SENDDELETE)) {
                        item.setStatus((Message.STATUS_ALLDELETE));
                    }
                }
            }
            messageService.updateList(messageListByReceiveIdAndSendIdList);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete message error,mid is  " + uid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 删除单个私信消息
     *
     * @param request
     * @param response
     * @param model
     * @param mid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/message/private/mid/{mid}", method = RequestMethod.DELETE)
    public String deleteMessageByMid(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long mid)
            throws Exception {
        try {
            User user = (User) request.getAttribute("user");
            Long userId = user.getId();
            log.info("mid is " + mid);
            log.info("userId is " + userId);
            if (null == mid) {
                model.addAttribute("code", -1);
                return "/common/success";
            }
            Message message = messageService.getObjectById(mid);

            if (!(message.getStatus().equals(Message.STATUS_ALLDELETE))) {
                if (message.getSendId().equals(userId) && !(message.getStatus().equals(Message.STATUS_RECEIVEDELETE))) {
                    message.setStatus(Message.STATUS_SENDDELETE);
                } else if (message.getSendId().equals(userId) && message.getStatus().equals(Message.STATUS_RECEIVEDELETE)) {
                    message.setStatus((Message.STATUS_ALLDELETE));
                }
                //当登录用户作为收件人删除信息
                if (message.getReceiveId().equals(userId) && !(message.getStatus().equals(Message.STATUS_SENDDELETE))) {
                    message.setStatus(Message.STATUS_RECEIVEDELETE);
                } else if (message.getReceiveId().equals(userId) && message.getStatus().equals(Message.STATUS_SENDDELETE)) {
                    message.setStatus((Message.STATUS_ALLDELETE));
                }
            }

            messageService.update(message);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete message error,mid is  " + mid);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 单条消息已读
     *
     * @param request
     * @param response
     * @param model
     * @param mid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/read/message/{mid}", method = RequestMethod.PUT)
    public String readMessage(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long mid)
            throws Exception {

        log.info("read message : mid= " + mid);
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Message message = messageService.getObjectById(mid);
            if (null == message) {
                model.addAttribute("code", -7002);
                log.info("no this message");
                return "/common/success";
            }
            if (!(message.getReceiveId().equals(uid))) {
                model.addAttribute("code", -7001);
                log.info("not your message");
                return "/common/success";
            }

            if (message.getUnread().equals(0)) {
                model.addAttribute("code", -7003);
                log.info("already read the message");
                return "/common/success";
            }
            message.setUnread(Message.Status_read);
            messageService.update(message);
            Integer unreadNum = user.getIsLook();
            user.setIsLook(unreadNum - 1);
            userService.update(user);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("read message error,mid is  " + mid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 私信列表 双方所有消息已读
     *
     * @param request
     * @param response
     * @param model
     * @param pid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/read/message/private/{pid}", method = RequestMethod.PUT)
    public String privateReadMessage(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long pid)
            throws Exception {

        log.info("read  privateMessage ");
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            log.info(uid);
            log.info(pid);
            List<Long> messagesReceiveAndSendIdsList = messageService.getMessageIdsByReceiveIdAndSendId(uid, pid, 0, Integer.MAX_VALUE);
            List<Message> messagesReceiveAndSendList = messageService.getObjectsByIds(messagesReceiveAndSendIdsList);
            log.info("messagesReceiveAndSendList is" + messagesReceiveAndSendList.size());
            for (Message message : messagesReceiveAndSendList) {
                if (message.Status_Unread.equals(message.getUnread())) {
                    log.info(message);
                    message.setUnread(Message.Status_read);
                }
            }
            messageService.updateList(messagesReceiveAndSendList);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("read message all error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 消息全部已读
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/read/message/all", method = RequestMethod.PUT)
    public String allReadMessage(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model)
            throws Exception {

        log.info("read message all");
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            List<Long> messageIds = messageService.getMessageIdsByReceiveIdAndUnreadAndStatus(uid, Message.Status_Unread, Message.STATUS_UNDELETE, 0, Integer.MAX_VALUE);
            List<Message> messages = messageService.getObjectsByIds(messageIds);
            for (Message message : messages) {
                message.setUnread(Message.Status_read);
                messageService.update(message);
            }
            user.setIsLook(0);
            userService.update(user);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("read message all error");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 消息部分已读
     *
     * @param request
     * @param response
     * @param model
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/read/message/type/{type}", method = RequestMethod.PUT)
    public String listReadMessage(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable String type)
            throws Exception {

        log.info(" listMessageRead  type is " + type);
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Integer IsLookNum = user.getIsLook();
            //获取未读消息列表，不用上面的方法，因为原有的classes不包含teacher
            Map<String, Object> params = DynamicUtil.getMessageListParam(Message.STATUS_UNDELETE, type, uid, Message.Status_Unread, false);
            log.info("params is ：" + params);
            List<Long> messageIds = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);

            List<Message> messages = messageService.getObjectsByIds(messageIds);
            log.info("messages size is " + messages.size());
            for (Message message : messages) {
                if (message.getUnread().equals(Message.Status_Unread)) {
                    message.setUnread(Message.Status_read);
                    IsLookNum--;
                }
            }
            user.setIsLook(IsLookNum);
            userService.update(user);
            messageService.updateList(messages);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("read message all error");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 获取私信未读数
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/receive/message/unReadCount", method = RequestMethod.GET)
    public String unReadMessageCount(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model)
            throws Exception {
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            List<Long> messageIds = messageService.getMessageIdsByReceiveIdAndUnreadAndStatusAndType(uid, Message.Status_Unread, Message.STATUS_UNDELETE, "private", 0, Integer.MAX_VALUE);
            List<Message> messages = messageService.getObjectsByIds(messageIds);
            model.addAttribute("code", 0);
            model.addAttribute("messages", messages);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("unReadCount all error");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/message/json/messageListJson";
    }


    /**
     * kenghu-根据类型获取消息列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status
     * @param type
     * @param pid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/k/message/search", method = RequestMethod.GET)
    public String VGetReceiveMessageByType(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model, Integer page,
                                           Integer size, Integer status, String type, Long pid) throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        int end = start + size - 1;

        log.info("receive message :  start = " + start + " , size=" + size + " , status = " + status + " type = " + type);

        //未登录返回-2，前端模态框提示用户重新登录
        Long uid = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("current login user's id = " + uid);
        if (DataUtils.isNullOrEmpty(uid)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "web-kenghu/message/messageList";
        }

        try {
            //计算总的未读消息数
            Map<String, Object> unreadParams = DynamicUtil.getMessageListParam(Message.STATUS_UNDELETE, type, uid, Message.Status_Unread, false);
            List<Long> unreadIds = messageService.getIdsByDynamicCondition(Message.class, unreadParams, 0, Integer.MAX_VALUE);
            Integer unreadNum = unreadIds.size();
            log.info("user's total unread messages number = " + unreadNum);

            //根据入参动态地获取消息列表
            Map<String, Object> params = DynamicUtil.getMessageListParam(Message.STATUS_UNDELETE, type, uid, null, false);
            List<Long> ids = messageService.getIdsByDynamicCondition(Message.class, params, start, size);
            log.info("message ids size = " + ids.size());

            //获取total
            List<Long> allIds = messageService.getIdsByDynamicCondition(Message.class, params,0, Integer.MAX_VALUE);
            log.info("allIds size = " + allIds.size());

            //若message的ids为空，则直接返回
            if (CollectionUtils.isEmpty(ids)) {
                log.info("the user message is null");
                model.addAttribute("code", -7000);
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
                model.addAttribute("uid", uid);
                return "web-kenghu/message/messageList";
            }

            List<Message> messages = new ArrayList<>();
            List<Long> uids = new ArrayList<>();
            List<Long> messageIds = new ArrayList<>();

            messages = messageService.getObjectsByIds(ids);
            log.info("user's messages size = " + messages.size());

            //判断是否存在第二页，end为第一页最后一条数据
            boolean next = false;
            if (messageIds.size() > end + 1) {
                next = true;
            }

            //获取消息未读数
            params = DynamicUtil.getMessageListParam(status, Message.DAILY_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int daily = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.CLASS_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int classes = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.TASK_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int task = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.SCORE_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int score = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.NOTIFY_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int privateNum = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.CARD_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int card = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.QUESTION_TYPE, uid, Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int question = ids.size();

            //如果为坑乎的消息，需要返回与message的relationId字段对应的questionMap，和一个nickMap
            if (Objects.equals(type, Message.QUESTION_TYPE)) {

                Map<Long, Question> questionMap = new HashMap<>();//对应message的relationId的questionMap
                Map<Long, String> nickMap = new HashMap<>();//对应message的sendId的nickMap

                for (Message message : messages) {
                    Long questionId = message.getRelationId();
                    Question question1 = questionService.getObjectById(questionId);
                    Long senderId = message.getSendId();
                    User sender = userService.getObjectById(senderId);
                    if (!sender.getOid().equals(User.Occupation_None)) {
                        Occupation senderOccupation = occupationService.getObjectById(sender.getOid());
                        nickMap.put(senderId, commonUtil.setUserShowName(sender, senderOccupation));
                    } else {
                        nickMap.put(senderId, commonUtil.setUserShowName(sender, null));
                    }
                    questionMap.put(questionId, question1);
                }

                model.addAttribute("questionMap", questionMap);
                model.addAttribute("nickMap", nickMap);
            }

            Integer totalPage = 1;
            Integer total = allIds.size();
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", messages.size());
            model.addAttribute("pSize", size);
            model.addAttribute("next", next);
            model.addAttribute("uid", uid);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("daily", daily);
            model.addAttribute("classes", classes);
            model.addAttribute("task", task);
            model.addAttribute("private", privateNum);
            model.addAttribute("score", score);
            model.addAttribute("card", card);
            model.addAttribute("question", question);
            model.addAttribute("messages", messages);
            model.addAttribute("unreadNum", unreadNum);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }
        return "web-kenghu/message/messageList";
    }


    public String setUserShowName(Long uid) {
        String userNick = null;
        try {

            //无名、散修和外门展示学号，只有内门及内门以上的用户展示昵称
            //有分院展示分院，有职业展示职业
            String branch = null;
            User user = userService.getObjectById(uid);
            if (DataUtils.isNotNullOrEmpty(user.getBranch())) {
                Long userBranch = user.getBranch().longValue();
                BranchInstitute branchDetail = branchInstituteService.getObjectById(userBranch);
                branch = branchDetail.getName() + "分院|";
            }
            log.info("user branch is:" + branch);
            String userOccupationName = null;
            long userNumber = user.getStudyNumber();
            int identity = user.getIdentity();
            log.info("identity is :" + identity);
            if (!user.getOid().equals(User.Occupation_None)) {
                Long userOid = user.getOid();
                Occupation userOccupation = occupationService.getObjectById(userOid);
                userOccupationName = userOccupation.getName().toUpperCase();
            }

            //10、无名弟子 20、散修弟子 30、外门弟子 40、内门弟子  50、首席弟子  55 荣耀师兄 60、真传弟子  70、修真长老

            if (identity == User.IDENTIFY_10) {
                userNick = "[" + User.IDENTIFY_10_str + "] " + user.getNick();
            } else if (identity == User.IDENTIFY_20) {
                userNick = "[" + User.IDENTIFY_20_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + String.valueOf(userNumber);
            } else if (identity == User.IDENTIFY_30) {
                userNick = "[" + User.IDENTIFY_30_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + String.valueOf(userNumber);
            } else if (identity == User.IDENTIFY_40) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_40_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_50) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_50_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_55) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_55_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_60) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_60_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_70) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_70_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            }
        } catch (Throwable t) {
            log.error("error is ", t);
        }
        log.info("userNick  is:" + userNick);
        return userNick;
    }
}

