package com.ptteng.common.skill.util;

import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.Record;
import org.apache.commons.lang3.StringUtils;
import com.qding.common.util.DataUtils;
import org.springframework.ui.ModelMap;

import java.util.regex.Pattern;

/**
 * Created by J.w on 2018/1/18.
 * 功能描述：
 */
public class DataValidatorUtil {
    /**
     * 正则表达式：验证用户名
     */
    public static final String REGEX_USERNAME = "^[a-zA-Z]\\w{5,20}$";

    /**
     * 正则表达式：验证密码
     */
    public static final String REGEX_PASSWORD = "^[a-zA-Z0-9]{6,20}$";

    /**
     * 正则表达式：验证手机号
     */
    public static final String REGEX_MOBILE = "^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$";

    /**
     * 正则表达式：验证邮箱
     */
    public static final String REGEX_EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";

    /**
     * 正则表达式：验证汉字
     */
    public static final String REGEX_CHINESE = "^[\u4e00-\u9fa5],{0,}$";

    /**
     * 正则表达式：验证身份证
     */
    public static final String REGEX_ID_CARD = "(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)";

    /**
     * 正则表达式：验证URL
     */
    public static final String REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";

    /**
     * 正则表达式：验证IP地址
     */
    public static final String REGEX_IP_ADDR = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";

    /**
     * 校验用户名
     *
     * @param username
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isUsername(String username) {
        return Pattern.matches(REGEX_USERNAME, username);
    }

    /**
     * 校验密码
     *
     * @param password
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isPassword(String password) {
        return Pattern.matches(REGEX_PASSWORD, password);
    }

    /**
     * 校验手机号
     *
     * @param mobile
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isMobile(String mobile) {
        return Pattern.matches(REGEX_MOBILE, mobile);
    }

    /**
     * 校验邮箱
     *
     * @param email
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isEmail(String email) {
        return Pattern.matches(REGEX_EMAIL, email);
    }

    /**
     * 校验汉字
     *
     * @param chinese
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isChinese(String chinese) {
        return Pattern.matches(REGEX_CHINESE, chinese);
    }

    /**
     * 校验身份证
     *
     * @param idCard
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isIDCard(String idCard) {
        return Pattern.matches(REGEX_ID_CARD, idCard);
    }

    /**
     * 校验URL
     *
     * @param url
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isUrl(String url) {
        return Pattern.matches(REGEX_URL, url);
    }

    /**
     * 校验IP地址
     *
     * @param ipAddr
     * @return
     */
    public static boolean isIPAddr(String ipAddr) {
        return Pattern.matches(REGEX_IP_ADDR, ipAddr);
    }

    /**
     * 对传入的Record实体对象的属性做非空校验
     * 此处还做了address的非空校验
     * 但是没做银行卡号的校验
     */
    public static boolean checkRecord(Record record, ModelMap model) {

        if (StringUtil.isEmpty(record.getName())) {
            model.addAttribute("code", -40000);
            return false;
        }if (StringUtil.isEmpty(record.getAvatar())) {
            model.addAttribute("code", -40001);
            return false;
        }if (StringUtil.isEmpty(record.getIdentityNum())) {
            model.addAttribute("code", -40002);
            return false;
        }if (StringUtil.isEmpty(record.getProvince())) {
            model.addAttribute("code", -40003);
            return false;
        }if (StringUtil.isEmpty(record.getCity())) {
            model.addAttribute("code", -40004);
            return false;
        }if (StringUtil.isEmpty(record.getCounty())) {
            model.addAttribute("code", -40005);
            return false;
        }if (StringUtil.isEmpty(record.getContactName())) {
            model.addAttribute("code", -40006);
            return false;
        }if (StringUtil.isEmpty(record.getContactRelation())) {
            model.addAttribute("code", -40007);
            return false;
        }if (StringUtil.isEmpty(record.getContactMobile())) {
            model.addAttribute("code", -40008);
            return false;
        }if (StringUtil.isEmpty(record.getCardNum())) {
            model.addAttribute("code", -40009);
            return false;
        }if (StringUtil.isEmpty(record.getBank())) {
            model.addAttribute("code", -40010);
            return false;
        }if (StringUtil.isEmpty(record.getSource())) {
            model.addAttribute("code", -40011);
            return false;
        }if (StringUtil.isEmpty(record.getIdentityFrontUrl())) {
            model.addAttribute("code", -40012);
            return false;
        }if (StringUtil.isEmpty(record.getIdentityReverseUrl())) {
            model.addAttribute("code", -40013);
            return false;
        }
        if (DataUtils.isNullOrEmpty(record.getIsLoan())) {
            model.addAttribute("code", -40014);
            return false;
        }if (DataUtils.isNullOrEmpty(record.getIsWork())) {
            model.addAttribute("code", -40015);
            return false;
        }if (DataUtils.isNullOrEmpty(record.getGrade())) {
            model.addAttribute("code", -40016);
            return false;
        }if (DataUtils.isNullOrEmpty(record.getEducatedEndAt())) {
            model.addAttribute("code", -40017);
            return false;
        }if (DataUtils.isNullOrEmpty(record.getEducatedStartAt())) {
            model.addAttribute("code", -40018);
            return false;
        }if (DataUtils.isNullOrEmpty(record.getSex())) {
            model.addAttribute("code", -40019);
            return false;
        }if (DataUtils.isNullOrEmpty(record.getUid())) {
            model.addAttribute("code", -40020);
            return false;
        }

        //用有工作经验的，工作经历不能为空
        if (record.getIsWork().equals(Record.WORK_YES) && StringUtils.isEmpty(record.getWorkExp())) {
            model.addAttribute("code", -38026);
            return false;
        }

        //贷款学员户口簿本人页照片不能为空
        if (record.getIsLoan().equals(Record.LOAN_YES) && StringUtil.isEmpty(record.getHouseholdRegisterUrl())) {
            model.addAttribute("code", -38027);
            return false;
        }

        //性别校验
        if (record.getSex() < Record.SEX_MALES || record.getSex() > Record.SEX_FEMALES) {
            model.addAttribute("code", -38028);
            return  false;
        }

        //身份证号校验
        if (!DataValidatorUtil.isIDCard(record.getIdentityNum())) {
            model.addAttribute("code", -38029);
            return false;
        }

        //学历校验,不能低于小学或高于博士后
        if (record.getGrade() < Record.GRADE_PRIMARY || record.getGrade() > Record.GRADE_DOCTOR) {
            model.addAttribute("code", -38030);
            return false;
        }

        //学历为中专以上的，学校和专业不能为空
        if (record.getGrade() > Record.GRADE_SECONDARY && (StringUtils.isEmpty(record.getSchool()) || StringUtils.isEmpty(record.getMajor()))) {
            model.addAttribute("code", -38031);
            return false;
        }

        if (!DataValidatorUtil.isMobile(record.getContactMobile())) {
            model.addAttribute("code", -38032);
            return false;
        }

        return true;
    }
}
