package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Classes;
import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.UserScore;
import com.ptteng.common.skill.service.MessageService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.UserScoreService;
import com.ptteng.common.skill.service.UserService;

import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.HttpClientUtil;
import com.sun.org.apache.bcel.internal.generic.NEW;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.qding.common.util.DataUtils;



import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;


/**
 * UserScore  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserScoreController {
	private static final Log log = LogFactory.getLog(UserScoreController.class);

	@Autowired
	private UserScoreService userScoreService;

	@Autowired
	private MessageService messageService;

	@Autowired
	private UserService userService;

	@Autowired
	private OccupationService occupationService;



    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
    //获取积分记录
	@RequestMapping(value = "/a/u/score/search", method = RequestMethod.GET)
	public String getUserScoreList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model , Integer page, Integer size,Long uid,Integer scoreType)
			throws Exception {
		log.info("/a/u/userScore uid=" + uid );

		List<Long> idList = new ArrayList();
		List<UserScore> userScoreList = new ArrayList();
		Long total = 0L;
		if(DataUtils.isNullOrEmpty(uid)){
			log.error("uid is null");
			model.addAttribute("code",-1);
			return "/common/success"
;		}


		log.info(" uid = "+uid);
		if (null == page) {
			page = 1;
		}
		if (null == size) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			Map<String,Object> paramList = DynamicUtil.getScoresListParam(uid,scoreType, false);
			log.info("paramList size =" + paramList.size());
			//获取积分scoresIdList
			List<Long> scoresIdList = userScoreService.getIdsByDynamicCondition(UserScore.class,paramList,start, size);
			if (CollectionUtils.isEmpty(scoresIdList)){
				log.info("scoresIdList is null");
			}else{
				log.info("scores size ="+scoresIdList.size());
			}
			//获取total
			Map<String, Object> paramCount = DynamicUtil.getScoresListParam(uid,scoreType, true);
			log.info("get param:" + paramCount);
			List<Long> scoresIdCount = userScoreService.getIdsByDynamicCondition(UserScore.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("get scoresIdCount:" + scoresIdCount.size());
			if (CollectionUtils.isNotEmpty(scoresIdCount)) {
				total = scoresIdCount.get(0);
			}
			//获取scoresList
			List<UserScore> scoresList = userScoreService.getObjectsByIds(scoresIdList);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("userScoreList", scoresList);
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userScore error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		log.info("/userScore  to /userScore/view/userScoreList");

		return "/common-skill-service/userScore/json/userScoreListJson";
	}

}

