package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.GetUserFromCookieUtil;
import com.ptteng.common.skill.util.LogUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Document  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DocumentController {
    private static final Log log = LogFactory.getLog(DocumentController.class);

    @Autowired
    private DocumentService documentService;

    @Autowired
    private UserService userService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private TaskSkillRelationService taskSkillRelationService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private SkillService skillService;

    @Autowired
    private UserDocumentRelationService userDocumentRelationService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private GetUserFromCookieUtil getUserFromCookieUtil;

    // 资料预览
    @RequestMapping(value = "/a/task/document", method = RequestMethod.GET)
    public String getSkillMastLoveDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              Long[] sids) throws Exception {
        log.info("getSkillMastLoveDocument ,sids = "+sids);

        try {
            if(DataUtils.isNullOrEmpty(sids)){
                model.addAttribute("code",-1000);
                return "/data/json";
            }
            List<Long> skillIds = new ArrayList<>();
            for(Long skillId : sids){
                skillIds.add(skillId);
            }

            List<Document> documents = DynamicUtil.getSkillMastLoveDocument(sids,Document.Type_Document);
            List<Document> videos = DynamicUtil.getSkillMastLoveDocument(sids,Document.Type_Video);
            List<Skill> skills = skillService.getObjectsByIds(skillIds);

            model.addAttribute("code", 0);
            model.addAttribute("skills", skills);
            model.addAttribute("documents", documents);
            model.addAttribute("videos", videos);

        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/skillDocumentListJson";
    }



    // 获取文档详情
    @RequestMapping(value = "/a/document/{did}", method = RequestMethod.GET)
    public String getDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              @PathVariable Long did) throws Exception {
        log.info("getDocument [did:" + did + "]");

        try {
            Document document = documentService.getObjectById(did);

            // 校验
            if (document == null) {
                model.addAttribute("code", -6008);
                return "/common/success";
            }

            model.addAttribute("code", 0);
            model.addAttribute("document", document);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentDetailJson";
    }


    // 获取文档详情
    @RequestMapping(value = "/a/book/document/{did}", method = RequestMethod.GET)
    public String getBookDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              @PathVariable Long did) throws Exception {
        log.info("getBookDocument [did:" + did + "]");

        try {
            Document document = documentService.getObjectById(did);

            // 校验
            if (document == null) {
                model.addAttribute("code", -6008);
                return "/common/success";
            }

            model.addAttribute("code", 0);
            model.addAttribute("document", document);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentDetailJson";
    }


    // 获取文档详情
    @RequestMapping(value = "/a/u/book/document/{did}", method = RequestMethod.GET)
    public String getBookDocumentByLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                         @PathVariable Long did) throws Exception {
        log.info("getBookDocument [did:" + did + "]");

        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();

            Document document = documentService.getObjectById(did);

            // 校验
            if (document == null) {
                model.addAttribute("code", -6008);
                return "/common/success";
            }

            boolean like = false;
            boolean collection = false;

            Long likeRelation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, did, 1, 1);
            Long collectionRlation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, did, 2, 1);

            if (likeRelation != null){
                like = true;
            }

            if (collectionRlation != null){
                collection = true;
            }


            model.addAttribute("code", 0);
            model.addAttribute("document", document);
            model.addAttribute("like", like);
            model.addAttribute("collection", collection);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentDetailJson";
    }




    // 根据职业获取文档
    @RequestMapping(value = "/a/document/{oid}/{type}", method = RequestMethod.GET)
    public String getDocumentByOidAndType(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                          @PathVariable Long oid, @PathVariable Integer type, Integer page, Integer size) throws Exception {
        log.info("getDocumentByOid [oid:" + oid + "]");

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }


        try {
            List<Long> documentIdByOid = documentService.getDocumentIdByOidAndType(oid, type, start, size);
            log.info("the documentlist is=====" + documentIdByOid);

            List<Document> documents = documentService.getObjectsByIds(documentIdByOid);

            Map<Long, String> sid_name = new HashMap<>();
            Map<Long, String> uid_name = new HashMap<>();
            for (Document document : documents) {
                //应移动端RD要求增加文档作者昵称字段返回
                Long author = document.getAuthor();
                User user = this.userService.getObjectById(author);
                if (user == null) {
                    log.info(" author: " + author + " is null");
                }else {
                    String uName = user.getNick();
                    uid_name.put(author, uName);
                }

                if(document.getType()==3)
                    continue;
                Long sid = document.getSid();
                Skill skill = skillService.getObjectById(sid);
                if (skill == null){
                    log.info("documentId: "+document.getId()+" sid: " + sid + " is null");
                } else {
                    String name = skill.getName();
                    sid_name.put(sid, name);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("documents", documents);
            model.addAttribute("sid_name", sid_name);
            model.addAttribute("uid_name", uid_name);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentListJson";
    }

    //29、用户收藏--旧接口，兼容APP
    @RequestMapping(value = "/a/document/collection/{uid}", method = RequestMethod.GET)
    public String getDocumentCollection(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                        @PathVariable Long uid, Integer type, Integer page, Integer size) throws Exception {

        log.info("get collection document data : uid= " + uid + " page= " + page + " size= " + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        if (type == null) {
            type = 1;
        }

        try {
            List<Long> documentIds = new ArrayList<>();
            List<Document> documents = new ArrayList<>();

            List<Long> relationIds = userDocumentRelationService.getUserDocumentRelationIdsByUidAndStatusAndWhether(uid, type, 2, 1, start, size);

            if (relationIds == null) {
                log.info("the user have no collection");
                model.addAttribute("code", -6000);
                return "/common/success";
            }

            Map<Long, Long> documentId_time = new HashMap<>();
            List<UserDocumentRelation> userDocumentRelations = userDocumentRelationService.getObjectsByIds(relationIds);
            for (UserDocumentRelation relation : userDocumentRelations) {
                Long time = relation.getCreateAt();
                Long documentId = relation.getDocumentId();
                documentIds.add(documentId);
                documentId_time.put(documentId, time);
            }
            documents = documentService.getObjectsByIds(documentIds);
            log.info("get collection documents data is " + documents.size());

            //找到那些在documentIds中status=1（喜欢）的项
            Map<String, Object> param = DynamicUtil.getUserDocumentRelationListParam(uid, null, type, 1, 1, false);
            log.info("get param:" + param);

            List<Long> documentLoveIds = this.userDocumentRelationService.getIdsByDynamicCondition(UserDocumentRelation.class, param, 0, Integer.MAX_VALUE);
            log.info("get documentLoveIds:" + documentLoveIds);

            List<DocumentEX> documentEXList = new ArrayList<>();

            Map<Long, String> sid_name = new HashMap<>();
            Map<Long, String> uid_name = new HashMap<>();
            for (Document document : documents) {
                //应移动端RD要求增加文档作者昵称字段返回
                Long author = document.getAuthor();
                User user = this.userService.getObjectById(author);
                if (user == null) {
                    log.info(" author: " + author + " is null");
                }else {
                    String uName = user.getNick();
                    uid_name.put(author, uName);
                }

                //为了移动端需要回传值ifLike、ifCollection添加
                DocumentEX documentEX = new DocumentEX(document);
                documentEX.setIfCollection(true);
                //判断文章是否也同时是用户自身喜欢的
                Boolean ifLike = documentLoveIds.contains(document.getId());
                documentEX.setIfLike(ifLike);

                documentEXList.add(documentEX);

                if(document.getType()==3)
                    continue;
                Long sid = document.getSid();
                Skill skill = skillService.getObjectById(sid);
                if (skill == null){
                    log.info("documentId: "+document.getId()+" sid: " + sid + " is null");
                } else {
                    String name = skill.getName();
                    sid_name.put(sid, name);
                }
            }

            Integer total = userDocumentRelationService.countUserDocumentRelationIdsByUidAndStatusAndWhether(uid, type, 2, 1);
            boolean next = false;
            if (total > end) {
                next = true;
            }

            log.info("uid_name is " + uid_name);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("sid_name", sid_name);
            model.addAttribute("uid_name", uid_name);
            model.addAttribute("documentId_time", documentId_time);
            model.addAttribute("total", total);
            model.addAttribute("documents", documentEXList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get collection document error,uid is  " + uid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentExListJson";
    }



    //29、用户收藏/推荐-10期新
    @RequestMapping(value = "/a/u/my/document/search", method = RequestMethod.GET)
    public String getMyDocuments(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                         Integer type,String modules,Integer orderBy,Integer sort,Long uid, Integer page, Integer size) throws Exception {
        log.info(" uid = "+uid+" modules = "+modules+" orderBy = "+orderBy+" sort = "+sort);
        User user = (User)request.getAttribute("user");
        if(DataUtils.isNullOrEmpty(uid)){
            //如果不传UID，就查询我的收藏
            uid = user.getId();
        }else {
            //如果传了UID，就查询TA的收藏
        }

        log.info("get collection document data : uid= " + uid + " page= " + page + " size= " + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        if (type == null) {
            type = 1;
        }

        try {
            if(StringUtils.isEmpty(modules)){
                modules = Document.COLLECTION;
            }
            if(DataUtils.isNullOrEmpty(orderBy)){
                orderBy=UserArticleRelation.ARTICLE_CREATE_AT;
            }
            if(DataUtils.isNullOrEmpty(sort)){
                sort =UserArticleRelation.DESC;
            }


            List<Long> documentIds = new ArrayList<>();
            List<Document> documents = new ArrayList<>();
            List<DocumentEX> documentEXList = new ArrayList<>();
            Map<Long, String> sid_name = new HashMap<>();
            Map<Long, String> uid_name = new HashMap<>();
            boolean next = false;
            Map<Long, Long> documentId_time = new HashMap<>();
            Integer total = 0;

            if(Document.COLLECTION.equals(modules)){
                //我的收藏
                Map<String,Object>  map = DynamicUtil.getMyCollectionDocumentList(type,uid,  2, 1, orderBy,sort,false);
                List<Long> relationIds = userDocumentRelationService.getIdsByDynamicCondition(UserDocumentRelation.class,map,start,size);

                if (relationIds == null) {
                    log.info("the user have no collection");
                    model.addAttribute("code", -6000);
                    return "/common/success";
                }

                List<UserDocumentRelation> userDocumentRelations = userDocumentRelationService.getObjectsByIds(relationIds);
                for (UserDocumentRelation relation : userDocumentRelations) {
                    Long time = relation.getCreateAt();
                    Long documentId = relation.getDocumentId();
                    documentIds.add(documentId);
                    documentId_time.put(documentId, time);
                }
                documents = documentService.getObjectsByIds(documentIds);
                log.info("get collection documents data is " + documents.size());

                //找到那些在documentIds中status=1（喜欢）的项
                Map<String, Object> param = DynamicUtil.getUserDocumentRelationListParam(uid, null, type, 1, 1, false);
                log.info("get param:" + param);

                List<Long> documentLoveIds = this.userDocumentRelationService.getIdsByDynamicCondition(UserDocumentRelation.class, param, 0, Integer.MAX_VALUE);
                log.info("get documentLoveIds:" + documentLoveIds);




                for (Document document : documents) {
                    //应移动端RD要求增加文档作者昵称字段返回
                    Long authorId = document.getAuthor();
                    User author = this.userService.getObjectById(authorId);
                    if (author == null) {
                        log.info(" author: " + authorId + " is null");
                    }else {
                        String uName = author.getNick();
                        uid_name.put(authorId, uName);
                    }

                    //为了移动端需要回传值ifLike、ifCollection添加
                    DocumentEX documentEX = new DocumentEX(document);
                    documentEX.setIfCollection(true);
                    //判断文章是否也同时是用户自身喜欢的
                    Boolean ifLike = documentLoveIds.contains(document.getId());
                    documentEX.setIfLike(ifLike);

                    documentEXList.add(documentEX);

                    if(document.getType()==3)
                        continue;
                    Long sid = document.getSid();
                    Skill skill = skillService.getObjectById(sid);
                    if (skill == null){
                        log.info("documentId: "+document.getId()+" sid: " + sid + " is null");
                    } else {
                        String name = skill.getName();
                        sid_name.put(sid, name);
                    }
                }

                total = userDocumentRelationService.countUserDocumentRelationIdsByUidAndStatusAndWhether(uid, type, 2, 1);

                if (total > end) {
                    next = true;
                }

                log.info("uid_name is " + uid_name);
            }else {
              //我的推荐--我创建的
                Map<String, Object> param = DynamicUtil.getMyCreateDocumentList(type,uid,orderBy,sort,false);
                documentIds = documentService.getIdsByDynamicCondition(Document.class,param,start,size);
                total =documentService.getIdsByDynamicCondition(Document.class, param, 0, Integer.MAX_VALUE).size();

                if(CollectionUtils.isEmpty(documentIds)){
                    log.info(" user "+uid+" didn't recommend documents");
                }else {
                    documents = documentService.getObjectsByIds(documentIds);
                    for (Document document : documents) {
                        //应移动端RD要求增加文档作者昵称字段返回
                        Long authorId = document.getAuthor();
                        User author = this.userService.getObjectById(authorId);
                        if (author == null) {
                            log.info(" author: " + authorId + " is null");
                        }else {
                            String uName = author.getNick();
                            uid_name.put(authorId, uName);
                        }

                        //为了移动端需要回传值ifLike、ifCollection添加
                        DocumentEX documentEX = new DocumentEX(document);
                        documentEX.setIfCollection(true);
                        documentEXList.add(documentEX);

                        if(document.getType()==3)
                            continue;
                        Long sid = document.getSid();
                        Skill skill = skillService.getObjectById(sid);
                        if (skill == null){
                            log.info("documentId: "+document.getId()+" sid: " + sid + " is null");
                        } else {
                            String name = skill.getName();
                            sid_name.put(sid, name);
                        }
                    }
                }







            }



            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("sid_name", sid_name);
            model.addAttribute("uid_name", uid_name);
            model.addAttribute("documentId_time", documentId_time);
            model.addAttribute("total", total);
            model.addAttribute("documents", documentEXList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get collection document error,uid is  " + uid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentExListJson";
    }


    //30、新增文档
    @RequestMapping(value = "/a/u/document", method = RequestMethod.POST)
    public String addDocument(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, String documentJson) throws Exception {

        log.info(" ===================================================== ");
        log.info("get document : " + documentJson);

        try {
            ObjectMapper mapper = new ObjectMapper();

            if (StringUtils.isBlank(documentJson)) {
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            User user = (User) request.getAttribute("user");
            Long uid = user.getId();

            Document documentObj = mapper.readValue(documentJson, Document.class);
            if (StringUtils.isBlank(documentObj.getDocumentName())){
                model.addAttribute("code", -6010);
                return "/common/success";
            }
            Integer type = documentObj.getType();		//取得文档类型
            Long sid = documentObj.getSid();			//取得文档对应技能id
            if(sid != null) {
            	Skill skill = skillService.getObjectById(sid);//取得对应Skill
            	if(skill != null) {
            		if(type == Document.Type_Document)	//如果是文档，Skill对应文档数加1
            			skill.setDocumentCount(skill.getDocumentCount() + 1);
            		if(type == Document.Type_Video)		//如果是视频，Skill对应视频数加1
            			skill.setVideoCount(skill.getVideoCount() + 1);
            		if(!skillService.update(skill)) {
            			log.info("update skill error, sid: " + sid);
            		}
            	}
            }
            
            documentObj.setAuthor(uid);
            documentObj.setLove(0L);

            log.info("user : " + uid + " insert :" + documentObj);

            Long documentId = documentService.insert(documentObj);

            if (documentId == null) {
				log.info("add document error");
				model.addAttribute("code", -1);
				return "/common/success";
			}
            
            model.addAttribute("code", 0);
            model.addAttribute("documentId", documentId);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add document error ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/addDocumentJson";
    }

    //30、修改文档
    @RequestMapping(value = "/a/u/document/{documentId}", method = RequestMethod.PUT)
    public String updateDocument(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, String documentName, String introduce,
                                 String resource, @PathVariable Long documentId) throws Exception {

        log.info(" ===================================================== ");
        log.info("update document " + documentId + " name,introduce,resource : " + documentName + " , " + introduce + " , " + resource);

        try {
            ObjectMapper mapper = new ObjectMapper();

            if (StringUtils.isBlank(documentName) || StringUtils.isBlank(introduce) || StringUtils.isBlank(resource)) {
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            User user = (User) request.getAttribute("user");
            Long uid = user.getId();

            Document document = documentService.getObjectById(documentId);
            if (!(document.getAuthor().equals(uid))) {
                log.info("is not your document");
                model.addAttribute("code", -6009);
                return "/common/success";
            }

            document.setDocumentName(documentName);
            document.setIntroduce(introduce);
            document.setResource(resource);

            documentService.update(document);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update document error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //31、文档点赞
    @RequestMapping(value = "/a/u/document/like/{documentId}", method = RequestMethod.POST)
    public String like(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                       @PathVariable Long documentId) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        log.info("user :" + uid + " like document : id= " + documentId);
        try {
            Document document = documentService.getObjectById(documentId);
            Integer type = document.getType();

            if (document.equals(null)) {
                log.info("no this document");
                model.addAttribute("code", -6008);
                return "/common/success";
            }

            Long relationId = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatus(uid, documentId, 1);



            if (!(relationId == null)) {
                UserDocumentRelation relation = userDocumentRelationService.getObjectById(relationId);
                if (relation.getWhether() == 0) {
                    relation.setWhether(1);
                    userDocumentRelationService.update(relation);
                } else {
                    log.info("you already like the document");
                    model.addAttribute("code", -6005);
                    return "/common/success";
                }
            } else {
                UserDocumentRelation relation = new UserDocumentRelation();

                relation.setUid(uid);
                relation.setDocumentId(documentId);
                relation.setType(type);
                relation.setWhether(1);
                relation.setStatus(1);

                userDocumentRelationService.insert(relation);
                log.info("add document success");


                if (document.getAuthor() - uid ==0){ //如果评论者是作者本人,那么不发消息

                    log.info("send to self==========");
                }else {                              // 如果点赞别人的文档,那么发消息
                    log.info("send to other==========");

//                    User user2 = userService.getObjectById(document.getAuthor());
//
//                    //存入系统消息
//                    Message message = new Message();
//                    message.setStatus(1);
//                    message.setReceiveName(user2.getNick());
//                    message.setSendName("admin");
//                    message.setSendId(0L);
//                    message.setContent("");
//                    message.setReceiveId(document.getAuthor());
//                    message.setUnread(1);
//                    message.setType("collection");
//                    message.setRelationId(documentId);
//
//                    Long mid = messageService.insert(message);
//
//
//                    //发送系统信息
//                    String name = document.getIntroduce();
//
//                    String content= null;
//                    if (document.getType() - 3!=0){
//                        content = "<span  class=\\\"font-16px system-alert-outline \\\"><a data-mid=" + mid + " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/"+user.getId()+"/class\\\"><span class=\\\"font-green\\\">" + user.getNick() + "</span> </a>赞了您的 " +
//                                "<a   data-mid=" + mid + " ng-click=\\\"sendAlertMsg(li.id)\\\" class=\\\"font-orange\\\" href=\\\"" + document.getUrl() + "\\\" target=\\\"_blank\\\">" + document.getDocumentName() + "</a></span>";
//
//                    }else {
//                        content = "<span  class=\\\"font-16px system-alert-outline \\\"><a data-mid=" + mid + " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/"+user.getId()+"/class\\\"><span class=\\\"font-green\\\">" + user.getNick() + "</span> </a>赞了您的 " +
//                                "<a   data-mid=" + mid + " ng-click=\\\"sendAlertMsg(li.id)\\\" class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/recommendResource//recommendBook/"+document.getId()+"?type=3 \\\">" + document.getDocumentName() + "</a></span>";
//
//                    }
//
//                    adminSend(user2.getMobile(), content);
//
//                    message = messageService.getObjectById(mid);
//
//
//                    log.info("-=-=-=-="+message);
//                    if (null != message){
//                        message.setContent(content);
//                        messageService.update(message);
//                    }

                    //文档点赞不再通知用户
                   /* User user1 = userService.getObjectById(document.getAuthor());
                    log.info("-=-=-=-=-="+user1);


                    if (null != user1){

                        log.info("set before" +(user1.getIsLook()+1));

                        // 获取用户,更改用户查看消息列表的状态
                        user1.setIsLook(user1.getIsLook() + 1);

                        log.info("update before");

                        userService.update(user1);

                        log.info("update later");
                    }
*/


                }
            }

            log.info("zhe li shi like");

            Long like = document.getLove() + 1;
            log.info("like: [before:" + document.getLove() + ",now:" + like + "]");
            document.setLove(like);
            documentService.update(document);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("like document error,id is  " + documentId);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    //32、取消赞
    @RequestMapping(value = "/a/u/document/like/{documentId}", method = RequestMethod.DELETE)
    public String deleteLike(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @PathVariable Long documentId)
            throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        log.info("user :" + uid + " like document : id= " + documentId);
        try {
            Long relationId = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, documentId, 1, 1);


            if (relationId == null) {
                log.info("you do not like the document");
                model.addAttribute("code", -6004);
                return "/common/success";
            }

            UserDocumentRelation userDocumentRelation = userDocumentRelationService.getObjectById(relationId);
            userDocumentRelation.setWhether(0);

            // 状态为1是喜欢,状态为2是收藏 ,如果不是1,就说明不喜欢
//            userDocumentRelation.setStatus(3);
            Document document = documentService.getObjectById(documentId);
            Long like = document.getLove() - 1;
            log.info("deleteLike: [before:" + document.getLove() + ",now:" + like + "]");
            document.setLove(like);


            documentService.update(document);
            userDocumentRelationService.update(userDocumentRelation);

            log.info("delete like document success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete like document error,documentId is  " + documentId);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    //33、收藏文档
    @RequestMapping(value = "/a/u/document/collection/{documentId}", method = RequestMethod.POST)
    public String collection(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @PathVariable Long documentId) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        log.info("user :" + uid + " like document : id= " + documentId);
        try {
            Document document = documentService.getObjectById(documentId);
            Integer type = document.getType();

            if (document.equals(null)) {
                log.info("no this document");
                model.addAttribute("code", -6008);
                return "/common/success";
            }

            Long relationId = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatus(uid, documentId, 2);
            if (relationId != null) {
                UserDocumentRelation relation = userDocumentRelationService.getObjectById(relationId);
                if (relation.getWhether() == 0) {
                    relation.setWhether(1);
                    userDocumentRelationService.update(relation);
                } else {
                    log.info("you already collection the document");
                    model.addAttribute("code", -6006);
                    return "/common/success";
                }
            } else {
                UserDocumentRelation relation = new UserDocumentRelation();

                relation.setUid(uid);
                relation.setDocumentId(documentId);
                relation.setType(type);
                relation.setWhether(1);
                relation.setStatus(2);

                userDocumentRelationService.insert(relation);



                if (document.getAuthor() - uid ==0){ //如果评论者是作者本人,那么不发消息

                    log.info("send to self==========");
                }else {
                    log.info("send to other==========");
                    User user2 = userService.getObjectById(document.getAuthor());


                    //存入系统消息
                    Message message = new Message();
                    message.setStatus(1);
                    message.setReceiveName(user2.getNick());
                    message.setSendName("admin");
                    message.setSendId(0L);
                    message.setContent("");
                    message.setReceiveId(document.getAuthor());
                    message.setUnread(1);
                    message.setType("collection");
                    message.setRelationId(documentId);

                    Long mid = messageService.insert(message);


                    //发送系统信息
                    String name = document.getIntroduce();
                    String content = null;
                    if (document.getType() - 3!=0){
                        content = "<span  class=\\\"font-16px system-alert-outline \\\"><a data-mid=" + mid + " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/"+user.getId()+"/class\\\"><span class=\\\"font-green\\\">" + user.getNick() + "</span> </a>收藏了您的 " +
                                "<a   data-mid=" + mid + " ng-click=\\\"sendAlertMsg(li.id)\\\" class=\\\"font-orange\\\" target=\"_blank\" href=\\\"" + document.getUrl() + "\\\" target=\\\"_blank\\\">" + document.getDocumentName() + "</a></span>";

                    }else {
                        content = "<span  class=\\\"font-16px system-alert-outline \\\"><a data-mid=" + mid + " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/"+user.getId()+"/class\\\"><span class=\\\"font-green\\\">" + user.getNick() + "</span> </a>收藏了您的 " +
                                "<a   data-mid=" + mid + " ng-click=\\\"sendAlertMsg(li.id)\\\" class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/recommendResource//recommendBook/"+document.getId()+"?type=3 \\\">" + document.getDocumentName() + "</a></span>";
                    }
                    log.info("user : " + user.getMobile() + " send : " + content);
                    adminSend(user2.getMobile(), content);

                    message = messageService.getObjectById(mid);
                    message.setContent(content);

                    messageService.update(message);

                    //收藏文档也不通知用户
                  /*  User user1 = userService.getObjectById(document.getAuthor());
                    // 获取用户,更改用户查看消息列表的状态
                    user1.setIsLook(user1.getIsLook() + 1);
                    userService.update(user1);*/
                }
            }

            Long collection = document.getCollection() + 1;
            document.setCollection(collection);
            this.documentService.update(document);

            log.info("collection document success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("collection document error,id is  " + documentId);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    //34、取消收藏
    @RequestMapping(value = "/a/u/document/collection/{documentId}", method = RequestMethod.DELETE)
    public String deleteCollection(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long documentId)
            throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        log.info("user :" + uid + " like document : id= " + documentId);
        try {
            Long relationId = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, documentId, 2, 1);

            if (relationId == null) {
                log.info("you do not like the document");
                model.addAttribute("code", -6003);
                return "/common/success";
            }

            UserDocumentRelation relation = userDocumentRelationService.getObjectById(relationId);
            relation.setWhether(0);
            userDocumentRelationService.update(relation);

            Document document = this.documentService.getObjectById(documentId);
            Long collection = document.getCollection();
            if (collection > 0) {
                collection = collection - 1;
                document.setCollection(collection);
                this.documentService.update(document);
            }


            log.info("add document success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete collection document error,documentId is  " + documentId);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    //36、登陆职业文档
    @RequestMapping(value = "/a/u/occupation/document/{oid}", method = RequestMethod.GET)
    public String getSkillDocumentLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                        @PathVariable Long oid, Integer page, Integer size, Integer type) throws Exception {

        if (type.equals(null)) {
            log.info("type is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        log.info("get occupation document : oid= " + oid);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        log.info("get  user data is " + user);

        try {
            Occupation occupation = occupationService.getObjectById(oid);
            if (occupation.equals(null)) {
                log.info("occupation is null");
                model.addAttribute("code", -4007);
                return "/common/success";
            }

            /*List<Long> sids = taskSkillRelationService.getSidsByOid(oid, 0, Integer.MAX_VALUE);

            List<Long> documentIds = new ArrayList<>();
            for (Long sid : sids) {
                List<Long> ids = documentService.getDocumentIdBySidAndType(sid, type, 0, Integer.MAX_VALUE);
                documentIds.addAll(ids);
            }
            log.info("get document data is " + documentIds);

            if (documentIds == null) {
                log.info("document is null");
                model.addAttribute("code", -6002);
                return "/common/success";
            }

            List<Document> allDocuments = documentService.getObjectsByIds(documentIds);*/

//            Collections.sort(allDocuments);

            /*Integer total = allDocuments.size();
            List<Document> documents = new ArrayList<>();
            for (int i = start; i <= end; i++) {
                if (i >= total) {
                    break;
                }
                documents.add(allDocuments.get(i));
            }*/


            List<Long> documentIds = documentService.getDocumentIdByOidAndType(oid, type, start, size);
            List<Document> documents = documentService.getObjectsByIds(documentIds);

            Integer total = documentService.countDocumentIdByOidAndType(oid, type);

            Map<Long, String> sid_name = new HashMap<>();
            Map<Long,String> uid_name = new HashMap<>();

            for (Document document : documents) {
                User u = userService.getObjectById(document.getAuthor());
                uid_name.put(document.getAuthor(), u.getNick());

                if(document.getType()==3)
                    continue;
                Long sid = document.getSid();
                Skill skill = skillService.getObjectById(sid);
                if (skill == null) {
                    log.info("documentId: " + document.getId() + " sid: " + sid + " is null");
                } else {
                    String name = skill.getName();
                    sid_name.put(sid, name);
                }
            }

            Map<Long, Boolean> documentId_like = new HashMap<>();
            Map<Long, Boolean> documentId_collection = new HashMap<>();
            for (Long documentId : documentIds) {
                Long likeRelation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, documentId, 1, 1);
                Long collectionRlation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, documentId, 2, 1);
                if (likeRelation == null) {
                    documentId_like.put(documentId, false);
                } else {
                    documentId_like.put(documentId, true);
                }
                if (collectionRlation == null) {
                    documentId_collection.put(documentId, false);
                } else {
                    documentId_collection.put(documentId, true);
                }

            }

            boolean next = false;
            if (total > end) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("sid_name", sid_name);
            model.addAttribute("uid_name", uid_name);

            model.addAttribute("total", total);
            model.addAttribute("documentId_like", documentId_like);
            model.addAttribute("documentId_collection", documentId_collection);
            model.addAttribute("documents", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill document error,oid= " + oid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/occupationDocumentListJson";
    }


    //37、职业文档
    @RequestMapping(value = "/a/occupation/document/{oid}", method = RequestMethod.GET)
    public String getSkillDocument(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long oid, Integer page, Integer size, Integer type)
            throws Exception {

        if (type.equals(null)) {
            log.info("type is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        log.info("get occupation document : oid= " + oid);

        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);

        log.info("get  user data is " + user);

        try {
            Occupation occupation = occupationService.getObjectById(oid);
            if (occupation.equals(null)) {
                log.info("occupation is null");
                model.addAttribute("code", -4007);
                return "/common/success";
            }

            /*List<Long> sids = taskSkillRelationService.getSidsByOid(oid, 0, Integer.MAX_VALUE);

            List<Long> documentIds = new ArrayList<>();
            for (Long sid : sids) {
                List<Long> ids = documentService.getDocumentIdBySidAndType(sid, type, 0, Integer.MAX_VALUE);
                documentIds.addAll(ids);
            }
            log.info("get document data is " + documentIds);

            if (documentIds == null) {
                log.info("document is null");
                model.addAttribute("code", -6002);
                return "/common/success";
            }

            List<Document> allDocuments = documentService.getObjectsByIds(documentIds);

//            Collections.sort(allDocuments);

            Integer total = allDocuments.size();
            List<Document> documents = new ArrayList<>();
            for (int i = start; i <= end; i++) {
                if (i >= total) {
                    break;
                }
                documents.add(allDocuments.get(i));
            }*/


            List<Long> documentIds = documentService.getDocumentIdByOidAndType(oid, type, start, size);
            List<Document> documents = documentService.getObjectsByIds(documentIds);

            Integer total = documentService.countDocumentIdByOidAndType(oid, type);


            Map<Long, String> sid_name = new HashMap<>();
            Map<Long, String> uid_name = new HashMap<>();
            for (Document document : documents) {
                //应移动端RD要求增加文档作者昵称字段返回
                Long author = document.getAuthor();
                User user2 = this.userService.getObjectById(author);
                if (user2 == null) {
                    log.info(" author: " + author + " is null");
                }else {
                    String uName = user2.getNick();
                    uid_name.put(author, uName);
                }

                if(document.getType()==3)
                    continue;
                Long sid = document.getSid();
                Skill skill = skillService.getObjectById(sid);
                if (skill == null) {
                    log.info("documentId: " + document.getId() + " sid: " + sid + " is null");
                } else {
                    String name = skill.getName();
                    sid_name.put(sid, name);
                }
            }

            boolean next = false;
            if (total > end) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("sid_name", sid_name);
            model.addAttribute("uid_name", uid_name);
            model.addAttribute("total", total);
            model.addAttribute("documents", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill document error,oid= " + oid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentListJson";
    }


    //36、登陆全部文档
    @RequestMapping(value = "/a/u/all/document", method = RequestMethod.GET)
    public String getAllDocumentLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                      Integer page, Integer size, Integer type) throws Exception {

        if (type == null) {
            log.info("type is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        log.info("get all document");

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        log.info("get  user data is " + user);

        try {

            /* 获取document */
            Map<String, Object> paramList = DynamicUtil.getDocumentParamByType(type, false);
            log.info("get paramList:" + paramList);
            List<Long> documentIds = documentService.getIdsByDynamicCondition(Document.class, paramList, start, size);
            log.info("get documentIds:" + documentIds);
            List<Document> documents = documentService.getObjectsByIds(documentIds);

            /* 获取类型总数 */
            int total = 0;
            Map<String, Object> paramCount = DynamicUtil.getDocumentParamByType(type, true);
            log.info("get paramCount:" + paramCount);
            List<Long> documentCount = documentService.getIdsByDynamicCondition(Document.class, paramCount, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(documentCount)) {
                total = documentCount.get(0).intValue();
            }

            Map<Long, String> sid_name = new HashMap<>();

            for (Document document : documents) {
                if(document.getType()==3)
                    continue;
                Long sid = document.getSid();
                Skill skill = skillService.getObjectById(sid);
                if (skill == null){
                    log.info("documentId: "+document.getId()+" sid: " + sid + " is null");
                } else {
                    String name = skill.getName();
                    sid_name.put(sid, name);
                }
            }

            Map<Long, Boolean> documentId_like = new HashMap<>();
            Map<Long, Boolean> documentId_collection = new HashMap<>();
            for (Long documentId : documentIds) {
                Long likeRelation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, documentId, 1, 1);
                Long collectionRlation = userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, documentId, 2, 1);
                if (likeRelation == null) {
                    documentId_like.put(documentId, false);
                } else {
                    documentId_like.put(documentId, true);
                }
                if (collectionRlation == null) {
                    documentId_collection.put(documentId, false);
                } else {
                    documentId_collection.put(documentId, true);
                }

            }

            boolean next = false;
            if (total > end) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("sid_name", sid_name);
            model.addAttribute("total", total);
            model.addAttribute("documentId_like", documentId_like);
            model.addAttribute("documentId_collection", documentId_collection);
            model.addAttribute("documents", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get all document error");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/occupationDocumentListJson";
    }

    //37、全部文档
    @RequestMapping(value = "/a/all/document", method = RequestMethod.GET)
    public String getAllDocument(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size, Integer type)
            throws Exception {

        if (type == null) {
            log.info("type is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        log.info("get all document");

        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);

        log.info("get  user data is " + user);

        try {
            /* 获取document */
            Map<String, Object> paramList = DynamicUtil.getDocumentParamByType(type, false);
            log.info("get paramList:" + paramList);
            List<Long> documentIds = documentService.getIdsByDynamicCondition(Document.class, paramList, start, size);
            log.info("get documentIds:" + documentIds);
            List<Document> documents = documentService.getObjectsByIds(documentIds);

            /* 获取类型总数 */
            int total = 0;
            Map<String, Object> paramCount = DynamicUtil.getDocumentParamByType(type, true);
            log.info("get paramCount:" + paramCount);
            List<Long> documentCount = documentService.getIdsByDynamicCondition(Document.class, paramCount, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(documentCount)) {
                total = documentCount.get(0).intValue();
            }

            Map<Long, String> sid_name = new HashMap<>();
            for (Document document : documents) {
                if (document.getType() == 3)
                    continue;
                Long sid = document.getSid();
                Skill skill = skillService.getObjectById(sid);
                if (skill == null){
                    log.info("documentId: "+document.getId()+" sid: " + sid + " is null");
                } else {
                    String name = skill.getName();
                    sid_name.put(sid, name);
                }
            }

            boolean next = false;
            if (total > end) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("sid_name", sid_name);
            model.addAttribute("total", total);
            model.addAttribute("documents", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill document error");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/documentListJson";
    }


    /**
     * 资料搜索
     * @param request
     * @param response
     * @param model
     * @param type
     * @param oid
     * @param sids
     * @param name
     * @param rating
     * @param orderBy
     * @param sort
     * @param page
     * @param size
     * @return
     */
    @RequestMapping(value = "/a/document/search", method = RequestMethod.GET)
    public String searchDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 Integer type, Long oid, Long[] sids, String name,  Integer rating,
                                 Integer orderBy, Integer sort, String userType,Integer studyNumber,
                                 Integer page, Integer size) {

        /* 获取搜索者用户信息 */
        Long uid = getUserFromCookieUtil.getUserFromCookie(request);


        /* 入参日志 */
        String logStr = LogUtil.convertParam(uid, " is searching document by ", "type", type,
                "oid", oid, "sids", sids, "name", name, "rating", rating,
                "orderBy", orderBy, "sort", sort, "page", page, "size", size);
        log.info(logStr);

        /* 初始化 */
        if (page == null) {
            page = 1;
        }

        if (size == null) {
            size = 10;
        }

        int start = (page - 1) * size;

        if (start < 0) {
            start = 0;
        }

        if (null == orderBy) {
            orderBy = 3;
        }

        if (null == sort) {
            sort = 0;
        }

        try {

            /* 获取单页的documentIds */
            Map<String, Object> param = DynamicUtil.getDocumentQueryListParam(type, rating, oid, sids, name,
                    orderBy, sort, userType, studyNumber, false);
            log.info("query document_id sql: " + param);
            List<Long> documentIds = this.documentService.getIdsByDynamicCondition(Document.class, param, start, size);
            log.info("documentIds has:" + documentIds);

            /* 获取匹配的单页document类 */
            List<Document> documents = documentService.getObjectsByIds(documentIds);

            /* 获取total */
            List<Long> documentCount = this.documentService.getIdsByDynamicCondition(Document.class, param, 0, Integer.MAX_VALUE);
            log.info(" total = "+documentCount.size());
            Integer total = 0;
            if (CollectionUtils.isNotEmpty(documentCount)) {
                total = documentCount.size();
            }

            /* 获取totalPage */
            int totalPage = 1;
            if(null != total){
                if(total.intValue()>0){
                    totalPage = (((total.intValue() - 1)) / (size)) + 1;;
                }
            }
            /* 统计技能名、作者名 */
            List<Long> uidList = new ArrayList<>(),
                    sidList = new ArrayList<>();
            Map<Long, String> authorNames = new HashMap<>(),
                    skillNames = new HashMap<>();
            Map<Long, Boolean> iflikeMap = new HashedMap(),
                    ifCollectionMap = new HashedMap();

            /* 获取所有sid、arthur */
            int documentSize = documents.size();
            for (int i = 0; i < documentSize; i++) {
                Document document = documents.get(i);
                Long did = document.getId();

                uidList.add(document.getAuthor());
                sidList.add(document.getSid());

                iflikeMap.put(did, false);
                ifCollectionMap.put(did, false);
            }

            /* 获取文档、视频关联技能名称LIST */
            List<Skill> skills = skillService.getObjectsByIds(sidList);
            int skillSize = skills.size();
            for (int i = 0; i < skillSize; i++) {
                Skill skill = skills.get(i);
                skillNames.put(skill.getId(), skill.getName());
            }

            /* 获取作者名LIST */
            List<User> users = userService.getObjectsByIds(uidList);
            int userSize = users.size();
            for (int i = 0; i < userSize; i++) {
                User user = users.get(i);
                authorNames.put(user.getId(), user.getNick());
            }

            if(null != uid ){
                log.info(" user "+uid+" is loging ");
                   /* 获取用户对文档的点赞、收藏状态 */
                Map<String, Object> paramRelation = DynamicUtil.getDocumentRelationListParam(documentIds, uid, false);
                log.info("query relationId sql: " + paramRelation);
                List<Long> relationIds = userDocumentRelationService.getIdsByDynamicCondition(UserDocumentRelation.class, paramRelation, 0, Integer.MAX_VALUE);

            /* 仅当用户-文档关系不为空时执行 */
                if (CollectionUtils.isNotEmpty(relationIds)) {
                    log.info("relationIds has:" + relationIds);
                    List<UserDocumentRelation> relationList = userDocumentRelationService.getObjectsByIds(relationIds);

                    int relationSize = relationList.size();
                    for (int i = 0; i < relationSize; i++) {
                        UserDocumentRelation relation = relationList.get(i);
                        Integer relationStatus = relation.getStatus();
                        Long did = relation.getDocumentId();

                /* 替换掉旧值 */
                        switch (relationStatus) {
                            case 1:
                                iflikeMap.put(did, true);
                                break;
                            case 2:
                                ifCollectionMap.put(did, true);
                                break;
                            default:
                                break;
                        }
                    }
                }

            }



            /* 补充documents的ifLike、ifCollection、rating */
            for (int i = 0; i < documentSize; i++) {
                Document document = documents.get(i);

                Long skillId = document.getSid();
                String skillName = skillNames.get(skillId);
                document.setSkillName(skillName);

                Long userId = document.getAuthor();
                String authorNick = authorNames.get(userId);
                document.setAuthorNick(authorNick);

                Integer rate = null;
                Integer like = document.getLove().intValue();
                // 1-潜力推荐[0,3] 2-普通推荐[4,9] 3-精品推荐[10, +]
                if (like < Document.NORMAL_DOWN_LIMIT) {
                    rate = Document.LOW;
                } else if (like > Document.NORMAL_UP_LIMIT) {
                    rate = Document.BEST;
                } else {
                    rate = Document.NORMAL;
                }
                document.setRating(rate);

                Long did = document.getId();
                document.setIfLike(iflikeMap.get(did));
                document.setIfCollection(ifCollectionMap.get(did));
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("documentList", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("error ," + logStr);
            model.addAttribute("code", -1);
            model.addAttribute("message", "failed");
        }

        return "/common-skill-service/document/json/documentQueryListJson";
    }


    public static String adminSend(String mobile, String content) {
        System.out.print("=====================hhhhhhhh");
        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\"\n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");
        log.info(param);
        log.info(result);

        System.out.println(result+"hhhhhhhhhhhh");
        return result;
    }

//    public static String getToken(){
//        String param = "{\"grant_type\": \"client_credentials\",\"client_id\": \"{YXA6VOd7wNkXEeWLFSFs93v3vw}\",\"client_secret\": \"{YXA6I-8WeDG51_CkfVqia2mfCb3N5gQ}\"}";
//        String result = httpPostData("a1.easemob.com","/jnshu4/jnshu4/token",param);
//        log.info(result);
//        return result;
//    }

}


