package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;


import com.ptteng.common.skill.model.Contents;
import com.ptteng.common.skill.service.ContentsService;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Contents  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ContentsController {
	private static final Log log = LogFactory.getLog(ContentsController.class);

	@Autowired
	private ContentsService contentsService;



	/**
	* 获取单个内容信息
	* @param request
	* @param response
	* @param model
	* @param id
	* @return
	* @throws Exception
	* */
	@RequestMapping(value = "/a/contents/{id}", method = RequestMethod.GET)
	public String getContents(HttpServletRequest request,
							  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		if (id.equals(null)) {
			model.addAttribute("code", -37003);
			log.info("id is null");
			return "/common/success";
		}

		log.info("get  content : content id = " + id);

		try {

			Contents contents = contentsService.getObjectById(id);
			if (contents == null) {
				model.addAttribute("code", -37002);
				log.info("no this contents");
				return  "/common/success";
			} else {
				log.info("get contents data is " + contents);
				model.addAttribute("contents", contents);
				model.addAttribute("code", 0);
			}


		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get contents error, id is " +id);
			model.addAttribute("code", -37001);
		}


		return "/common-skill-service/contents/json/contentsDetailJson";
	}



	/**
	 * 内容搜索
	 * @param request
	 * @param response
	 * @param model
	 * @param type
	 * @param title
	 * @param status
	 * @param createBy
	 * @param createStartAt
	 * @param createEndAt
	 * @param publishStartAt
	 * @param publishEndAt
	 * @param page
	 * @param size
	 * @return
	 */
	@RequestMapping(value = "/a/contents/search", method = RequestMethod.GET)
	public String searchContents(HttpServletRequest request,
								 HttpServletResponse response,
								 ModelMap model,
								 Integer[] type,
								 Integer status,
								 String title,
								 Long createBy,
								 Long createStartAt,
								 Long createEndAt,
								 Long publishStartAt,
								 Long publishEndAt,
								 Integer page,
								 Integer size
								 ) {
		/* 1 初始化参数 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			Map<String, Object> param = DynamicUtil.getContentsQueryListParam(type, status, title, createBy, createStartAt, createEndAt,publishStartAt,publishEndAt,false);
			log.info("contents params is: " + param);

			List<Long> ids = contentsService.getIdsByDynamicCondition(Contents.class, param, start, size);
			log.info("the ids is " + ids);


			List<Contents> contentsList = contentsService.getObjectsByIds(ids);
			log.info("get contents data is " + contentsList.size());

			Map<String, Object> paramCount = DynamicUtil.getContentsQueryListParam(type, status, title, createBy, createStartAt, createEndAt,publishStartAt,publishEndAt,true);
			log.info("count content sql: " + paramCount);
			List<Long> totalList = contentsService.getIdsByDynamicCondition(Contents.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("count contents list: " + totalList);
			Integer total = totalList.get(0).intValue();
			log.info("get contents size is " + total);



			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("contentsList", contentsList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get contentsList error");
			model.addAttribute("code", -37001);
		}

		return "/common-skill-service/contents/json/contentsListJson";
	}



	@RequestMapping(value = "/a/u/contents/sort", method = RequestMethod.PUT)
	public String sortContents(HttpServletRequest request,
							   HttpServletResponse response,
							   ModelMap model,
							   @RequestParam(value = "ids[]") Long[] ids) throws Exception {

		if (ids == null) {
			log.info("sort contents ids is null");
			model.addAttribute("code", -37003);
			return "/data/json";
		} else {
			log.info("sort contents : ids= " + ids);
		}

		List<Long> idList = new ArrayList();
		idList = Arrays.asList(ids);

		try {

			List<Contents> contents = this.contentsService.getObjectsByIds(idList);

			int index = 0;
			for (Contents content : contents) {
				content.setLevel(index);
				index = index + 10;
			}
			this.contentsService.updateList(contents);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("sort contents error,ids is  " + ids);
			model.addAttribute("code", -37007);
		}

		return "/data/json";
	}

	
	
	
	
}

