package com.ptteng.common.skill.util;


import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.UserService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;


public class CommonUtil {


    @Autowired
    private static UserService userService;


    @Autowired
    private OccupationService occupationService;


    @Autowired
    private BranchInstituteService branchInstituteService;

    private static final Log log = LogFactory.getLog(CommonUtil.class);

    public String getUserName(Long uid) {
        String userNick = null;
        try {

            //无名、散修和外门展示学号，只有内门及内门以上的用户展示昵称
            //有分院展示分院，有职业展示职业
            String branch = null;
            User user=userService.getObjectById(uid);
            if (DataUtils.isNotNullOrEmpty(user.getBranch())) {
                Long userBranch = user.getBranch().longValue();
                BranchInstitute branchDetail = branchInstituteService.getObjectById(userBranch);
                branch = branchDetail.getName() + "分院|";
            }
            log.info("user branch is:" + branch);
            String userOccupationName = null;
            long userNumber = user.getStudyNumber();
            int identity = user.getIdentity();
            log.info("identity is :" + identity);
            if (!user.getType().equals(User.TYPE_None)) {
                Long userOid = user.getOid();
                Occupation userOccupation = occupationService.getObjectById(userOid);
                userOccupationName = userOccupation.getName();
            }

            if (identity == User.IDENTIFY_20) {
                userNick = "[无名弟子] " + user.getNick();
            } else if (identity == User.IDENTIFY_20) {
                userNick = "[散修弟子] " + userOccupationName + "-" + String.valueOf(userNumber);
            } else if (identity == User.IDENTIFY_30) {
                userNick = "[外门弟子] " + userOccupationName + "-" + String.valueOf(userNumber);
            } else if (identity == User.IDENTIFY_40) {
                userNick = "[" + branch + "内门弟子] " + userOccupationName + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_50) {
                userNick = "[" + branch + "首席弟子] " + userOccupationName + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_60) {
                userNick = "[" + (branch != null ? branch : "") + "真传弟子] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_70) {
                userNick = "[" + (branch != null ? branch : "") + "修真长老] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            }
        }catch (Throwable t) {
            log.error("error is " , t);
        }
        return  userNick;
    }
}
