package com.ptteng.common.skill.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Sms;
import com.ptteng.common.skill.service.SmsService;

/**
 * Sms  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SmsController {
    private static final Log log = LogFactory.getLog(SmsController.class);

    @Autowired
    private SmsService smsService;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/web/c/sms", method = RequestMethod.GET)
    public String getsmsList(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model) throws Exception {


        log.info("/web/sms  to /sms/view/smsList");

        return "/common-skill-service/sms/view/smsList";
    }


    @RequestMapping(value = "/web/c/sms/{id}", method = RequestMethod.GET)
    public String getSms(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("/web/sms/" + id + "  to /sms/view/smsDeail");
        if (null != id) {
            model.addAttribute("id", id);
        } else {
            model.addAttribute("id", 0);
        }

        return "/common-skill-service/sms/view/smsDetail";
    }


    @RequestMapping(value = "/web/a/sms/{id}", method = RequestMethod.GET)
    public String getSmsJson(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Sms sms = smsService.getObjectById(id);
            log.info("get sms data is " + sms);

            model.addAttribute("code", 0);

            model.addAttribute("sms", sms);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get sms error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/sms/json/smsDetailJson";
    }

    @RequestMapping(value = "/web/a/sms/{id}", method = RequestMethod.PUT)
    public String updateSmsJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Sms sms) throws Exception {

        log.info("update sms : sms= " + sms);

        try {

            smsService.update(sms);

            model.addAttribute("code", 0);

            model.addAttribute("sms", sms);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update sms error,id is  " + sms.getId());
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }

    @RequestMapping(value = "/web/a/sms", method = RequestMethod.POST)
    public String addSmsJson(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, Sms sms) throws Exception {

        log.info("update sms : sms= " + sms);

        try {
            sms.setId(null);

            smsService.insert(sms);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add sms error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }

    @RequestMapping(value = "/web/a/sms/{id}", method = RequestMethod.DELETE)
    public String deleteSmsJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete sms : id= " + id);
        try {
            smsService.delete(id);

            log.info("add sms success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete sms error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/web/a/multi/sms", method = RequestMethod.GET)
    public String getMultiSmsJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Sms> smsList = smsService.getObjectsByIds(idList);
            log.info("get  sms data is " + smsList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", smsList.size());

            model.addAttribute("smsList", smsList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get sms error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/sms/json/smsListJson";
    }


}

