package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Qa;
import com.ptteng.common.skill.service.QaService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * Qa  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class QaController {
    private static final Log log = LogFactory.getLog(QaController.class);

    @Autowired
    private QaService qaService;


    @RequestMapping(value = "/a/qa", method = RequestMethod.GET)
    public String getQaIdsByOidAndTidJsonList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                              Long oid, Long tid, Integer page, Integer size) throws Exception {
        log.info("getQaIdsByOidAndTidJsonList [oid:" + oid + ",tid:" + tid + ",page:" + page + ",size:" + size + "]");

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }


        try {

            List<Long> ids = qaService.getQaIdsByOidAndTid(oid, tid, start, size);
            log.info("get countQaIdsByOidAndTid size is " + ids.size());

            List<Qa> qaList = qaService.getObjectsByIds(ids);
            log.info("get qa data is " + qaList.size());

            Integer total = qaService.countQaIdsByOidAndTid(oid, tid);
            log.info("get qa count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("qaList", qaList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get qa list error,page is  " + start + " , size " + size);
            // for test
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/qa/json/qaListJson";
    }


    @RequestMapping(value = "/a/qa/{id}", method = RequestMethod.GET)
    public String getQaJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                            @PathVariable Long id) throws Exception {

        log.info("get data : id= " + id);
        try {
            Qa qa = qaService.getObjectById(id);
            log.info("get qa data is " + qa);

            model.addAttribute("code", 0);
            model.addAttribute("qa", qa);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get qa error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/qa/json/qaDetailJson";
    }


    /*

    @RequestMapping(value = "/web/c/qa", method = RequestMethod.GET)
    public String getqaList(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model) throws Exception {


        log.info("/web/qa  to /qa/view/qaList");

        return "/common-skill-service/qa/view/qaList";
    }




    @RequestMapping(value = "/web/c/qa1 ", method = RequestMethod.GET)
    public String getQaIdsByOidAndTidList1(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model, Long oid, Long tid) throws Exception {

        log.info("/web/qa  to /qa/view/qaList");

        return "/common-skill-service/qa/view/qaList";
    }


    @RequestMapping(value = "/web/c/qa/{id}", method = RequestMethod.GET)
    public String getQa(HttpServletRequest request,
                        HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("/web/qa/" + id + "  to /qa/view/qaDeail");
        if (null != id) {
            model.addAttribute("id", id);
        } else {
            model.addAttribute("id", 0);
        }

        return "/common-skill-service/qa/view/qaDetail";
    }


    @RequestMapping(value = "/web/a/qa1 ", method = RequestMethod.GET)
    public String getQaIdsByOidAndTidJsonList(HttpServletRequest request,
                                              HttpServletResponse response, ModelMap model, Integer page,
                                              Integer size, Long oid, Long tid) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            List<Long> ids = qaService.getQaIdsByOidAndTid(oid, tid, start, size);
            log.info("get countQaIdsByOidAndTid size is " + ids.size());

            List<Qa> qaList = qaService.getObjectsByIds(ids);
            log.info("get qa data is " + qaList.size());

            Integer total = qaService.countQaIdsByOidAndTid(oid, tid);
            log.info("get qa count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("qaList", qaList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get qa list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/qa/json/qaListJson";
    }


    @RequestMapping(value = "/web/a/qa/{id}", method = RequestMethod.GET)
    public String getQaJson(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Qa qa = qaService.getObjectById(id);
            log.info("get qa data is " + qa);

            model.addAttribute("code", 0);

            model.addAttribute("qa", qa);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get qa error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/qa/json/qaDetailJson";
    }

    @RequestMapping(value = "/web/a/qa/{id}", method = RequestMethod.PUT)
    public String updateQaJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Qa qa) throws Exception {

        log.info("update qa : qa= " + qa);

        try {

            qaService.update(qa);

            model.addAttribute("code", 0);

            model.addAttribute("qa", qa);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update qa error,id is  " + qa.getId());
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }

    @RequestMapping(value = "/web/a/qa", method = RequestMethod.POST)
    public String addQaJson(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model, Qa qa) throws Exception {

        log.info("update qa : qa= " + qa);

        try {
            qa.setId(null);

            qaService.insert(qa);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add qa error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }

    @RequestMapping(value = "/web/a/qa/{id}", method = RequestMethod.DELETE)
    public String deleteQaJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete qa : id= " + id);
        try {
            qaService.delete(id);

            log.info("add qa success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete qa error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/web/a/multi/qa", method = RequestMethod.GET)
    public String getMultiQaJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Qa> qaList = qaService.getObjectsByIds(idList);
            log.info("get  qa data is " + qaList);

            model.addAttribute("code", 0);
            model.addAttribute("total", qaList.size());

            model.addAttribute("qaList", qaList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get qa error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/qa/json/qaListJson";
    }

    */

}

