package com.ptteng.common.skill.util;

import com.ptteng.common.skill.model.User;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

/**
 * Created by ouyang on 2016/12/16.
 */
public class ComputeUtil {

    private static final Log log = LogFactory.getLog(ComputeUtil.class);

    public static User computeDailyRate(User user) {
        Long startAt = user.getStartAt();
        if (CheckDataUtil.isNull(startAt)) {
            startAt = user.getCreateAt();
        }
        Long duration = getDurationDays(startAt, TimeUnit.DAYS);
        Integer dailyCount = user.getDailyCount();
        String dailyRate = myDivideiCeil(dailyCount, duration);
        user.setDailyRate(dailyRate);
        return user;
    }

    public static Long getDurationDays(Long startAt, TimeUnit unit) {
        Long endAt = System.currentTimeMillis();
        log.info("startAt=" + startAt + "endAt=" + endAt);
        return unit.convert(endAt - startAt, TimeUnit.MILLISECONDS) + 1;
    }

    /**
     * 向上取整
     * @param numerator
     * @param denominator
     * @return Long
     */
    public static Long myDivideiCeil(Long numerator, Integer denominator) {
        BigDecimal b1 = new BigDecimal(numerator),
                b2 = new BigDecimal(denominator);
        BigDecimal b3 = b1.divide(b2, 0, BigDecimal.ROUND_CEILING);
        return b3.longValue();
    }

    public static String myDivideiCeil(Long numerator, Long denominator) {
        BigDecimal b1 = new BigDecimal(numerator),
                b2 = new BigDecimal(denominator);
        BigDecimal b3 = b1.divide(b2, 4, BigDecimal.ROUND_CEILING);
        return b3.toString();
    }

    public static String myDivideiCeil(Integer numerator, Long denominator) {
        BigDecimal b1 = new BigDecimal(numerator),
                b2 = new BigDecimal(denominator);
        BigDecimal b3 = b1.divide(b2, 4, BigDecimal.ROUND_CEILING);
        return b3.toString();
    }
}
