package com.ptteng.common.skill.controller;

import java.math.BigDecimal;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.GetUserFromCookieUtil;
import com.ptteng.skill.service.model.UserTaskRelation;
import com.ptteng.skill.service.service.UserTaskRelationService;
import com.qding.common.util.DataUtils;

import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ptteng.common.skill.util.DynamicUtil;

/**
 * OccupationType crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TaskController {
	private static final Log log = LogFactory.getLog(TaskController.class);

	@Autowired
	private TaskService taskService;
	@Autowired
	private SkillService skillService;

	@Autowired
	private TaskSkillRelationService taskSkillRelationService;

	@Autowired
	private DocumentService documentService;

	@Autowired
	private ArticleService articleService;

	@Autowired
	private UserService userService;
	@Autowired
	private UserTaskRelationService userTaskRelationService;
	@Autowired
	private GetUserFromCookieUtil getUserFromCookieUtil;
	@Autowired
	private ClassesService classesService;
	@Autowired
	private OccupationService occupationService;

	@RequestMapping(value = "/a/task/{id}", method = RequestMethod.GET)
	public String getMultiOccupationTypeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		if (id == null) {

			log.info("task id cannot be null ");

			model.addAttribute("code", -9000);
			return "/common/success";
		} else {

		}
		try {

			List<Skill> skills = new ArrayList();

			Task task = this.taskService.getObjectById(id);
			List<Document> websites = new ArrayList();
			List<Document> videos = new ArrayList();
			if (task == null) {

				log.info(id + " get task is null ");
				model.addAttribute("code", -4008);
				return "/common/success";
			} else {
				Long taskID = task.getId();
				List<Long> skillIDS = this.taskSkillRelationService.getSkillIdsByTid(taskID, 0, Integer.MAX_VALUE);
				if (CollectionUtils.isEmpty(skillIDS)) {
					log.info(taskID + " not get any skill  ids ");
				} else {
					log.info(taskID + " not get  skill  ids size is " + skillIDS.size());
					skills = this.skillService.getObjectsByIds(skillIDS);
					List<DocumentAndSkill> documentAndSkills = DynamicUtil
							.getDocumentIdByMaxLove(new HashSet(skillIDS));
					log.info(" documentAndSkills = " + documentAndSkills.size());
					List<Long> documentIds = new ArrayList<>();
					for (DocumentAndSkill documentAndSkill : documentAndSkills) {
						documentIds.add(documentAndSkill.getId());
					}
					log.info(" documentIds = " + documentIds);
					Map<Long, Document> skillBestDocumentMap = new HashMap<>();
					if (documentIds.size() > 0) {
						List<Document> skillBestDocuments = documentService.getObjectsByIds(documentIds);
						for (Document document : skillBestDocuments) {
							skillBestDocumentMap.put(document.getSid(), document);
						}
					}
					// get document
					Map<String, Object> param = DynamicUtil.getDocumentListParam(new HashSet(skillIDS), false);
					List<Long> documentIDS = this.documentService.getIdsByDynamicCondition(Document.class, param, 0,
							Integer.MAX_VALUE);
					List<Document> documents = new ArrayList();

					if (CollectionUtils.isEmpty(documentIDS)) {
						log.info(taskID + " get document is empty ");
					} else {

						documents = this.documentService.getObjectsByIds(documentIDS);
						log.info(taskID + " get document size is  " + documents.size());

						for (Document document : documents) {
							if (Document.Type_Document == document.getType()) {
								websites.add(document);
							} else {
								videos.add(document);
							}
						}
					}

					model.addAttribute("skillBestDocumentMap", skillBestDocumentMap);

				}

				// get article
				Long startAt = System.currentTimeMillis() - 7 * 24 * 3600 * 1000L;
				Map<String, Object> articleParam = DynamicUtil.getArticleAuthorListParam(null, taskID, null, null,
						startAt, null, false);
				List<Long> comradeIDS = this.articleService.getIdsByDynamicCondition(Article.class, articleParam, 0,
						Integer.MAX_VALUE);
				List<User> comrades = this.userService.getObjectsByIds(comradeIDS);

				/*
				 * 查看用户当前任务的状态* /*1--查看用户是否登录
				 */
				Long uid = getUserFromCookieUtil.getUserFromCookie(request);
				if (null == uid) {
					log.info(" user don't login , so prograss is unreceive ");
				} else {
					log.info(" user login ");
					/* 2-如果登录，查看用户是否已报班 */
					User user = userService.getObjectById(uid);
					if (DataUtils.isNotNullOrEmpty(user)) {
						Long cid = user.getCid();
						if (DataUtils.isNotNullOrEmpty(cid) && cid > 0) {
							Long userTaskId = userTaskRelationService.getUserTaskRelationIdByTidAndUid(id, uid);
							if (DataUtils.isNotNullOrEmpty(userTaskId)) {
								UserTaskRelation userTaskRelation = userTaskRelationService.getObjectById(userTaskId);
								task.setProgress(userTaskRelation.getProgress());
							}
						} else {
							log.info(" user register ,but don't add class,so progress is  unreceive ");
						}
					} else {
						log.info(" user is not exit,so progress is  unreceive  ");
					}
				}

				model.addAttribute("code", 0);
				model.addAttribute("task", task);
				model.addAttribute("skills", skills);
				model.addAttribute("websites", websites);
				model.addAttribute("videos", videos);
				model.addAttribute("comrades", comrades);

			}

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get task error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/task/json/taskDetailJson";
	}

	@RequestMapping(value = "/a/task/search/query", method = RequestMethod.GET)
	public String searchTask(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
			Long oid, Integer page, Integer size ) throws Exception {

		log.info("get data : id= " + id + " oid = " + oid + " page = " + page + " size= " + size);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			List<Task> tasks = new ArrayList();
			List<UserTaskRelation> userTasks = new ArrayList();
			Map<Long,UserTaskRelation> taskID_userTaskRelation=new HashMap();
			Map<String, Object> param = DynamicUtil.getTaskListParam(id, oid, false);

			List<Long> ids = this.taskService.getIdsByDynamicCondition(Task.class, param, start, size + 1);

			if (CollectionUtils.isEmpty(ids)) {

			} else {
				tasks = this.taskService.getObjectsByIds(ids);
				log.info("get data : id= " + id + " oid = " + oid + " get task size is " + tasks.size());
				// 查询用户的所有进度
				/* 1--查看用户是否登录 */
				Long uid = getUserFromCookieUtil.getUserFromCookie(request);
				if (null == uid) {
					log.info(" user don't login , so prograss is unreceive ");
				} else {
					log.info(" user login ");
					/* 2-如果登录，查看用户是否已报班 */
					User user = userService.getObjectById(uid);
					if (DataUtils.isNotNullOrEmpty(user)) {
						Long cid = user.getCid();
						log.info(" user " + uid + " cid = " + cid);
						if (DataUtils.isNotNullOrEmpty(cid) && cid > 0) {
							Classes classes = classesService.getObjectById(cid);
							List<Long> userTaskIds = userTaskRelationService.getUserTaskRelationIdsByUidAndOid(uid,
									classes.getOid(), 0, Integer.MAX_VALUE);
							if (CollectionUtils.isEmpty(userTaskIds)) {
								log.info(" user " + uid + " don't start any task ,so prograss is unreceive ");
							} else {
								log.info(" user " + uid + "  start task ,task size is " + userTaskIds.size());
								userTasks = userTaskRelationService.getObjectsByIds(userTaskIds);
								log.info("user id "+uid + " get userTaskRelation result is " + userTasks.size() );


								taskID_userTaskRelation= MyListUtil.convert2Map(UserTaskRelation.class.getDeclaredField("tid"),userTasks);
								log.info("user id "+uid + " get userTaskRelation convert taskid-relation is " + taskID_userTaskRelation );

							}
						} else {
							log.info(" user register ,but don't add class,so progress is  unreceive ");
						}
					} else {
						log.info(" user is not exit,so progress is  unreceive  ");
					}
				}

			}
			model.addAttribute("code", 0);
			model.addAttribute("tasks", tasks);
			model.addAttribute("taskID_userTaskRelation", taskID_userTaskRelation);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.info("get data : id= " + id + " oid = " + oid + " get task error ");
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/task/json/taskListJson";
	}

	/**
	 * 给前端提供的假数据接口
	 * 
	 */
	/*
	 * @RequestMapping(value = "/a/u/task/{oid}/statistics", method =
	 * RequestMethod.GET) public String taskStatisticDetail(HttpServletRequest
	 * request, HttpServletResponse response,ModelMap model) throws Exception {
	 * 
	 * model.addAttribute("code", 0);
	 * 
	 * return"/common-skill-service/task/json/taskProgress";
	 * 
	 * }
	 */
	/**
	 * 提供给前端 用户任务统计详情 假接口
	 */

	/*
	 * @RequestMapping(value = "/a/u/task/{oid}/statis/user/{uid}", method =
	 * RequestMethod.GET) public String userTaskRelationJson(HttpServletRequest
	 * request, HttpServletResponse response, ModelMap model) throws Exception {
	 * 
	 * log.info("here"); model.addAttribute("code", 0); return
	 * "/common-skill-service/task/json/userTaskDetail";
	 * 
	 * }
	 */

	/**
	 * 任务统计详情
	 * 
	 */
	@RequestMapping(value = "/a/task/{oid}/statistics", method = RequestMethod.GET)
	public String taskStatisticDetailJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long oid) throws Exception {
		log.info("occupation id :" + oid);
		// 参数验证id是否为空
		if (DataUtils.isNullOrEmpty(oid) || oid < 0) {
			log.info("occupation id is null or illegal");
			model.addAttribute("code", -20002);
			return "/data/json";
		}

		try {
			// 根据职业id得到职业对象
			Occupation occupation = occupationService.getObjectById(oid);
			if (DataUtils.isNotNullOrEmpty(occupation)) {
				log.info("occupation oid:" + occupation.getId());
				model.addAttribute("occupation", occupation);
				// 根据职业id得到职业下的所有任务
				List<Long> taskIds = taskService.getTaskIdsByOid(oid, 0, Integer.MAX_VALUE);
				if (CollectionUtils.isEmpty(taskIds)) {
					log.info("taskIds  is   empty");
					model.addAttribute("code", -20001);
					return "/data/json";
				} else {
					log.info("taskIds:" + taskIds.size());
					List<Task> taskList = taskService.getObjectsByIds(taskIds);
					if (CollectionUtils.isEmpty(taskList)) {
						log.info("taskList is null");
						model.addAttribute("code", -20001);
						return "/data/json";
					} else {
						log.info("taskList  count  is:" + taskList.size());
						model.addAttribute("taskList", taskList);
					}
				}
			} else {
				log.info(" occupation  is null   id: " + oid);
				model.addAttribute("code", -20002);
				return "/data/json";
			}
		} catch (Throwable t) {
			log.error(t.getMessage(),t);
			model.addAttribute("code", -1);
		}
		model.addAttribute("code", 0);
		return "/common-skill-service/task/json/taskProgress";
	}


	
	
	/**
	 * 用户任务统计详情
	 */
	@RequestMapping(value = "/a/user/{uid}/task/{oid}/statistics", method = RequestMethod.GET)
	public String userTaskStatisticDetailJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long oid, @PathVariable Long uid) throws Exception {
		log.info("data is oid:" + oid + " uid:" + uid);
		//验证uid和oid不能为空
		if(DataUtils.isNullOrEmpty(oid) || DataUtils.isNullOrEmpty(uid)){
			log.info("oid  or uid  is null");
			model.addAttribute("code", -20003);
			return "/data/json";
		}
		ArrayList<UserTaskRelation> userTaskRelationList = new ArrayList<UserTaskRelation>();
		try {
			//如果在该职业下有任务，取出该职业下所有的任务的ids
	        List<Long> taskIds = taskService.getTaskIdsByOid(oid, 0, Integer.MAX_VALUE);
	        log.info("taskIds is " + taskIds);
			if(CollectionUtils.isEmpty(taskIds)){
				log.info("occupation  has  no  task");
				model.addAttribute("code", -20001);
				return "/data/json";
			}
			//初始化总的上、中、下品数量
			int allTopArticleCount = 0;
			int allMiddleArticleCount = 0;
			int allLowerArticleCount = 0;
			int allTaskAverageScore = 0;
			//得到每一个任务的日报上、中、下的数量和
			for(int i=0; i<taskIds.size(); i++){
				Long taskId = taskIds.get(i);
				//动态查询一个用户在一个任务下的日报id
				Map<String, Object> params = DynamicUtil.getArticleIdsByUidAndTid(uid, taskId);
				List<Long> articleIds = articleService.getIdsByDynamicCondition(Article.class, params, 0, Integer.MAX_VALUE);
				log.info("articleIds is " + articleIds);
				//查询一个用户在一个任务下的用户任务关系表id
				Long userTaskRelationId = userTaskRelationService.getUserTaskRelationIdByTidAndUid(taskId, uid);
				UserTaskRelation userTask = new UserTaskRelation();
				if(DataUtils.isNotNullOrEmpty(userTaskRelationId)){
					userTask = userTaskRelationService.getObjectById(userTaskRelationId);
					if(DataUtils.isNotNullOrEmpty(userTask)){
						//初始化每个等级的数量
						int topArticleCount = 0;
						int middleArticleCount = 0;
						int lowerArticleCount = 0;
						if(CollectionUtils.isEmpty(articleIds)){
							//日报id为空，什么也不执行，所有日报的等级数量都为0
							log.info("task  has  no  article");
						}else{
							List<Article> articleList = articleService.getObjectsByIds(articleIds);
							if(CollectionUtils.isEmpty(articleList)){
								log.info("articleList  is    null");
							}else{
								for(int j=0; j< articleList.size(); j++){
									log.info("articleList is " + articleList.size());
									if (null == articleList.get(j).getEvaluation()){
										log.info("evaluation  is null");
									}else if(articleList.get(j).getEvaluation() == 2){
										log.info("evaluation  is 2");
										middleArticleCount++;
									}else if(articleList.get(j).getEvaluation() == 1){
										log.info("evaluation  is 1");
										lowerArticleCount++;
									}else if(articleList.get(j).getEvaluation() == 3){
										log.info("evaluation  is 3");
										topArticleCount++;
									}else{
										log.info(" i  dont know");
									}
								}
							}
						}
						userTask.setTopArticleCount(topArticleCount);
						userTask.setMiddleArticleCount(middleArticleCount);
						userTask.setLowerArticleCount(lowerArticleCount);
						log.info("set  article count is success");
						//可以将分数值设为常量
						Integer allCount = topArticleCount + middleArticleCount + lowerArticleCount;
						Integer allScore = topArticleCount*UserArticleRelation.TOP_ARTICLE_SCORE
								             +middleArticleCount*UserArticleRelation.MIDDLE_ARTICLE_SCORE
								             +lowerArticleCount*UserArticleRelation.LOWER_ARTICLE_SCORE;
						log.info("allCount is " + allCount + " allScore" + allScore);
						double score = (double)allScore / (allCount*9)*100;
						Long lscore = Math.round(score);
						Integer selfTaskScore = lscore.intValue();
						log.info("selfTaskScore is " + selfTaskScore);
						userTask.setSelfTaskScore(selfTaskScore);
						userTaskRelationList.add(userTask);
						//用户所有的任务的上品日报数量、中品、下品
						allTopArticleCount += topArticleCount;
					    allMiddleArticleCount += middleArticleCount;
						allLowerArticleCount += lowerArticleCount;
					}else{
						log.info("userTask is null");
					}
				}else{
					log.info("userTaskRelationId is  null");
				}
			}
			//用户所有任务的平均分
			Integer score = allTopArticleCount*UserArticleRelation.TOP_ARTICLE_SCORE + allMiddleArticleCount*
					UserArticleRelation.MIDDLE_ARTICLE_SCORE+allLowerArticleCount*UserArticleRelation.LOWER_ARTICLE_SCORE;
			double d = (double) score / ((allTopArticleCount + allMiddleArticleCount + allLowerArticleCount)*
							UserArticleRelation.TOP_ARTICLE_SCORE );
			Long l = Math.round(d*100);
		    allTaskAverageScore = l.intValue();
		    
		    model.addAttribute("allTopArticleCount", allTopArticleCount);
		    model.addAttribute("allMiddleArticleCount", allMiddleArticleCount);
		    model.addAttribute("allLowerArticleCount", allLowerArticleCount);
		    model.addAttribute("allTaskAverageScore", allTaskAverageScore);
		} catch (Throwable t) {
			log.error(t.getMessage(),t);
			model.addAttribute("code", -1);
			return "/data/json";
		}
		model.addAttribute("userTaskRelationList", userTaskRelationList);
		model.addAttribute("code", 0);
		return "/common-skill-service/task/json/userTaskDetail";
	}
}
