/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.common.skill.model.Asset;
import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.UserInfo;
import com.qding.common.util.DataUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UserUtil {
    public static final int InviteStatistics_groupByMonth = 1;

    public static boolean isTeacher(int identity) {
        boolean result = false;
        switch (identity) {
            case 40: {
                result = true;
                break;
            }
            case 50: {
                result = true;
                break;
            }
            case 60: {
                result = true;
                break;
            }
            case 70: {
                result = true;
                break;
            }
            case 80: {
                result = true;
                break;
            }
        }
        return result;
    }

    public static int convertIdentity2Event(int identity) {
        int eventType = -1;
        switch (identity) {
            case 30: {
                eventType = 6;
                break;
            }
            case 40: {
                eventType = 5;
                break;
            }
            case 90: {
                eventType = 9;
                break;
            }
            case 95: {
                eventType = 10;
                break;
            }
            case 100: {
                eventType = 15;
                break;
            }
            case 55: {
                eventType = 11;
                break;
            }
            case 60: {
                eventType = 18;
                break;
            }
            case 70: {
                eventType = 19;
                break;
            }
            case 80: {
                eventType = 20;
                break;
            }
        }
        return eventType;
    }

    public static String convertName(User user, BranchInstitute brach, Occupation occupation) {
        int identity = user.getIdentity();
        StringBuffer sb = new StringBuffer();
        sb = sb.append("[");
        if (brach != null && identity != 100 && identity != 60) {
            sb = sb.append(brach.getName());
            sb = sb.append("|");
        }
        StringBuffer id_sb = new StringBuffer();
        StringBuffer id_nick = new StringBuffer();
        switch (identity) {
            case 10: {
                id_sb = id_sb.append("\u65e0\u540d\u5f1f\u5b50");
                id_nick = id_nick.append(user.getNick());
                break;
            }
            case 100: {
                id_sb = id_sb.append("\u65e0\u540d\u5f1f\u5b50");
                id_nick = id_nick.append(user.getNick());
                break;
            }
            case 20: {
                id_sb = id_sb.append("\u6563\u4fee\u5f1f\u5b50");
                id_nick = id_nick.append(user.getStudyNumber());
                break;
            }
            case 30: {
                id_sb = id_sb.append("\u5916\u95e8\u5f1f\u5b50");
                id_nick = id_nick.append(user.getStudyNumber());
                break;
            }
            case 40: {
                id_sb = id_sb.append("\u5185\u95e8\u5f1f\u5b50");
                id_nick = id_nick.append(user.getNick());
                break;
            }
            case 50: {
                id_sb = id_sb.append("\u9996\u5e2d\u5f1f\u5b50");
                id_nick = id_nick.append(user.getNick());
                break;
            }
            case 90: {
                id_sb = id_sb.append("\u7ed3\u4e1a\u5f1f\u5b50");
                id_nick = id_nick.append(user.getNick());
                break;
            }
            case 55: {
                id_sb = id_sb.append("\u8363\u8000\u5e08\u5144");
                id_nick = id_nick.append(user.getNick());
                break;
            }
            case 60: {
                id_sb = id_sb.append("\u771f\u4f20\u5f1f\u5b50");
                id_nick = id_nick.append(user.getNick());
                break;
            }
            case 70: {
                id_sb = id_sb.append("\u4fee\u771f\u957f\u8001");
                id_nick = id_nick.append(user.getNick());
                break;
            }
            case 80: {
                id_sb = id_sb.append("\u5ba2\u537f\u957f\u8001");
                id_nick = id_nick.append(user.getNick());
                break;
            }
        }
        sb = sb.append(id_sb);
        sb = sb.append("]");
        if (occupation != null) {
            sb = sb.append(occupation.getName());
            sb = sb.append("-");
        }
        sb = sb.append(id_nick);
        return sb.toString();
    }

    public static boolean isOffline(int identity) {
        boolean result = false;
        switch (identity) {
            case 40: {
                result = true;
                break;
            }
            case 50: {
                result = true;
                break;
            }
            case 90: {
                result = true;
                break;
            }
            case 55: {
                result = true;
                break;
            }
            case 60: {
                result = true;
                break;
            }
        }
        return result;
    }

    public static int convertHeadStatus2Event(int status) {
        int eventType = -1;
        switch (status) {
            case 1: {
                eventType = 14;
                break;
            }
            case 2: {
                eventType = 12;
                break;
            }
        }
        return eventType;
    }

    public static int convertReviewStatus2Event(int status) {
        int eventType = -1;
        switch (status) {
            case 1: {
                eventType = 13;
                break;
            }
        }
        return eventType;
    }

    public static int convertLearnPhaseStatus2Event(int phase) {
        int eventType = -1;
        switch (phase) {
            case 3: {
                eventType = 8;
                break;
            }
            case 2: {
                eventType = 7;
                break;
            }
            case 1: {
                break;
            }
        }
        return eventType;
    }

    public static Map<String, Object> getSalaryStatistics(Long oid, Integer branch, Integer identity, List<Integer> identityList, Long graduatedStartAt, Long graduatedEndAt, Long schoolId, Integer typicalStatus, boolean salaryStatic, List<Integer> salaryList, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("user user");
        if (DataUtils.isNotNullOrEmpty((Object)oid)) {
            params.put("user.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)branch)) {
            params.put("user.branch", branch);
        }
        if (DataUtils.isNotNullOrEmpty((Object)identity)) {
            params.put("user.identity", identity);
        }
        if (CollectionUtils.isNotEmpty(identityList)) {
            params.put("user.identity & in ", "(" + StringUtils.join(identityList, (String)",") + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)graduatedStartAt)) {
            params.put("user.graduate_at & >= ", graduatedStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)graduatedEndAt)) {
            params.put("user.graduate_at & <= ", graduatedEndAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)schoolId)) {
            params.put("user.school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)typicalStatus)) {
            params.put("user.typical_status", typicalStatus);
        }
        if (count) {
            params.put("@query", " count( user.id) ");
        } else if (salaryStatic) {
            if (CollectionUtils.isEmpty(salaryList)) {
                Integer[] salarys = new Integer[]{0, 6, 8, 10, 12, 15};
                salaryList = Arrays.asList(salarys);
            }
            Collections.sort(salaryList);
            params.put("user.salary & ", "is not null");
            params.put("@query", "elt(interval (user.salary," + StringUtils.join(salaryList, (String)",") + ")," + StringUtils.join(salaryList, (String)",") + "),count(user.id)");
            params.put("@group", "elt(interval (user.salary," + StringUtils.join(salaryList, (String)",") + ")," + StringUtils.join(salaryList, (String)",") + ")");
        } else {
            params.put("@query", " user.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static List<Integer> getComUserIdentities() {
        Integer[] comIds = new Integer[]{55, 60, 70, 90, 95};
        return Arrays.asList(comIds);
    }

    public static List<Integer> getStudyingUserIdentities() {
        Integer[] stuIds = new Integer[]{40, 50};
        return Arrays.asList(stuIds);
    }

    public static UserInfo getInitUserInfo(long id) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(id);
        userInfo.setIeventId(0L);
        userInfo.setTuition(new BigDecimal("0"));
        userInfo.setRuleId(0L);
        userInfo.setPayType(UserInfo.PAY_TYPE_DEFAULT);
        userInfo.setStageStatus(UserInfo.STAGE_STATUS_NOT_OFF);
        userInfo.setOffAt(0L);
        userInfo.setInviteMoney(new BigDecimal("0"));
        userInfo.setIvMsgCount(0);
        userInfo.setCreateBy(id);
        userInfo.setUpdateBy(id);
        userInfo.setCreateAt(System.currentTimeMillis());
        userInfo.setUpdateAt(System.currentTimeMillis());
        return userInfo;
    }

    public static Asset getInitAsset(long id) {
        Asset asset = new Asset();
        asset.setId(id);
        asset.setAsset(new BigDecimal("0"));
        asset.setWithdraw(new BigDecimal("0"));
        asset.setWithdrawApply(new BigDecimal("0"));
        asset.setPreSettle(new BigDecimal("0"));
        asset.setSettle(new BigDecimal("0"));
        asset.setTotalInvite(new BigDecimal("0"));
        asset.setVersion(0);
        asset.setCreateBy(id);
        asset.setUpdateBy(id);
        asset.setUpdateAt(System.currentTimeMillis());
        asset.setCreateAt(System.currentTimeMillis());
        return asset;
    }

    public static Map<String, Object> getInviteStatistics(Long recommendId, Long inviteTimeStart, Long inviteTimeEnd, int groupBy) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("user user");
        tables.add("user_info user_info");
        params.put("user_info.id", "user.id");
        if (DataUtils.isNotNullOrEmpty((Object)recommendId)) {
            params.put("user.recommend_id", recommendId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)inviteTimeStart)) {
            params.put("user.create_at & >=", inviteTimeStart);
        }
        if (DataUtils.isNotNullOrEmpty((Object)inviteTimeEnd)) {
            params.put("user.create_at & <=", inviteTimeEnd);
        }
        String groupStr = "";
        switch (groupBy) {
            case 1: {
                groupStr = "from_unixtime(user.create_at/1000,'%Y-%m')";
                break;
            }
            default: {
                groupStr = "from_unixtime(user.create_at/1000,'%Y-%m')";
            }
        }
        params.put("@group", groupStr);
        params.put("@query", groupStr + ",count(1),sum(user_info.invite_money)");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> updateIsLook(long receiveId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashSet tables = new HashSet();
        param.put("id", receiveId);
        param.put("@field", "user.is_look");
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(" select count(1) from message message where message.unread =").append(Message.Status_Unread).append("  and message.receive_id = user.id").append("  and message.type != ").append("'").append("collection").append("'").append("  and message.type != ").append("'").append("like").append("'").append("  and message.type != ").append("'").append("private").append("'").append("  and message.type != ").append("'").append("trade").append("'").append(")");
        param.put("@value", sb.toString());
        param.put("@update", "user user");
        param.put("@table", "user user");
        return param;
    }

    public static Map<String, Object> updateIvMsgCount(long receiveId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashSet tables = new HashSet();
        param.put("id", receiveId);
        param.put("@field", "user_info.iv_msg_count");
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(" select count(1) from message message where message.unread =").append(Message.Status_Unread).append("  and message.receive_id = user_info.id").append("  and message.type = ").append("'").append("trade").append("'").append("  and message.type = ").append("'").append("envoy").append("'").append(")");
        param.put("@value", sb.toString());
        param.put("@update", "user_info user_info");
        param.put("@table", "user_info user_info");
        return param;
    }

    public static void main(String[] args) {
        Map<String, Object> map = UserUtil.updateIvMsgCount(25397L);
        String sql = SQLUtil.convert2Sql(map, (Integer)0, (Integer)Integer.MAX_VALUE);
        System.out.println("sql = " + sql);
    }
}

