package com.ptteng.common.skill.util;

import com.ptteng.common.skill.DTO.MsgConObj;
import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.User;
import com.qding.common.util.DataUtils;
import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: liu k
 * @create: 2019-11-02 11:11
 **/
public class MsgUtil {

  public static List<MsgConObj> getMsgContent(User user, Occupation occupation) {
    List<MsgConObj> conObjList = new ArrayList<>();
    if (DataUtils.isNotNullOrEmpty(user)) {
      conObjList.addAll(getMsgContent(user));
    }
    if (DataUtils.isNotNullOrEmpty(occupation)) {
      conObjList.addAll(getMsgContent(occupation));

    }
    return conObjList;
  }

  public static List<MsgConObj> getMsgContent(User user, Occupation occupation,
      BranchInstitute branchInstitute) {
    List<MsgConObj> conObjList = new ArrayList<>();
    if (DataUtils.isNotNullOrEmpty(user)) {
      conObjList.addAll(getMsgContent(user));
    }
    if (DataUtils.isNotNullOrEmpty(occupation)) {
      conObjList.addAll(getMsgContent(occupation));
    }
    if (DataUtils.isNotNullOrEmpty(branchInstitute)) {
      conObjList.addAll(getMsgContent(branchInstitute));
    }
    return conObjList;
  }


  public static List<MsgConObj> getMsgContent(User user) {
    List<MsgConObj> conObjList = new ArrayList<>();
    if (DataUtils.isNotNullOrEmpty(user)) {
      MsgConObj con1 = new MsgConObj();
      con1.setType(MsgConObj.TYPE_UID);
      con1.setValue(user.getId().toString());
      con1.setHref(MsgConObj.HREF_UID);
      conObjList.add(con1);

      MsgConObj con2 = new MsgConObj();
      con2.setType(MsgConObj.TYPE_UNAME);
      con2.setValue(user.getNick());
      con2.setHref(MsgConObj.HREF_DEFAUTL);
      conObjList.add(con2);
      if(DataUtils.isNotNullOrEmpty(user.getMobile())){
        StringBuilder sbuf = new StringBuilder(user.getMobile());
        String mobile = sbuf.replace(3, 7, "****").toString();
        conObjList.add(new MsgConObj(MsgConObj.TYPE_MOBILE, mobile,
            MsgConObj.HREF_DEFAUTL));
      }
    }
    return conObjList;
  }

  public static List<MsgConObj> getMsgContent(Occupation occupation) {
    List<MsgConObj> conObjList = new ArrayList<>();
    if (DataUtils.isNotNullOrEmpty(occupation)) {
      MsgConObj con1 = new MsgConObj();
      con1.setType(MsgConObj.TYPE_OID);
      con1.setValue(occupation.getId().toString());
      con1.setHref(MsgConObj.HREF_OID);
      conObjList.add(con1);

      MsgConObj con2 = new MsgConObj();
      con2.setType(MsgConObj.TYPE_ONAME);
      con2.setValue(occupation.getName());
      con2.setHref(MsgConObj.HREF_DEFAUTL);
      conObjList.add(con2);
    }
    return conObjList;
  }

  public static List<MsgConObj> getMsgContent(BranchInstitute institute) {
    List<MsgConObj> conObjList = new ArrayList<>();
    if (DataUtils.isNotNullOrEmpty(institute)) {
      MsgConObj con1 = new MsgConObj();
      con1.setType(MsgConObj.TYPE_BID);
      con1.setValue(institute.getId().toString());
      con1.setHref(MsgConObj.HREF_BID);
      conObjList.add(con1);

      MsgConObj con2 = new MsgConObj();
      con2.setType(MsgConObj.TYPE_BNAME);
      con2.setValue(institute.getName());
      con2.setHref(MsgConObj.HREF_DEFAUTL);
      conObjList.add(con2);
    }
    return conObjList;
  }
}
