package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "timetable")
public class Timetable implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = 5156862935832500224L;


  /**
   * 主键,自增长id
   */
  private Long id;


  /**
   * 课时_id
   */
  private Long lessonId;


  /**
   * 班级_id
   */
  private Long classesId;


  /**
   * 上课时间
   */
  private Long startAt;


  /**
   * 下课时间
   */
  private Long endAt;


  /**
   * 创建时间
   */
  private Long createAt;


  /**
   * 创建者
   */
  private Long createBy;


  /**
   * 更新时间
   */
  private Long updateAt;


  /**
   * 更新者
   */
  private Long updateBy;


  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }


  public Timetable setId(Long id) {
    this.id = id;
    return this;
  }

  @Column(name = "lesson_id")
  public Long getLessonId() {
    return lessonId;
  }


  public Timetable setLessonId(Long lessonId) {
    this.lessonId = lessonId;
    return this;
  }

  @Column(name = "classes_id")
  public Long getClassesId() {
    return classesId;
  }


  public Timetable setClassesId(Long classesId) {
    this.classesId = classesId;
    return this;
  }

  @Column(name = "start_at")
  public Long getStartAt() {
    return startAt;
  }


  public Timetable setStartAt(Long startAt) {
    this.startAt = startAt;
    return this;
  }

  @Column(name = "end_at")
  public Long getEndAt() {
    return endAt;
  }


  public Timetable setEndAt(Long endAt) {
    this.endAt = endAt;
    return this;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public Timetable setCreateAt(Long createAt) {
    this.createAt = createAt;
    return this;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public Timetable setCreateBy(Long createBy) {
    this.createBy = createBy;
    return this;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public Timetable setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
    return this;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }


  public Timetable setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
    return this;
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }

}

