/**
 * 
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.skill.model.Successor;
import com.ptteng.common.skill.service.SuccessorService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class SuccessorSCAClient implements SuccessorService {

    private SuccessorService successorService;

	public SuccessorService getSuccessorService() {
		return successorService;
	}
	
	
	public void setSuccessorService(SuccessorService successorService) {
		this.successorService =successorService;
	}
	
	
			   
		@Override
		public Long insert(Successor successor)throws ServiceException, ServiceDaoException{
		
		return successorService.insert(successor);
		          
		
		}	
		  
    	   
		@Override
		public List<Successor> insertList(List<Successor> successorList)throws ServiceException, ServiceDaoException{
		
		return successorService.insertList(successorList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return successorService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Successor successor)throws ServiceException, ServiceDaoException{
		
		return successorService.update(successor);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Successor> successorList)throws ServiceException, ServiceDaoException{
		
		return successorService.updateList(successorList);
		          
		
		}	
		  
    	   
		@Override
		public Successor getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return successorService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Successor> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return successorService.getObjectsByIds(ids);
		          
		
		}	
		  

			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUidsByOidAndBranchId(Long oid,Long branchId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return successorService.getUidsByOidAndBranchId(oid,branchId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSuccessorIdsByBranchId(Long branchId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return successorService.getSuccessorIdsByBranchId(branchId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSuccessorIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return successorService.getSuccessorIdsByUid(uid,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOidsByBranchId(Long branchId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return successorService.getOidsByBranchId(branchId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUidsByOid(Long oid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return successorService.getUidsByOid(oid,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUidsByBranchId(Long branchId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return successorService.getUidsByBranchId(branchId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getSuccessorIdByBranchIdAndUidAndOid(Long branchId,Long uid,Long oid)throws ServiceException, ServiceDaoException{
		
		return successorService.getSuccessorIdByBranchIdAndUidAndOid(branchId,uid,oid);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUidsByOidAndBranchId(Long oid,Long branchId)throws ServiceException, ServiceDaoException{
		
		return successorService.countUidsByOidAndBranchId(oid,branchId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSuccessorIdsByBranchId(Long branchId)throws ServiceException, ServiceDaoException{
		
		return successorService.countSuccessorIdsByBranchId(branchId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSuccessorIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		return successorService.countSuccessorIdsByUid(uid);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countOidsByBranchId(Long branchId)throws ServiceException, ServiceDaoException{
		
		return successorService.countOidsByBranchId(branchId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUidsByOid(Long oid)throws ServiceException, ServiceDaoException{
		
		return successorService.countUidsByOid(oid);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUidsByBranchId(Long branchId)throws ServiceException, ServiceDaoException{
		
		return successorService.countUidsByBranchId(branchId);
	
	
	}
	
		
	
		@Override
	public List<Long> getSuccessorIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return successorService.getSuccessorIds(start, limit);
	}

	@Override
	public Integer countSuccessorIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return successorService.countSuccessorIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return successorService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return successorService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   successorService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.successorService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

