/**
 * 
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.skill.model.Skill;
import com.ptteng.common.skill.service.SkillService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class SkillSCAClient implements SkillService {

    private SkillService skillService;

	public SkillService getSkillService() {
		return skillService;
	}
	
	
	public void setSkillService(SkillService skillService) {
		this.skillService =skillService;
	}
	
	
			   
		@Override
		public Long insert(Skill skill)throws ServiceException, ServiceDaoException{
		
		return skillService.insert(skill);
		          
		
		}	
		  
    	   
		@Override
		public List<Skill> insertList(List<Skill> skillList)throws ServiceException, ServiceDaoException{
		
		return skillService.insertList(skillList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return skillService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Skill skill)throws ServiceException, ServiceDaoException{
		
		return skillService.update(skill);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Skill> skillList)throws ServiceException, ServiceDaoException{
		
		return skillService.updateList(skillList);
		          
		
		}	
		  
    	   
		@Override
		public Skill getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return skillService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Skill> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return skillService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSkillIdsByOid(Long oid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return skillService.getSkillIdsByOid(oid,start,limit);
	
	
	}

	@Override
	public List<Long> getIdsByParentId(Long parentId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return skillService.getIdsByParentId(parentId,start,limit);
	}

	@Override
	public List<Long> getIdsByOccupationId(Long occupationId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return skillService.getIdsByOccupationId(occupationId,start,limit);
	}

	@Override
	public Integer countIdsByOccupationId(Long occupationId) throws ServiceException, ServiceDaoException {
		return skillService.countIdsByOccupationId(occupationId);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSkillIdsByOid(Long oid)throws ServiceException, ServiceDaoException{
		
		return skillService.countSkillIdsByOid(oid);
	
	
	}

	/**
	 * @param tid
	 * @param start
	 * @param limit @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long> getSkillIdsByTid(Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return skillService.getSkillIdsByTid(tid,start,limit);
	}


	@Override
	public List<Long> getSkillIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return skillService.getSkillIds(start, limit);
	}

	@Override
	public Integer countSkillIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return skillService.countSkillIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return skillService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}

	@Override
	public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
		return skillService.getObjectByDynamicCondition(aClass, map, integer, integer1);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return skillService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   skillService.deleteList(clz, ids);
		
	}





 
}

