/**
 *
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.skill.model.Classes;
import com.ptteng.common.skill.service.ClassesService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ClassesSCAClient implements ClassesService {

    private ClassesService classesService;

    public ClassesService getClassesService() {
        return classesService;
    }


    public void setClassesService(ClassesService classesService) {
        this.classesService = classesService;
    }


    @Override
    public Long insert(Classes classes) throws ServiceException, ServiceDaoException {

        return classesService.insert(classes);


    }


    @Override
    public List<Classes> insertList(List<Classes> classesList) throws ServiceException, ServiceDaoException {

        return classesService.insertList(classesList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return classesService.delete(id);


    }


    @Override
    public boolean update(Classes classes) throws ServiceException, ServiceDaoException {

        return classesService.update(classes);


    }


    @Override
    public boolean updateList(List<Classes> classesList) throws ServiceException, ServiceDaoException {

        return classesService.updateList(classesList);


    }


    @Override
    public Classes getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return classesService.getObjectById(id);


    }


    @Override
    public List<Classes> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return classesService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getClassesIdsByOidAndGrade(Long oid, Long grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return classesService.getClassesIdsByOidAndGrade(oid, grade, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getClassesIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return classesService.getClassesIdsByName(name, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getClassesIdsByOid(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return classesService.getClassesIdsByOid(oid, start, limit);

    }

    @Override
    public List<Long> getClassesIdsByType(String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return classesService.getClassesIdsByType(type, start, limit);
    }

    @Override
    public List<Long> getClassesIdsByOidAndName(Long oid, String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return classesService.getClassesIdsByOidAndName(oid, name, start, limit);
    }

    @Override
    public List<Long> getClassesIdsByOidAndNameAndType(Long oid, String name, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return classesService.getClassesIdsByOidAndNameAndType(oid, name, type, start, limit);
    }

    @Override
    public List<Long> getClassesIdsByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return classesService.getClassesIdsByOidAndType(oid, type, start, limit);
    }

    @Override
    public List<Long> getClassesIdsByTypeAndName(String type, String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return classesService.getClassesIdsByTypeAndName(type, name, start, limit);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countClassesIdsByOidAndGrade(Long oid, Long grade) throws ServiceException, ServiceDaoException {

        return classesService.countClassesIdsByOidAndGrade(oid, grade);


    }

    @Override
    public List<Long> getClassesIdsbyOccupation(Long oid, Long start, Long limit) throws ServiceException, ServiceDaoException {

        return classesService.getClassesIdsbyOccupation(oid, start, limit);


    }

    @Override
    public List<Long> getClassesIdsbyOccupationAndType(Long oid, String type, Long start, Long limit, Integer classesStart, Integer classesSize) throws ServiceException, ServiceDaoException {
        return classesService.getClassesIdsbyOccupationAndType(oid, type, start, limit, classesStart, classesSize);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countClassesIdsByOid(Long oid) throws ServiceException, ServiceDaoException {

        return classesService.countClassesIdsByOid(oid);


    }

    @Override
    public Integer countClassesIdsByType(String type) throws ServiceException, ServiceDaoException {
        return classesService.countClassesIdsByType(type);
    }


    @Override
    public List<Long> getClassesIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return classesService.getClassesIds(start, limit);
    }

    @Override
    public Integer countClassesIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return classesService.countClassesIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return classesService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return classesService.getObjectByDynamicCondition(aClass, map, integer, integer1);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return classesService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        classesService.deleteList(clz, ids);

    }

    public List<Long> getLastClassesIdByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return classesService.getLastClassesIdByOidAndType(oid, type, start, limit);
    }
}

