/**
 * 
 */
package com.ptteng.sca.common.skill.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Cities;
import com.ptteng.common.skill.service.CitiesService;

import java.util.List;
import java.util.Map;

public class CitiesSCAClient implements CitiesService {

    private CitiesService citiesService;

	public CitiesService getCitiesService() {
		return citiesService;
	}
	
	
	public void setCitiesService(CitiesService citiesService) {
		this.citiesService =citiesService;
	}
	
	
			   
		@Override
		public Long insert(Cities cities)throws ServiceException, ServiceDaoException{
		
		return citiesService.insert(cities);
		          
		
		}	
		  
    	   
		@Override
		public List<Cities> insertList(List<Cities> citiesList)throws ServiceException, ServiceDaoException{
		
		return citiesService.insertList(citiesList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return citiesService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Cities cities)throws ServiceException, ServiceDaoException{
		
		return citiesService.update(cities);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Cities> citiesList)throws ServiceException, ServiceDaoException{
		
		return citiesService.updateList(citiesList);
		          
		
		}	
		  
    	   
		@Override
		public Cities getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return citiesService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Cities> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return citiesService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getCitiesIdByCity(String city)throws ServiceException, ServiceDaoException{
		
		return citiesService.getCitiesIdByCity(city);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCitiesIdsByProvinceIdOrderByCreateAt(Long provinceId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return citiesService.getCitiesIdsByProvinceIdOrderByCreateAt(provinceId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCitiesIdsByProvinceIdOrderByCreateAt(Long provinceId)throws ServiceException, ServiceDaoException{
		
		return citiesService.countCitiesIdsByProvinceIdOrderByCreateAt(provinceId);
	
	
	}
	
		
	
		@Override
	public List<Long> getCitiesIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return citiesService.getCitiesIds(start, limit);
	}

	@Override
	public Integer countCitiesIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return citiesService.countCitiesIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return citiesService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return citiesService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   citiesService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.citiesService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

