package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Qa;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface QaService extends BaseDaoService {


    public Long insert(Qa qa) throws ServiceException, ServiceDaoException;


    public List<Qa> insertList(List<Qa> qaList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Qa qa) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Qa> qaList) throws ServiceException, ServiceDaoException;


    public Qa getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Qa> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countQaIdsByOidAndTid(Long oid, Long tid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getQaIdsByOidAndTid(Long oid, Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getQaIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countQaIds() throws ServiceException, ServiceDaoException;


}

