package com.ptteng.common.skill.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.common.skill.model.Leaves;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface LeavesService extends BaseDaoService {


	public Long insert(Leaves leaves)throws ServiceException, ServiceDaoException;



	public List<Leaves> insertList(List<Leaves> leavesList)throws ServiceException, ServiceDaoException;



	public boolean delete(Long id)throws ServiceException, ServiceDaoException;



	public boolean update(Leaves leaves)throws ServiceException, ServiceDaoException;



	public boolean updateList(List<Leaves> leavesList)throws ServiceException, ServiceDaoException;



	public Leaves getObjectById(Long id)throws ServiceException, ServiceDaoException;



	public List<Leaves> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countLeavesIdsByUidOrderByStartAt(Long uid)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getLeavesIdsByUidOrderByStartAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getLeavesIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countLeavesIds() throws ServiceException, ServiceDaoException;


}

