package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Iteration;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface IterationService extends BaseDaoService {

	



   		   
		
		public Long insert(Iteration iteration)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Iteration> insertList(List<Iteration> iterationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Iteration iteration)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Iteration> iterationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Iteration getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Iteration> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIterationIdsByProductIdAndStatusOrderBySort(Long productId, Integer status)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIterationIdsByNameOrderBySort(String name)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIterationIdsByProductIdAndStatusOrderBySort(Long productId, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIterationIdsByNameOrderBySort(String name, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getIterationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countIterationIds() throws ServiceException, ServiceDaoException;
	

}

