package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Comment;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface CommentService extends BaseDaoService {


    public Long insert(Comment comment) throws ServiceException, ServiceDaoException;


    public List<Comment> insertList(List<Comment> commentList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Comment comment) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Comment> commentList) throws ServiceException, ServiceDaoException;


    public Comment getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Comment> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCommentIdsByDid(Long did) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCommentIdsByDid(Long did, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCommentIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCommentIds() throws ServiceException, ServiceDaoException;


    public List<Long> getLastCommentIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

}

