package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Classes;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ClassesService extends BaseDaoService {


    public Long insert(Classes classes) throws ServiceException, ServiceDaoException;


    public List<Classes> insertList(List<Classes> classesList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Classes classes) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Classes> classesList) throws ServiceException, ServiceDaoException;


    public Classes getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Classes> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countClassesIdsByOidAndGrade(Long oid, Long grade) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countClassesIdsByOid(Long oid) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countClassesIdsByType(String type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassesIdsByOidAndGrade(Long oid, Long grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassesIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassesIdsByOid(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassesIdsByType(String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassesIdsByOidAndName(Long oid, String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassesIdsByOidAndNameAndType(Long oid, String name,String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassesIdsByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassesIdsByTypeAndName(String type, String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassesIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countClassesIds() throws ServiceException, ServiceDaoException;

    public List<Long> getClassesIdsbyOccupation(Long oid, Long start, Long limit) throws ServiceException, ServiceDaoException;

    public List<Long> getClassesIdsbyOccupationAndType(Long oid,String type, Long start, Long limit, Integer classesStart, Integer classesSize) throws ServiceException, ServiceDaoException;

    public List<Long> getLastClassesIdByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

}



