package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Card;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface CardService extends BaseDaoService {

	



   		   
		
		public Long insert(Card card)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Card> insertList(List<Card> cardList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Card card)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Card> cardList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Card getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Card> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCardIdsByOwnerIdOrderByCreateAt(Integer ownerId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCardIdsByStatusAndOwnerIdOrderByCreateAt(Integer status, Integer ownerId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCardIdsByOwnerIdOrderByCreateAt(Integer ownerId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCardIdsByStatusAndOwnerIdOrderByCreateAt(Integer status, Integer ownerId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getCardIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countCardIds() throws ServiceException, ServiceDaoException;
	

}

