package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.ArticleTaskRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ArticleTaskRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(ArticleTaskRelation articleTaskRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<ArticleTaskRelation> insertList(List<ArticleTaskRelation> articleTaskRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(ArticleTaskRelation articleTaskRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<ArticleTaskRelation> articleTaskRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public ArticleTaskRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<ArticleTaskRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countArticleTaskRelationIdsByDid(Long did)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countArticleTaskRelationIdsByTid(Long tid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleTaskRelationIdsByDid(Long did,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getTidsByDid(Long did,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getDidsByTid(Long tid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countDidsByTid(Long tid)throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleTaskRelationIdsByTid(Long tid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getArticleTaskRelationIdByDidAndTid(Long did,Long tid)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getArticleTaskRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countArticleTaskRelationIds() throws ServiceException, ServiceDaoException;
	

}

