package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Article;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ArticleService extends BaseDaoService {


    public Long insert(Article article) throws ServiceException, ServiceDaoException;


    public List<Article> insertList(List<Article> articleList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Article article) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Article> articleList) throws ServiceException, ServiceDaoException;


    public Article getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Article> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countArticleIdsByCidAndType(Long cid, String type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getArticleIdsByCidAndType(Long cid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;






    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getArticleIdsByUidAndType(Long uid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    public Integer counttArticleIdsByUidAndType(Long uid, String type) throws ServiceException, ServiceDaoException;



    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getArticleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countArticleIds() throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getLastArticleIdByUidAndCid(Long uid,Long cid) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getArticleIdByUidAndCid(Long uid,Long cid,Integer start,Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getArticleIdsByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countArticleIdsByOidAndType(Long oid, String type) throws ServiceException, ServiceDaoException;

}

