package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "user_score")
public class UserScore implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 6399576184990466048L;

    /*学分变更类型，默认为0：加分  1：扣分*/
    public static final int SCORE_TYPE_ADD = 0;
    public static final int SCORE_TYPE_REDUCE = 1;

    /*旷课人-3分*/
    public static final long CLASSES_ABSENT = 3;

    /*给师弟小课堂评级，辅导师兄+2分*/
    public static final long SCORE_MAKE_CLASS_LEVEL = 2;

    /*给师弟小课堂评级，辅导师兄加分的加分消息内容*/
    public static final String MAKE_CLASS_LEVEL = "给师弟小课堂评级";

    private Long id;

    private Long uid;

    private Integer scoreType;

    private Long score;

    private String comment;

    private Long createBy;

    private Long updateBy;

    private Long updateAt;

    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "score")
    public Long getScore() {
        return score;
    }


    public void setScore(Long score) {
        this.score = score;
    }

    @Column(name = "scoreType")
    public Integer getScoreType() {
        return scoreType;
    }

    public void setScoreType(Integer scoreType) {
        this.scoreType = scoreType;
    }

    @Column(name = "comment")
    public String getComment() {
        return comment;
    }


    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

