package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user_info")
public class UserInfo implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = 7663223707428304896L;


  /**
   * 学费支付模式 0=默认 10=全款 20= 分期
   */
  public static final Integer PAY_TYPE_DEFAULT = 0;
  public static final Integer PAY_TYPE_FULL = 10;
  public static final Integer PAY_TYPE_STAGE = 20;

  /**
  * 贷款还清状态 0=未还清 1= 已还清
  *
  */
  public static final Integer STAGE_STATUS_NOT_OFF = 0;
  public static final Integer STAGE_STATUS_OFF = 1;


  private Long id;

  private Long ieventId;

  private BigDecimal tuition;


  private Long ruleId;


  private Integer payType;

  private Integer stageStatus;

  private Long offAt;


  private BigDecimal inviteMoney;


  private Integer ivMsgCount;


  private Long createBy;


  private Long updateBy;


  private Long updateAt;


  private Long createAt;


  @Id
//     	   @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }


  @Column(name = "ievent_id")
  public Long getIeventId() {
    return ieventId;
  }

  public void setIeventId(Long ieventId) {
    this.ieventId = ieventId;
  }


  @Column(name = "tuition")
  public BigDecimal getTuition() {
    return tuition;
  }


  public void setTuition(BigDecimal tuition) {
    this.tuition = tuition;
  }

  @Column(name = "rule_id")
  public Long getRuleId() {
    return ruleId;
  }


  public void setRuleId(Long ruleId) {
    this.ruleId = ruleId;
  }

  @Column(name = "pay_type")
  public Integer getPayType() {
    return payType;
  }


  public void setPayType(Integer payType) {
    this.payType = payType;
  }

  @Column(name = "stage_status")
  public Integer getStageStatus() {
    return stageStatus;
  }

  public void setStageStatus(Integer stageStatus) {
    this.stageStatus = stageStatus;
  }

  @Column(name = "off_at")
  public Long getOffAt() {
    return offAt;
  }

  public void setOffAt(Long offAt) {
    this.offAt = offAt;
  }

  @Column(name = "invite_money")
  public BigDecimal getInviteMoney() {
    return inviteMoney;
  }


  public void setInviteMoney(BigDecimal inviteMoney) {
    this.inviteMoney = inviteMoney;
  }

  @Column(name = "iv_msg_count")
  public Integer getIvMsgCount() {
    return ivMsgCount;
  }

  public void setIvMsgCount(Integer ivMsgCount) {
    this.ivMsgCount = ivMsgCount;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }


  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }

}

