package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3963145948088947712L;
    
    
    /**
     * 排序方式 按注册时间排序
     */
    
    public static final int Sort_Register=1;
    
    /**
     * 排序方式 按真实项目时间排序
     */
    
    public static final int Sort_Real=2;

    /**
     * 排序方式 按事件发生时间降序
     */

    public static final int Sort_Event_Happen=3;
    

    /**
     * 用户身份:
     * 10、无名弟子 20、散修弟子 30、外门弟子 40、内门弟子  50、首席弟子  55 荣耀师兄 60、真传弟子  70、修真长老
    
     * 80 顾问，90 结业，95 入职，100 退学 ,
     *
     * 110 预生成的未注册用户，优惠卷发放时产生
     */


    /**
     * 身份-无名弟子
     */
    public static final int Identity_Unname = 10;
    
    /**
     * 身份-散修弟子
     */
    public static final int Identity_Online = 20;
    
    /**
     * 身份-外门弟子
     */
    public static final int Identity_Outside = 30;
    
    /**
     * 身份-内门弟子
     */
    
    public static final int Identity_Offline = 40;
    /**
     * 身份-首席弟子
     */
    public static final int Identity_chief=50;
    /**
     * 身份-荣耀弟子
     */
    public static final int Identity_Hornour = 55;
    

    /**
     * 身份-真传弟子
     */
    public static final int Identity_Offical = 60;
    
    
    
    /**
     * 身份-长老
     */
    public static final int Identity_Elder = 70;
    
    /**
     * 身份-顾问
     */
    public static final int Identity_Adviser = 80;

  
    /**
     * 身份-结业
     */
    public static final int Identity_Graduate = 90;
    
    
    /**
     * 身份-入职
     */
    public static final int Identity_Work = 95;
    
    
    /**
     * 身份-退学
     */
    public static final int Identity_Stop = 100;

    /**
    * 身份-预生成的未注册用户，优惠卷发放时产生
    *
    */
    public static final int Identity_PreGenerate = 110;

    public static final int User_Talent_Low = 10;
    public static final int User_Talent_Normal = 20;
    public static final int User_Talent_High = 30;


    public static final Long SGUID = 3576L;


    public static final String TYPE_None = "none";

    public static final Long TeacherID_None = -1L;

    public static final int Level_None = 10;

 

    public static final int Status_Teacher = 1;

    public static final Long Occupation_None = -1L;

    public static final int Daily_None = 0;

    public static final String Rate_Zero = "0.0000";

    /**
     * 无当前所在班级
     */
    public static final Long Classes_None = -1L;


    /**
     * 无学号
     */
    public static final Integer Study_Number_None = -1;


    /**
     * 学习阶段 1任务 2复盘 3真实
     */
    public static final int LEARN_PHASE_TASK = 1;
    public static final int LEARN_PHASE_REPLAY = 2;
    public static final int LEARN_PHASE_REAL = 3;

    /*
     * QUIT_SCHOOL：学员退出校园
     * JOIN_SCHOOL：学员加入校园
     * */
    public static final String QUIT_SCHOOL = "0";
    public static final String JOIN_SCHOOL = "1";
    
    

    
    
    
 

    
    /**
     * 状态预备-指未报名学习的
     */
    public static final Integer STATUS_Online = -3;
    
    /**
     * 状态:外门学习-指已经报名外门
     */
    public static final int Status_Study_Outside = -1;
    
    /**
     * 状态:内门学习-指已经报名内门的
     */
    public static final int Status_Study_Offline = 10;
    
    /**
     * 状态结业-指已经结业的
     */
    public static final Integer STATUS_Graduate = 3;
    
  

    /**
     * 25期  用户在课堂小组中的身份 1：组员  2:小组长
     */
    public static final Integer IDENTITY_NORMAL_MEMBER = 1;
    public static final Integer IDENTITY_LEADER = 2;

    public static final Long GROUP_DEFAULT_ID = Long.valueOf(0);
    public static final Long GROUP_DEFAULT_JOINTIME = 0l;
    public static final Integer GROUP_DEFAULT_IDENTITY = 0;
    
    
   
   

    
    /**
     * 首席-非首席
     */    
    
    public static final int Head_Unhead = -1;
    /**
     * 首席-见习
     */
    public static final int Head_Pratice = 1;
    
    /**
     * 首席-正式
     */
    public static final int Head_Offical = 2;
    
    
  
    /**
     * 考察-非考察
     */
    public static final int Review_Unreview = -1;
    
    /**
     * 考察-正式
     */
    public static final int Review_Review = 1;

    /**
    * 典型师兄状态 0=否 1=yes
    *
    */
    public static final Integer Typical_status_yes = 1;
    public static final Integer Typical_status_no = 0;





    private Long id;


    private String nick;


    private String qq;


    private String mobile;


    private String pwd;


    private Long sex;


    private String thumb;


    private Integer isLook;


    private String sign;


    private Long birthday;


    private String school;


    private String province;


    private String city;


    private String branchName;


    private String oidName;



    /**
     * 学号，在用户表里冗余一份，方便查询
     */
    private int studyNumber;

    /**
     * 日报数量
     */
    private int dailyCount = User.Daily_None;

    private String dailyRate = User.Rate_Zero;

    /**
     * 最新的班级ID，为负代表着当前没有班级
     */
    private Long cid = User.Classes_None;


    /**
     * 最新的用户和班级关联表ID，为负代表着当前没有班级
     */
    private Long userClassID = User.Classes_None;

    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long lastDaily;


    private Long createAt;

    private String source;


    private Long oid = User.Occupation_None;


    private Integer level = User.Level_None;


    private Long teacherId = User.TeacherID_None;

    /**
     * 学员状态：-1：在学   1：退学  2 ：待业   3 ：结业   5：请假
     */
    @Deprecated
    private Integer status = User.STATUS_Online;
   

    private Long startAt;
    private Long lastTaskId;
    private BigDecimal value = new BigDecimal("0");
    private Integer branch;
    private Long graduateAt;

    private Integer identity=User.Identity_Unname;
    private String entranceVideo;
    private String graduatedVideo;
    private String entranceVideoPage;
    private String graduatedVideoPage;
    private String companyName;
    private String salaryLow;
    private String salaryHigh;
    private String invitationCode;
    private Long recommendId;
    private Integer recommendCount = 0;
    private Integer salary;
    private String latestMsg;
    private Integer score = 0;
    private Integer hours = 0;
    //20 期
    private String userTeamId = "-1";

    //22期 - 冗余字段，档案状态，默认为1-未提交
    // (2 - 申请中，3 - 已存档， 4 - 未通过)
    private Integer recordStatus;

    //24期 加校园id
    private Long schoolId;

    /**
     * 23期学习阶段
     */
    private Integer learnPhase = LEARN_PHASE_TASK;


    /**
     * 23期职位
     */
    private String job;
    /**
     * 23期简介
     */
    private String intro;
    /**
     * 23期学习经历
     */
    private String educationExp;


    /**
     * 25期 课堂小组id  在课堂小组中的身份  加入课堂小组的时间
     */
    private Long groupId = GROUP_DEFAULT_ID;
    private Integer IdentityInclass;
    private Long joinTime;

    /**
     *  天赋 10 低，20 普通，30 高
     */
    private int talent;
    
    
    /**
     * 请假状态
     * 未请假  -1，事假 1 ，病假 2，逃学 3,休学 4
     * 
     */
    private Integer leave=-1;
    
    /**
     * 计划结业时间
     */
    private  Long planGraduateAt=-1L;
    
    /**
     * 首席状态
     * 非首席 -1 ，见习 1 ，首席 2
     */
    
    private  Integer headStatus=User.Head_Unhead;
    
    /**
     * 考察状态
     * 非考察 -1,考察 1
     */
    private  Integer reviewStatus=User.Review_Unreview;
    
    /**
    * 32期 典型师兄状态
    *
    */
    private Integer typicalStatus = User.Typical_status_no;

    @Column(name = "group_id")
    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    @Column(name = "identity_inclass")
    public Integer getIdentityInclass() {
        return IdentityInclass;
    }

    public void setIdentityInclass(Integer identityInclass) {
        IdentityInclass = identityInclass;
    }

    @Column(name = "join_time")
    public Long getJoinTime() {
        return joinTime;
    }

    public void setJoinTime(Long joinTime) {
        this.joinTime = joinTime;
    }


    @Column(name = "record_status")
    public Integer getRecordStatus() {
        return recordStatus;
    }

    public void setRecordStatus(Integer recordStatus) {
        this.recordStatus = recordStatus;
    }

    @Column(name = "user_team_id")
    public String getUserTeamId() {
        return userTeamId;
    }

    public void setUserTeamId(String userTeamId) {
        this.userTeamId = userTeamId;
    }


    @Column(name = "latest_msg")
    public String getLatestMsg() {
        return latestMsg;
    }

    public void setLatestMsg(String latestMsg) {
        this.latestMsg = latestMsg;
    }

    @Column(name = "salary")
    public Integer getSalary() {
        return salary;
    }

    public void setSalary(Integer salary) {
        this.salary = salary;
    }

    @Column(name = "invitation_code")
    public String getInvitationCode() {
        return invitationCode;
    }

    public void setInvitationCode(String invitationCode) {
        this.invitationCode = invitationCode;
    }

    @Column(name = "recommend_id")
    public Long getRecommendId() {
        return recommendId;
    }

    public void setRecommendId(Long recommendId) {
        this.recommendId = recommendId;
    }


    @Column(name = "recommend_count")
    public Integer getRecommendCount() {
        return recommendCount;
    }

    public void setRecommendCount(Integer recommendCount) {
        this.recommendCount = recommendCount;
    }

    @Column(name = "company_name")
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Column(name = "salary_low")
    public String getSalaryLow() {
        return salaryLow;
    }

    public void setSalaryLow(String salaryLow) {
        this.salaryLow = salaryLow;
    }

    @Column(name = "salary_high")
    public String getSalaryHigh() {
        return salaryHigh;
    }

    public void setSalaryHigh(String salaryHigh) {
        this.salaryHigh = salaryHigh;
    }


    @Column(name = "branch")
    public Integer getBranch() {
        return branch;
    }

    public void setBranch(Integer branch) {
        this.branch = branch;
    }

    @Column(name = "graduate_at")
    public Long getGraduateAt() {
        return graduateAt;
    }

    public void setGraduateAt(Long graduateAt) {
        this.graduateAt = graduateAt;
    }

    @Column(name = "identity")
    public Integer getIdentity() {
        return identity;
    }

    public void setIdentity(Integer identity) {
        this.identity = identity;
    }

    @Column(name = "entrance_video")
    public String getEntranceVideo() {
        return entranceVideo;
    }

    public void setEntranceVideo(String entranceVideo) {
        this.entranceVideo = entranceVideo;
    }

    @Column(name = "graduated_video")
    public String getGraduatedVideo() {
        return graduatedVideo;
    }

    public void setGraduatedVideo(String graduatedVideo) {
        this.graduatedVideo = graduatedVideo;
    }

    @Column(name = "entrance_video_page")
    public String getEntranceVideoPage() {
        return entranceVideoPage;
    }

    public void setEntranceVideoPage(String entranceVideoPage) {
        this.entranceVideoPage = entranceVideoPage;
    }

    @Column(name = "graduated_video_page")
    public String getGraduatedVideoPage() {
        return graduatedVideoPage;
    }

    public void setGraduatedVideoPage(String graduatedVideoPage) {
        this.graduatedVideoPage = graduatedVideoPage;
    }

    @Transient
    public String getDailyRate() {
        return dailyRate;
    }

    public void setDailyRate(String dailyRate) {
        this.dailyRate = dailyRate;
    }

    @Column(name = "value")
    public BigDecimal getValue() {
        return value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Column(name = "last_task_id")
    public Long getLastTaskId() {
        return lastTaskId;
    }

    public void setLastTaskId(Long lastTaskId) {
        this.lastTaskId = lastTaskId;
    }

    @Column(name = "start_at")
    public Long getStartAt() {
        return startAt;
    }

    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    @Column(name = "oid")
    public Long getOid() {
        return oid;
    }


    public void setOid(Long oid) {
        this.oid = oid;
    }

    @Column(name = "level")
    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    @Column(name = "teacher_id")
    public Long getTeacherId() {
        return teacherId;
    }

    public void setTeacherId(Long teacherId) {
        this.teacherId = teacherId;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "nick")
    public String getNick() {
        return nick;
    }


    public void setNick(String nick) {
        this.nick = nick;
    }

    @Column(name = "qq")
    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "pwd")
    public String getPwd() {
        return pwd;
    }


    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @Column(name = "sex")
    public Long getSex() {
        return sex;
    }


    public void setSex(Long sex) {
        this.sex = sex;
    }

    @Column(name = "source")
    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }


    @Column(name = "thumb")
    public String getThumb() {
        return thumb;
    }


    public void setThumb(String thumb) {
        this.thumb = thumb;
    }

    @Column(name = "sign")
    public String getSign() {
        return sign;
    }


    public void setSign(String sign) {
        this.sign = sign;
    }

    @Column(name = "birthday")
    public Long getBirthday() {
        return birthday;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    @Column(name = "school")
    public String getSchool() {
        return school;
    }

    public void setSchool(String school) {
        this.school = school;
    }

    @Column(name = "province")
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    @Column(name = "city")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Column(name = "score")
    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    @Column(name = "hours")
    public Integer getHours() {
        return hours;
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }


   
    @Column(name = "daily_count")
    public int getDailyCount() {
        return dailyCount;
    }


    public void setDailyCount(int dailyCount) {
        this.dailyCount = dailyCount;
    }

    @Column(name = "last_daily")
    public Long getLastDaily() {
        return this.lastDaily;
    }


    public void setLastDaily(Long lastDaily) {
        this.lastDaily = lastDaily;
    }

    @Column(name = "cid")
    public Long getCid() {
        return cid;
    }


    public void setCid(Long cid) {
        this.cid = cid;
    }


    @Column(name = "study_number")
    public int getStudyNumber() {
        return studyNumber;
    }


    public void setStudyNumber(int studyNumber) {
        this.studyNumber = studyNumber;
    }


    @Column(name = "user_class_id")
    public Long getUserClassID() {
        return userClassID;
    }


    public void setUserClassID(Long userClassID) {
        this.userClassID = userClassID;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }


    @Column(name = "is_look")
    public Integer getIsLook() {
        return isLook;
    }

    public void setIsLook(Integer isLook) {

        this.isLook = isLook;
    }


    @Column(name = "school_id")
    public Long getSchoolId() {
        return schoolId;
    }

    public void setSchoolId(Long schoolId) {
        this.schoolId = schoolId;
    }

    @Column(name = "learn_phase")
    public Integer getLearnPhase() {
        return learnPhase;
    }

    public void setLearnPhase(Integer learnPhase) {
        this.learnPhase = learnPhase;
    }

    @Column(name = "job")
    public String getJob() {
        return job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    @Column(name = "intro")
    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    @Column(name = "education_exp")
    public String getEducationExp() {
        return educationExp;
    }

    public void setEducationExp(String educationExp) {
        this.educationExp = educationExp;
    }

    @Transient
    public String getBranchName() {
        return branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    @Transient
    public String getOidName() {
        return oidName;
    }

    public void setOidName(String oidName) {
        this.oidName = oidName;
    }


    @Column(name = "talent")
    public int getTalent() {
        return talent;
    }

    public void setTalent(int talent) {
        this.talent = talent;
    }
    
    
    
    
    
    @Column(name = "uleave")    
    public Integer getLeave() {
		return leave;
	}

	public void setLeave(Integer leave) {
		this.leave = leave;
	}

	
	 @Column(name = "plan_graduate_at")
	public Long getPlanGraduateAt() {
		return planGraduateAt;
	}

	public void setPlanGraduateAt(Long planGraduateAt) {
		this.planGraduateAt = planGraduateAt;
	}

	 @Column(name = "head_status")
	public Integer getHeadStatus() {
		return headStatus;
	}

	public void setHeadStatus(Integer headStatus) {
		this.headStatus = headStatus;
	}

	 @Column(name = "review_status")
	public Integer getReviewStatus() {
		return reviewStatus;
	}

	public void setReviewStatus(Integer reviewStatus) {
		this.reviewStatus = reviewStatus;
	}

    @Column(name = "typical_status")
    public Integer getTypicalStatus() {
        return typicalStatus;
    }

    public void setTypicalStatus(Integer typicalStatus) {
        this.typicalStatus = typicalStatus;
    }



    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

