package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "score")
public class Score implements Serializable{

	/**
	 *
	 */
	private static final long serialVersionUID = 3846591164320247808L;


	/**
	 *  上架状态
	 *
	 */
	public static final Integer STATUS_ON = 1;

	/**
	 *  下架状态
	 *
	 */
	public static final Integer STATUS_OFF = 0;

	/**
	 *  排序初始值
	 *
	 */
	public static final Integer DEFAULT_SORT = 0;



	private  Long id;


	private  Long occupationId;


	private  Long problemId;


	private  Long optionId;


	private  Integer score;


	private  String reason;


	private  Integer status;


	private  Integer sort;


	private  Long createBy;


	private  Long updateBy;


	private  Long updateAt;


	private  Long createAt;

	private String occupationName;




	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name = "id")
	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}
	@Column(name = "occupation_id")
	public Long getOccupationId() {
		return occupationId;
	}


	public void setOccupationId(Long occupationId) {
		this.occupationId = occupationId;
	}
	@Column(name = "problem_id")
	public Long getProblemId() {
		return problemId;
	}


	public void setProblemId(Long problemId) {
		this.problemId = problemId;
	}
	@Column(name = "option_id")
	public Long getOptionId() {
		return optionId;
	}


	public void setOptionId(Long optionId) {
		this.optionId = optionId;
	}
	@Column(name = "score")
	public Integer getScore() {
		return score;
	}


	public void setScore(Integer score) {
		this.score = score;
	}
	@Column(name = "reason")
	public String getReason() {
		return reason;
	}


	public void setReason(String reason) {
		this.reason = reason;
	}
	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}


	public void setStatus(Integer status) {
		this.status = status;
	}
	@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}


	public void setSort(Integer sort) {
		this.sort = sort;
	}
	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}


	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}


	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}


	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}


	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}



	@Transient
	public String getOccupationName() {
		return occupationName;
	}

	public void setOccupationName(String occupationName) {
		this.occupationName = occupationName;
	}



	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

