package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "t_order")
public class Order implements Serializable{

	private static final long serialVersionUID = 1979445464555898880L;


	//生成订单方式
	public static final Integer ORDER_WAY_1 = 1;//购物车
	public static final Integer ORDER_WAY_2 = 2;//立即支付
	public static final Integer FAILURE = 2;
	public static final Integer UNPAID = 2;

	//支付方式
	public static final int PAYMANNER_1 = 1;//系统账号
	public static final int PAYMANNER_2 = 2;//银行卡
	public static final int PAYMANNER_3 = 3;//支付宝
	public static final int PAYMANNER_4 = 4;//微信支付

	/**
	 * 1-新购买 2-续费
	 */
	public static final Integer BUY=1;
	public static final Integer RENEW=2;

	/**
	* 生成订单type区分
	*
	*/
	public static  final String CREATE_TYPE_ADVISORY = "advisory";

	public static final String CREATE_TYPE_JNSHU = "wx_jnshu";
	/**
	* 订单类型 category
	 * 0 = 旧数据/学员服务器订单
	 *
	 * 10 = 咨询订单
	*
	*/
	public static final Integer CATEGORY_SERVER =0;

	public static final Integer CATEGORY_ADVISORY = 10;
	public static final Integer CATEGORY_JNSHU = 20;
	/**
	* 订单一级编号分类规则
	 * 01 = 服务器
	 * 02 = 咨询
	*
	*/
	public static final String ORDER_NO_TOP_TYPE_SERVER = "01";
	public static final String ORDER_NO_TOP_TYPE_ADVISORY = "02";
	public static final String ORDER_NO_TOP_TYPE_JNSHU = "03";
	/**
	 * 订单二级编号分类规则
	 * 01 =  一对一VIP
	 *
	 *
	 */
	public static final String ORDER_NO_SUB_TYPE_1V1VIP = "01";
	public static final String ORDER_NO_SUB_TYPE_COURSE_JNSHU = "02";


	private  Long id;


    private  String name;


    private  String totalPrice;


	private  Long buyer;

    // 支付方式
	private Integer payManner;


	private String mobile;

    /*
    * 1.已付款 2.未付款 3.完成4.已发货
    */
    private  Integer status;

    private  Integer count;

	private Integer jcount;


	private  Long payAt;


	private Long confirmAt;


	private Long submitAt;

	private Long sendAt;



	private  String orderId;


	private  Long createBy;


    private  Long updateBy;


    private  Long updateAt;


    private  Long createAt;
	private Integer type;
	private Long accountId;

	private Integer category = 0;
	private Long goods;
	private Long deadAt;
	private String price;

	@Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}

	@Transient
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
	@Transient
	public Long getAccountId() {
		return accountId;
	}

	public void setAccountId(Long accountId) {
		this.accountId = accountId;
	}

	@Column(name = "name")
	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}
	@Column(name = "total_price")
	public String getTotalPrice() {
				return totalPrice;
			}

	public void setTotalPrice(String totalPrice) {
		this.totalPrice = totalPrice;
	}
	@Column(name = "price")
	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}



	@Column(name = "buyer")
	public Long getBuyer() {
		return buyer;
	}


	public void setBuyer(Long buyer) {
		this.buyer = buyer;
	}


	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}


	public void setStatus(Integer status) {
		this.status = status;
	}

   @Column(name = "mobile")
	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}


	@Column(name = "send_at")
	public Long getSendAt() {
		return sendAt;
	}

	public void setSendAt(Long sendAt) {
		this.sendAt = sendAt;
	}
	@Column(name = "goods")
	public Long getGoods() {
		return goods;
	}

	public void setGoods(Long goods) {
		this.goods = goods;
	}
	@Column(name = "dead_at")
	public Long getDeadAt() {
		return deadAt;
	}

	public void setDeadAt(Long deadAt) {
		this.deadAt = deadAt;
	}





	@Column(name = "count")
	public Integer getCount() {
		return count;
	}


	public void setCount(Integer count) {
		this.count = count;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}


	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}


	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}


	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}

    @Column(name = "buy_time")
	public Long getPayAt() {
		return payAt;
	}

	public void setPayAt(Long payAt) {
		this.payAt = payAt;
	}


	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}


	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}


    @Column(name = "order_number")
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}


	@Column(name = "pay_manner")
	public Integer getPayManner() {
		return payManner;
	}

	public void setPayManner(Integer payManner) {
		this.payManner = payManner;
	}


	@Column(name = "jcount")
	public Integer getJcount() {
		return jcount;
	}

	public void setJcount(Integer jcount) {
		this.jcount = jcount;
	}



	@Column(name = "confirm_at")
	public Long getConfirmAt() {
		return confirmAt;
	}

	public void setConfirmAt(Long confirmAt) {
		this.confirmAt = confirmAt;
	}

	@Column(name = "submit_at")
	public Long getSubmitAt() {
		return submitAt;
	}

	public void setSubmitAt(Long submitAt) {
		this.submitAt = submitAt;
	}

	@Column(name = "category")
	public Integer getCategory() {
		return category;
	}

	public void setCategory(Integer category) {
		this.category = category;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}





}