package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "answer")
public class Answer implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8508554735449735168L;


	/**
	 * orderBy 排序
	 * 1 点赞数排序
	 * 2 创建时间排序
	 * 3 修改时间排序
	 *
	 */
	public static final Integer ORDER_BY_LIKE_NUM = 1;
	public static final Integer ORDER_BY_CREATE_AT = 2;
	public static final Integer ORDER_BY_UPDATE_AT = 3;

	/**
	 * isAgree 踩坑
	 * 0 未踩坑
	 * 1 已踩坑
	 */
	public static final Integer IS_AGREE_FALSE = 0;
	public static final Integer IS_AGREE_TRUE = 1;


   	 
    private  Long id;
	
  	 
    private  Long questionId;
	
  	 
    private  String content;
	
	//默认点赞数为0
    private  Integer likeNum=0;

	//isLike表示是否点赞，临时字段，不存入数据库  0 否 1 是
	@Transient
    private  Integer isLike=0;
	
	//默认状态为展示
    private  Integer status=Constants.STATUS_SHOW;
	
  	 
    private  Long createBy;
	
  	 
    private  Long createAt;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;




         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "question_id")
	public Long getQuestionId() {
		return questionId;
	}
	
	
	public void setQuestionId(Long questionId) {
		this.questionId = questionId;
	}
		 	@Column(name = "content")
	public String getContent() {
		return content;
	}
	
	
	public void setContent(String content) {
		this.content = content;
	}
		 	@Column(name = "like_num")
	public Integer getLikeNum() {
		return likeNum;
	}

	@Transient
	public void setLikeNum(Integer likeNum) {
		this.likeNum = likeNum;
	}
	@Transient
	public Integer getIsLike() {
		return isLike;
	}
	
	
	public void setIsLike(Integer isLike) {
		this.isLike = isLike;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

