package com.ptteng.common.skill.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

/**
 * Created by lhwarthas on 16/4/16.
 */
public class OrderIdUtil {

  public static String generateOrderId(String type) {
    StringBuffer sb = new StringBuffer();
    sb.append(type);
    Date date = new Date();
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss");
    String dateString = simpleDateFormat.format(date);
    sb.append(dateString);
    Random random = new Random();
    for (int i = 0; i < 3; i++) {
      sb.append(random.nextInt(10));
    }
    return sb.toString();
  }

  /**
   * 2019 08 27 生成订单号新规则 1. 设计规则：类别2位 + 子类别2位 + 毫秒时间戳13位 + 随机数3位
   * <p>
   * 2. 举个例子：职业测评（01） + 一对一VIP（01） + （时间戳）1563768181867 + （random）385
   */
  public static String generateNewOrderId(String topType, String subType) {
    StringBuffer sb = new StringBuffer();
    sb.append(topType);
    sb.append(subType);
    sb.append(System.currentTimeMillis());
    Random random = new Random();
    for (int i = 0; i < 3; i++) {
      sb.append(random.nextInt(10));
    }
    return sb.toString();
  }

    /**
     * 20191105 流水号规则
     * 1.设计规则：流水类型2位+类别2位+子类别2位+时间缀13位+随机码3位
     * 2.例：微信提现0201021311644894906235
     *
     * 流水类型：
     * 收入：01
     * 支出：02
     *
     * 支出类别：
     * 提现01
     *
     * 支出子类别：
     * 支付宝01
     * 微信02
     * 银行卡03
     *
     * 收入类别：
     * 技能树宣传大使01
     *
     * 收入子类别：
     * 线上学费01
     * 线下学费02
     */
  public static String getAssetFlowOrderNo(String flowType,String topType, String subType) {
    StringBuffer sb = new StringBuffer();
      sb.append(flowType);
      sb.append(topType);
    sb.append(subType);
    sb.append(System.currentTimeMillis());
    Random random = new Random();
    for (int i = 0; i < 3; i++) {
      sb.append(random.nextInt(10));
    }
    return sb.toString();
  }


  public static String generateDealNo() {
    StringBuffer sb = new StringBuffer();
    Random random = new Random();
    for (int i = 0; i < 3; i++) {
      sb.append(random.nextInt(10));
    }
    Date date = new Date();
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss");
    String dateString = simpleDateFormat.format(date);
    sb.append(dateString);
    return sb.toString();
  }
}
