package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Advisory;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface AdvisoryService extends BaseDaoService {


    public Long insert(Advisory advisory) throws ServiceException, ServiceDaoException;


    public List<Advisory> insertList(List<Advisory> advisoryList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Advisory advisory) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Advisory> advisoryList) throws ServiceException, ServiceDaoException;


    public Advisory getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Advisory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getAdvisoryIdByOid(Long oid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAdvisoryIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countAdvisoryIds() throws ServiceException, ServiceDaoException;


}

