package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "clog")
public class Clog implements Serializable {

    private static final long serialVersionUID = 8522379959163514880L;

    /**
     * 操作类型-发放
     */
    public static final int TYPE_ASSIGN = 2;
    /**
     * 操作类型-申请使用未审核
     */
    public static final int TYPE_APPLY = 3;
    /**
     * 操作类型-核销通过
     */
    public static final int TYPE_VERIFICATED = 4;
    /**
     * 操作类型-核销拒绝
     */
    public static final int TYPE_UNVERIFICATED = 5;
    /**
     * 操作类型-转让
     */
    public static final int TYPE_CESSION = 6;
    /**
     * 操作类型-过期
     */
    public static final int TYPE_EXPIRE = 6;

    /**
     * 自增id
     */
    private Long id;

    /**
     * 卡券id
     */
    private Long cid;

    /**
     * 卡券类型id
     */
    private Long tid;

    /**
     * 操作类型
     */
    private Integer type;

    /**
     * 管理员id
     */
    private Long adminId;

    /**
     * 使用者id
     */
    private Long useId;

    /**
     * 接收人id
     */
    private Long receiveId;

    /**
     * 备注
     */
    private String remark;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "cid")
    public Long getCid() {
        return cid;
    }


    public void setCid(Long cid) {
        this.cid = cid;
    }

    @Column(name = "tid")
    public Long getTid() {
        return tid;
    }


    public void setTid(Long tid) {
        this.tid = tid;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "admin_id")
    public Long getAdminId() {
        return adminId;
    }


    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    @Column(name = "use_id")
    public Long getUseId() {
        return useId;
    }


    public void setUseId(Long useId) {
        this.useId = useId;
    }

    @Column(name = "receive_id")
    public Long getReceiveId() {
        return receiveId;
    }


    public void setReceiveId(Long receiveId) {
        this.receiveId = receiveId;
    }


    @Column(name = "remark")
    public String getRemark() {
        return remark;
    }


    public void setRemark(String remark) {
        this.remark = remark;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

