/**
 * 
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.service.CardService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class CardSCAClient implements CardService {

    private CardService cardService;

	public CardService getCardService() {
		return cardService;
	}
	
	
	public void setCardService(CardService cardService) {
		this.cardService =cardService;
	}
	
	
			   
		@Override
		public Long insert(Card card)throws ServiceException, ServiceDaoException{
		
		return cardService.insert(card);
		          
		
		}	
		  
    	   
		@Override
		public List<Card> insertList(List<Card> cardList)throws ServiceException, ServiceDaoException{
		
		return cardService.insertList(cardList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return cardService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Card card)throws ServiceException, ServiceDaoException{
		
		return cardService.update(card);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Card> cardList)throws ServiceException, ServiceDaoException{
		
		return cardService.updateList(cardList);
		          
		
		}	
		  
    	   
		@Override
		public Card getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return cardService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Card> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return cardService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCardIdsByOwnerIdOrderByCreateAt(Integer ownerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return cardService.getCardIdsByOwnerIdOrderByCreateAt(ownerId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCardIdsByStatusAndOwnerIdOrderByCreateAt(Integer status,Integer ownerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return cardService.getCardIdsByStatusAndOwnerIdOrderByCreateAt(status,ownerId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCardIdsByOwnerIdOrderByCreateAt(Integer ownerId)throws ServiceException, ServiceDaoException{
		
		return cardService.countCardIdsByOwnerIdOrderByCreateAt(ownerId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCardIdsByStatusAndOwnerIdOrderByCreateAt(Integer status,Integer ownerId)throws ServiceException, ServiceDaoException{
		
		return cardService.countCardIdsByStatusAndOwnerIdOrderByCreateAt(status,ownerId);
	
	
	}
	
		
	
		@Override
	public List<Long> getCardIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return cardService.getCardIds(start, limit);
	}

	@Override
	public Integer countCardIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return cardService.countCardIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return cardService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return cardService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   cardService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.cardService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

