package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "school")
public class School implements Serializable {

    /*
     * SCHOOL_IS_NOT_TOP：校园未置顶
     * SCHOOL_IS_TOP：校园置顶
     * SCHOOL_IS_NOT_CORPORATE：未加入合作校园
     * SCHOOL_IS_CORPORATE：已加入合作校园
     * SCHOOL_OFF_LINE：校园未上架
     * SCHOOL_ON_LINE：校园已上架
     * */
    private static final long serialVersionUID = 2403872713498906624L;

    public static final Integer SCHOOL_TYPE_985 = 1; //985
    public static final Integer SCHOOL_TYPE_211 = 2; //211
    public static final Integer SCHOOL_TYPE_NORMAL = 3; //非重点院校\

    public static final Integer SCHOOL_IS_NOT_TOP = 0;
    public static final Integer SCHOOL_IS_TOP = 1;
    public static final Integer SCHOOL_IS_NOT_CORPORATE = 0;
    public static final Integer SCHOOL_IS_CORPORATE = 1;
    public static final Integer SCHOOL_ON_LINE = 1;
    public static final Integer SCHOOL_OFF_LINE = 0;

    private Long id;

    private String name;

    private Integer schoolType;

    private String province;

    private String type;

    private String properties;

    private Long createBy;

    private Long updateBy;

    private Long updateAt;

    private Long createAt;

    //以下是24期新加字段（阮少楠）
    private String address;

    private String schoolAbstract;

    private String badge; //校徽

    private Integer isTop; //是否置顶 0：否 1：是

    private Integer isCorporate; //是否是合作校园 0：不是  1：是

    private Integer status; //上下架状态  0：默认值 1：上架 2：下架

    private String contactName; //联系人姓名

    private String contactPhone; //联系人电话

    private String contactQq; //联系人qq


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "province")
    public String getProvince() {
        return province;
    }


    public void setProvince(String province) {
        this.province = province;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "school_type")
    public Integer getSchoolType() {
        return schoolType;
    }

    public void setSchoolType(Integer schoolType) {
        this.schoolType = schoolType;
    }

    @Column(name = "type")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name = "properties")
    public String getProperties() {
        return properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "address")
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "school_abstract")
    public String getSchoolAbstract() {
        return schoolAbstract;
    }


    public void setSchoolAbstract(String schoolAbstract) {
        this.schoolAbstract = schoolAbstract;
    }

    @Column(name = "badge")
    public String getBadge() {
        return badge;
    }


    public void setBadge(String badge) {
        this.badge = badge;
    }

    @Column(name = "is_top")
    public Integer getIsTop() {
        return isTop;
    }


    public void setIsTop(Integer isTop) {
        this.isTop = isTop;
    }

    @Column(name = "is_corporate")
    public Integer getIsCorporate() {
        return isCorporate;
    }


    public void setIsCorporate(Integer isCorporate) {
        this.isCorporate = isCorporate;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "contact_name")
    public String getContactName() {
        return contactName;
    }


    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    @Column(name = "contact_phone")
    public String getContactPhone() {
        return contactPhone;
    }


    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    @Column(name = "contact_qq")
    public String getContactQq() {
        return contactQq;
    }

    public void setContactQq(String contactQq) {
        this.contactQq = contactQq;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

